/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection.v1_20_R1;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManagerAbstract;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

abstract class ReflectionReusedNms
extends ReflectionManagerAbstract {
    protected AtomicInteger entityCounter;
    protected Method entityDefaultSoundMethod;
    private final CraftMagicNumbers craftMagicNumbers = (CraftMagicNumbers)CraftMagicNumbers.class.getField("INSTANCE").get(null);

    @Override
    public final void setImpulse(Entity entity) {
        ((CraftEntity)entity).getHandle().at = true;
    }

    @Override
    public final ItemStack getBukkitItem(Object nmsItem) {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)nmsItem));
    }

    @Override
    public final ItemStack getCraftItem(ItemStack bukkitItem) {
        return CraftItemStack.asCraftCopy((ItemStack)bukkitItem);
    }

    public final DedicatedServer getMinecraftServer() {
        return ((CraftServer)Bukkit.getServer()).getServer();
    }

    @Override
    public final Object getNmsEntity(Entity entity) {
        return ((CraftEntity)entity).getHandle();
    }

    @Override
    public final int getCombinedIdByBlockData(BlockData data) {
        IBlockData state = ((CraftBlockData)data).getState();
        return Block.i((IBlockData)state);
    }

    @Override
    public final int getCombinedIdByItemStack(ItemStack itemStack) {
        Block block = CraftMagicNumbers.getBlock((Material)itemStack.getType());
        return Block.i((IBlockData)block.n());
    }

    @Override
    public final BlockData getBlockDataByCombinedId(int id) {
        return CraftBlockData.fromData((IBlockData)Block.a((int)id));
    }

    @Override
    public final ItemStack getItemStackByCombinedId(int id) {
        return new ItemStack(CraftMagicNumbers.getMaterial((Block)Block.a((int)id).b()));
    }

    public final WorldServer getWorldServer(World w) {
        return ((CraftWorld)w).getHandle();
    }

    @Override
    public final int getAmbientSoundInterval(Entity entity) {
        Object nmsEntity = this.getNmsEntity(entity);
        if (!(nmsEntity instanceof EntityInsentient)) {
            return -1;
        }
        return ((EntityInsentient)nmsEntity).M();
    }

    @Override
    public final int getIncrementedStateId(Player player) {
        EntityPlayer serverPlayer = (EntityPlayer)this.getNmsEntity((Entity)player);
        return serverPlayer.bR.k();
    }

    @Override
    public final int getNewEntityId() {
        return this.getNewEntityId(true);
    }

    @Override
    public final int getNewEntityId(boolean increment) {
        if (increment) {
            return this.entityCounter.incrementAndGet();
        }
        return this.entityCounter.get() + 1;
    }

    public final PlayerConnection getPlayerConnectionOrPlayer(Player player) {
        return ((EntityPlayer)this.getNmsEntity((Entity)player)).c;
    }

    @Override
    public final double[] getBoundingBox(Entity entity) {
        AxisAlignedBB aabb = ((net.minecraft.world.entity.Entity)this.getNmsEntity(entity)).cE();
        return new double[]{aabb.d - aabb.a, aabb.e - aabb.b, aabb.f - aabb.c};
    }

    public final EntityPlayer getPlayerFromPlayerConnection(Object nmsEntity) {
        return ((ServerPlayerConnection)nmsEntity).f();
    }

    @Override
    public final Entity getBukkitEntity(Object nmsEntity) {
        return ((net.minecraft.world.entity.Entity)nmsEntity).getBukkitEntity();
    }

    @Override
    public final double getPing(Player player) {
        return player.getPing();
    }

    @Override
    public final Float getSoundModifier(Object entity) {
        if (!(entity instanceof EntityLiving)) {
            return Float.valueOf(0.0f);
        }
        try {
            return (Float)this.entityDefaultSoundMethod.invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return Float.valueOf(0.0f);
        }
    }

    @Override
    public final void setBoundingBox(Entity entity, double x, double y, double z) {
        Location loc = entity.getLocation();
        ((net.minecraft.world.entity.Entity)this.getNmsEntity(entity)).a(new AxisAlignedBB(loc.getX() - x / 2.0, loc.getY(), loc.getZ() - z / 2.0, loc.getX() + x / 2.0, loc.getY() + y, loc.getZ() + z / 2.0));
    }

    @Override
    public final Material getMaterial(String name) {
        return this.craftMagicNumbers.getMaterial(name, this.craftMagicNumbers.getDataVersion());
    }

    public final EntityTypes getEntityType(EntityType entityType) {
        return EntityTypes.a((String)(entityType.getName() == null ? entityType.name().toLowerCase(Locale.ENGLISH) : entityType.getName())).orElse(null);
    }

    @Override
    public final int getEntityTypeId(EntityType entityType) {
        return this.getEntityTypeId(this.getEntityType(entityType));
    }

    @Override
    public final GameProfile getProfile(Player player) {
        return ((EntityPlayer)this.getNmsEntity((Entity)player)).fM();
    }

    @Override
    public final void addEntityTracker(Object trackedEntity, Object serverPlayer) {
        ((PlayerChunkMap.EntityTracker)trackedEntity).b((EntityPlayer)serverPlayer);
    }

    @Override
    public final void clearEntityTracker(Object trackedEntity, Object serverPlayer) {
        ((PlayerChunkMap.EntityTracker)trackedEntity).a((EntityPlayer)serverPlayer);
    }

    @Override
    public final Set getTrackedEntities(Object trackedEntity) {
        return ((PlayerChunkMap.EntityTracker)trackedEntity).f;
    }
}

