/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;

public class WatcherInfo {
    @SerializedName(value="a")
    private int added = -1;
    @SerializedName(value="b")
    private int removed = -1;
    @SerializedName(value="c")
    private boolean deprecated;
    @SerializedName(value="d")
    private String returnType;
    @SerializedName(value="e")
    private boolean randomDefault;
    @SerializedName(value="f")
    private String watcher;
    @SerializedName(value="g")
    private String method;
    @SerializedName(value="h")
    private String mappedAs;
    @SerializedName(value="i")
    private String param;
    @SerializedName(value="j")
    private String descriptor;
    @SerializedName(value="k")
    private String description;
    @SerializedName(value="l")
    private boolean noVisibleDifference;
    @SerializedName(value="m")
    private List<Integer> unusableBy = new ArrayList<Integer>();
    @SerializedName(value="n")
    private List<Integer> hiddenFor = new ArrayList<Integer>();

    public void setHiddenFor(DisguiseType[] types) {
        for (DisguiseType type : types) {
            this.hiddenFor.add(type.ordinal());
        }
    }

    public void setUnusableBy(DisguiseType[] types) {
        for (DisguiseType type : types) {
            this.unusableBy.add(type.ordinal());
        }
    }

    public boolean isSupported() {
        if (this.getAdded() >= 0 && this.added > ReflectionManager.getVersion().ordinal()) {
            return false;
        }
        return this.getRemoved() < 0 || this.removed > ReflectionManager.getVersion().ordinal();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WatcherInfo that = (WatcherInfo)object;
        return this.added == that.added && this.removed == that.removed && this.deprecated == that.deprecated && this.randomDefault == that.randomDefault && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.watcher, that.watcher) && Objects.equals(this.method, that.method) && Objects.equals(this.mappedAs, that.mappedAs) && Objects.equals(this.param, that.param) && Objects.equals(this.descriptor, that.descriptor) && Objects.equals(this.unusableBy, that.unusableBy) && Objects.equals(this.hiddenFor, that.hiddenFor);
    }

    @Generated
    public int getAdded() {
        return this.added;
    }

    @Generated
    public int getRemoved() {
        return this.removed;
    }

    @Generated
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Generated
    public String getReturnType() {
        return this.returnType;
    }

    @Generated
    public boolean isRandomDefault() {
        return this.randomDefault;
    }

    @Generated
    public String getWatcher() {
        return this.watcher;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getMappedAs() {
        return this.mappedAs;
    }

    @Generated
    public String getParam() {
        return this.param;
    }

    @Generated
    public String getDescriptor() {
        return this.descriptor;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isNoVisibleDifference() {
        return this.noVisibleDifference;
    }

    @Generated
    public List<Integer> getUnusableBy() {
        return this.unusableBy;
    }

    @Generated
    public List<Integer> getHiddenFor() {
        return this.hiddenFor;
    }

    @Generated
    public void setAdded(int added) {
        this.added = added;
    }

    @Generated
    public void setRemoved(int removed) {
        this.removed = removed;
    }

    @Generated
    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Generated
    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    @Generated
    public void setRandomDefault(boolean randomDefault) {
        this.randomDefault = randomDefault;
    }

    @Generated
    public void setWatcher(String watcher) {
        this.watcher = watcher;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public void setMappedAs(String mappedAs) {
        this.mappedAs = mappedAs;
    }

    @Generated
    public void setParam(String param) {
        this.param = param;
    }

    @Generated
    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setNoVisibleDifference(boolean noVisibleDifference) {
        this.noVisibleDifference = noVisibleDifference;
    }
}

