/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import java.util.Arrays;
import lombok.Generated;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;

public enum NmsVersion {
    v1_12("1.12", "1.12.1", "1.12.2"),
    v1_13("1.13", "1.13.1", "1.13.2"),
    v1_14("1.14", "1.14.1", "1.14.2", "1.14.3", "1.14.4"),
    v1_15("1.15", "1.15.1", "1.15.2"),
    v1_16("1.16", "1.16.1", "1.16.2", "1.16.3", "1.16.4", "1.16.5"),
    v1_17("1.17", "1.17.1"),
    v1_18_R1("1.18", "1.18.1"),
    v1_18_R2("1.18.2"),
    v1_19_R1("1.19", "1.19.1", "1.19.2"),
    v1_19_R2("1.19.3"),
    v1_19_R3("1.19.4"),
    v1_20_R1("1.20", "1.20.1"),
    v1_20_R2("1.20.2"),
    v1_20_R3("1.20.3", "1.20.4"),
    v1_20_R4("1.20.5", "1.20.6"),
    v1_21_R1("1.21", "1.21.1"),
    v1_21_R2("1.21.3"),
    v1_21_R3("1.21.4"),
    v1_21_R4("1.21.5"),
    v1_21_R5("1.21.6", "1.21.7", "1.21.8"),
    v1_21_R6("1.21.9", "1.21.10"),
    v1_21_R7("1.21.11"),
    UNSUPPORTED(false, "N/A");

    private final int deprecationStatus;
    private final String[] supportedVersions;

    private NmsVersion(String ... minecraftVersions) {
        this(true, minecraftVersions);
    }

    private NmsVersion(boolean supported, String ... minecraftVersions) {
        this.supportedVersions = minecraftVersions;
        this.deprecationStatus = !supported ? 2 : (NmsVersion.class.getField(this.name()).isAnnotationPresent(Deprecated.class) ? 1 : 0);
        if (!this.name().equals("UNSUPPORTED") && !this.name().matches("^v\\d+_\\d+(_R\\d+)?$")) {
            throw new IllegalArgumentException("Enum " + this.name() + " does not validate");
        }
    }

    private int getDeprecationStatus() {
        return this.deprecationStatus;
    }

    public boolean isVersionLoadable() {
        return this.getDeprecationStatus() < 2;
    }

    public boolean isDeprecated() {
        return this.getDeprecationStatus() > 0;
    }

    public String getRecommendedMinorVersion() {
        NmsVersion[] values = NmsVersion.values();
        int index = this.ordinal();
        while (values[index].isDeprecated()) {
            ++index;
        }
        return values[index].getLastSupported();
    }

    public String getLastSupported() {
        return this.supportedVersions[this.supportedVersions.length - 1];
    }

    public boolean isMinecraftVersion(String minecraftVersion) {
        for (String version : this.supportedVersions) {
            if (!version.equals(minecraftVersion)) continue;
            return true;
        }
        return false;
    }

    public boolean isSupported() {
        return ReflectionManager.getVersion() != null && ReflectionManager.getVersion().ordinal() >= this.ordinal();
    }

    public boolean isVersion() {
        return ReflectionManager.getVersion() == this;
    }

    public String getCompressedVersions() {
        if (this.getSupportedVersions().length == 1) {
            return this.getSupportedVersions()[0];
        }
        StringBuilder string = new StringBuilder();
        for (String version : this.getSupportedVersions()) {
            String[] split = version.split("\\.");
            if (string.length() == 0) {
                string = new StringBuilder(String.join((CharSequence)".", Arrays.copyOf(split, 2)) + ".[");
            } else {
                string.append("/");
            }
            if (split.length == 2) {
                string.append("0");
                continue;
            }
            string.append(String.join((CharSequence)".", Arrays.copyOfRange(split, 2, split.length)));
        }
        return string + "]";
    }

    public static NmsVersion getByVersion(String minecraftVersion) {
        for (NmsVersion version : NmsVersion.values()) {
            if (!version.isMinecraftVersion(minecraftVersion)) continue;
            return version;
        }
        return null;
    }

    @Generated
    public String[] getSupportedVersions() {
        return this.supportedVersions;
    }
}

