/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.inventory.ItemStack;

public class ItemStackSerializer {
    public static List<String> serialize(ItemStack item) {
        String asString;
        if (!ReflectionManager.isCraftItem(item) && item.hasItemMeta()) {
            item = ReflectionManager.getCraftItem(item);
        }
        ArrayList<String> mcArray = new ArrayList<String>();
        String type = ReflectionManager.getItemName(item.getType());
        if (item.hasItemMeta() && NmsVersion.v1_13.isSupported() && (asString = ReflectionManager.getNmsReflection().getDataAsString(item)) != null && asString.length() > 2) {
            if (NmsVersion.v1_17.isSupported()) {
                asString = ItemStackSerializer.stripSpacesFromString(asString);
            }
            type = type + asString;
        }
        mcArray.add(type);
        if (item.getAmount() != 1) {
            mcArray.add(String.valueOf(item.getAmount()));
        }
        if (!NmsVersion.v1_13.isSupported()) {
            if (item.getDurability() != 0) {
                mcArray.add(String.valueOf(item.getDurability()));
            }
            if (item.hasItemMeta() && (asString = ReflectionManager.getNmsReflection().getDataAsString(item)) != null && asString.length() > 2) {
                mcArray.add(asString);
            }
        }
        return mcArray;
    }

    private static String stripSpacesFromString(String string) {
        StringBuilder result = new StringBuilder();
        boolean inQuote = false;
        boolean escaped = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (escaped) {
                result.append(c);
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else if (c == '\"') {
                inQuote = !inQuote;
            } else if (!inQuote && c == ' ') continue;
            result.append(c);
        }
        return result.toString();
    }
}

