/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import io.papermc.paper.ServerBuildInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseFiles;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ClassMappings {
    private static final Map<String, String> classLocations = new ConcurrentHashMap<String, String>();
    private static String[] packages;
    private static boolean updatingCache;
    private static boolean loadedCache;
    private static final File mappingsFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClass(String packageHint, String className, boolean can404) {
        String key;
        String location;
        if (!loadedCache) {
            ClassMappings.loadMappingsCache();
        }
        if ((location = classLocations.get(key = packageHint + "." + className)) != null) {
            return location;
        }
        location = can404 ? "?" : "???";
        for (String pack : ClassMappings.getPackages()) {
            if (!pack.startsWith(packageHint)) continue;
            String toTry = pack + "." + className;
            try {
                Class.forName(toTry);
                location = toTry;
                break;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        classLocations.put(key, location);
        Map<String, String> map = classLocations;
        synchronized (map) {
            if (!updatingCache && LibsDisguises.getInstance() != null && LibsDisguises.getInstance().isEnabled()) {
                updatingCache = true;
                new BukkitRunnable(){

                    public void run() {
                        ClassMappings.saveMappingsCache(LibsDisguises.getInstance().getDataFolder());
                    }
                }.runTaskLater((Plugin)LibsDisguises.getInstance(), 200L);
            }
        }
        return location;
    }

    private static String[] getPackages() {
        if (packages != null) {
            return packages;
        }
        packages = new String[]{"net.minecraft.server", "net.minecraft.server.$version$", "org.bukkit.craftbukkit.$version$", "org.bukkit.craftbukkit.$version$.block.data", "org.bukkit.craftbukkit.$version$.entity", "org.bukkit.craftbukkit.$version$.inventory", "org.bukkit.craftbukkit.$version$.util"};
        String replaceStr = "$version$";
        String version = ReflectionManager.getNmsPackage();
        if (version.isEmpty()) {
            replaceStr = "." + replaceStr;
        }
        for (int i = 0; i < packages.length; ++i) {
            ClassMappings.packages[i] = packages[i].replace(replaceStr, version);
        }
        return packages;
    }

    private static String getVersion() {
        ServerBuildInfo buildInfo;
        String version = Bukkit.getVersion() + "\t" + LibsDisguises.getInstance().getDescription().getVersion();
        if (ReflectionManager.isRunningPaper() && NmsVersion.v1_21_R2.isSupported() && (buildInfo = ServerBuildInfo.buildInfo()) != null && buildInfo.buildTime() != null) {
            version = version + "\t" + buildInfo.buildTime();
        }
        return "Built for: " + version;
    }

    public static void deleteMappingsCache() {
        ClassMappings.getMappingsFile().delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMappingsCache(File dataFolder) {
        if (!loadedCache) {
            return;
        }
        Map<String, String> map = classLocations;
        synchronized (map) {
            if (!updatingCache) {
                return;
            }
            updatingCache = false;
        }
        ClassMappings.getMappingsFile().getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(ClassMappings.getMappingsFile()));){
            writer.write(ClassMappings.getVersion() + "\n");
            for (Map.Entry<String, String> entry : classLocations.entrySet()) {
                writer.write(entry.getKey() + " " + entry.getValue() + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadMappingsCache() {
        loadedCache = true;
        if (!ClassMappings.getMappingsFile().exists()) {
            return;
        }
        try (BufferedReader reader2 = new BufferedReader(new FileReader(ClassMappings.getMappingsFile()));){
            String line = reader2.readLine();
            if (line == null || !line.equals(ClassMappings.getVersion())) {
                LibsDisguises.getInstance().getLogger().info("Outdated mappings cache, will rebuild.");
                return;
            }
            while ((line = reader2.readLine()) != null) {
                String[] parts = line.split(" ", 2);
                if (parts.length != 2) continue;
                if (parts[1].equals("???")) {
                    LibsDisguises.getInstance().getLogger().info("Mappings cache pointing to " + parts[0] + " is invalid, will rebuild.");
                    classLocations.clear();
                    return;
                }
                try {
                    if (parts[1].contains(".")) {
                        Class.forName(parts[1]);
                    }
                    classLocations.put(parts[0], parts[1]);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (FileNotFoundException reader2) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Generated
    public static boolean isLoadedCache() {
        return loadedCache;
    }

    @Generated
    public static File getMappingsFile() {
        return mappingsFile;
    }

    static {
        updatingCache = false;
        mappingsFile = new File(DisguiseFiles.getInternalFolder(), "mappings_cache");
    }
}

