/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.libraryaddict.disguise.LibsDisguises;
import org.bukkit.entity.Entity;

public class ClassGetter {
    public static List<Class<?>> getClassesForPackage(String pkgname) {
        return ClassGetter.getClassesForPackage(Entity.class, pkgname);
    }

    public static List<String> getEntriesForPackage(String pkgname) {
        return ClassGetter.getEntriesForPackage(Entity.class, pkgname);
    }

    public static List<Class<?>> getClassesForPackage(Class runFrom, String pkgname) {
        List<String> list = ClassGetter.getEntriesForPackage(runFrom, pkgname);
        ArrayList classList = new ArrayList();
        for (String s : list) {
            Class<?> c;
            if (!s.endsWith(".class") || (c = ClassGetter.loadClass(s.replace(".class", "").replace('/', '.'))) == null) continue;
            classList.add(c);
        }
        return classList;
    }

    public static List<String> getEntriesForPackage(Class runFrom, String pkgname) {
        ArrayList<String> classes = new ArrayList<String>();
        CodeSource src = runFrom.getProtectionDomain().getCodeSource();
        if (src != null) {
            boolean isInsideJar;
            URL resource = src.getLocation();
            String path = resource.getPath().toLowerCase(Locale.ENGLISH);
            boolean bl = isInsideJar = path.endsWith(".jar") || path.contains(".jar!") && path.endsWith(".class");
            if (isInsideJar) {
                ClassGetter.processJarfile(resource, pkgname, classes);
            } else {
                File[] baseFileList = new File(resource.getPath() + "/" + pkgname.replace(".", "/")).listFiles();
                if (baseFileList != null) {
                    for (File f : baseFileList) {
                        if (f.getName().contains("$")) continue;
                        classes.add(pkgname + "/" + f.getName());
                    }
                } else {
                    LibsDisguises.getInstance().getLogger().severe("File not found for: " + resource.getPath() + "/" + pkgname.replace(".", "/"));
                }
            }
        }
        return classes;
    }

    private static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    private static void processJarfile(URL resource, String pkgname, List<String> classes) {
        try {
            String relPath = pkgname.replace('.', '/');
            String resPath = URLDecoder.decode(resource.getPath(), "UTF-8");
            String jarPath = resPath.replaceFirst("\\.jar!.*", ".jar").replaceFirst("file:", "");
            try (JarFile jarFile = new JarFile(jarPath);){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    String className = null;
                    if (entryName.startsWith(relPath) && entryName.length() > relPath.length() + "/".length()) {
                        className = entryName.replace('\\', '/');
                    }
                    if (className == null) continue;
                    classes.add(className);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

