/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.parser.constructors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.parser.constructors.ExtraDisguiseParam;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.command.CommandSender;

public class PlayerDisguiseParam
extends ExtraDisguiseParam<String> {
    @Override
    public boolean isApplicable(DisguiseType disguiseType) {
        return disguiseType == DisguiseType.PLAYER;
    }

    @Override
    public ParamInfo<String> getParamInfo() {
        return ParamInfoManager.getParamInfo(String.class);
    }

    @Override
    public String getParameterMethod() {
        return "setName";
    }

    @Override
    public String createParametervalue(CommandSender sender, String arg) {
        arg = arg.replace("\\_", " ");
        if (DisguiseConfig.getPlayerNameType().isFakeEntity() && sender != null && !sender.hasPermission("libsdisguises.multiname")) {
            arg = DisguiseUtilities.quoteNewLine(arg);
        }
        return DisguiseUtilities.translateAlternateColorCodes(arg);
    }

    @Override
    public String getParameterAsString(String param) {
        return param;
    }

    @Override
    public void checkParameterPermission(CommandSender sender, DisguisePermissions permissions, HashMap<String, HashMap<String, Boolean>> disguiseOptions, ArrayList<String> usedOptions, DisguisePerm disguisePerm, String param) throws DisguiseParseException {
        String itemName;
        if (!(sender == null || DisguisePermissions.hasPermissionOption(disguiseOptions, "setname", param.toLowerCase(Locale.ENGLISH)) || param.equalsIgnoreCase(sender.getName()) && DisguisePermissions.hasPermissionOption(disguiseOptions, "setname", "themselves"))) {
            throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_NAME, new String[0]);
        }
        usedOptions.add(this.getParameterMethod().toLowerCase(Locale.ENGLISH));
        DisguiseParseException exception = permissions.getReasonNotAllowed(disguisePerm, usedOptions);
        if (exception != null) {
            throw exception;
        }
        String string = itemName = param == null ? "null" : this.getParameterAsString(param);
        if (!DisguisePermissions.hasPermissionOption(disguiseOptions, this.getParameterMethod(), itemName)) {
            throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_PARAM, itemName, disguisePerm.toReadable());
        }
    }
}

