/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.parser;

import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import org.bukkit.entity.EntityType;

public class DisguisePerm {
    private final DisguiseType disguiseType;
    private String permName;
    private final String regexedName;
    private boolean customDisguise;

    public DisguisePerm(DisguiseType disguiseType) {
        this.disguiseType = disguiseType;
        this.regexedName = this.toReadable().replaceAll("[ |_]", "").toLowerCase(Locale.ENGLISH);
    }

    public DisguisePerm(DisguiseType disguiseType, String disguisePerm) {
        this.disguiseType = disguiseType;
        this.permName = disguisePerm;
        this.customDisguise = true;
        this.regexedName = this.toReadable().replaceAll("[ |_]", "").toLowerCase(Locale.ENGLISH);
    }

    public Class getEntityClass() {
        return this.getType().getEntityClass();
    }

    public EntityType getEntityType() {
        return this.getType().getEntityType();
    }

    public DisguiseType getType() {
        return this.disguiseType;
    }

    public Class<? extends FlagWatcher> getWatcherClass() {
        return this.getType().getWatcherClass();
    }

    public boolean isMisc() {
        return this.getType().isMisc();
    }

    public boolean isMob() {
        return this.getType().isMob();
    }

    public boolean isPlayer() {
        return this.getType().isPlayer();
    }

    public boolean isUnknown() {
        return this.getType().isUnknown();
    }

    public String toReadable() {
        return this.permName == null ? this.getType().toReadable() : this.permName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.disguiseType == null ? 0 : this.disguiseType.hashCode());
        result = 31 * result + (this.permName == null ? 0 : this.permName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisguisePerm)) {
            return false;
        }
        DisguisePerm other = (DisguisePerm)obj;
        if (this.disguiseType != other.disguiseType) {
            return false;
        }
        return Objects.equals(this.permName, other.permName);
    }

    public String toString() {
        return "DisguisePerm{disguiseType=" + (Object)((Object)this.disguiseType) + ", permName='" + this.permName + '\'' + '}';
    }

    @Generated
    public String getRegexedName() {
        return this.regexedName;
    }

    @Generated
    public boolean isCustomDisguise() {
        return this.customDisguise;
    }
}

