/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params.types.custom;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import com.github.retrooper.packetevents.protocol.world.states.type.StateValue;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;

public class ParamInfoWrappedBlockData
extends ParamInfo {
    private final List<WrappedData> defaultBlockStates = new ArrayList<WrappedData>();
    private final Method methodGlobalIdNoCache;
    private final Method cloneBlockstate;

    public ParamInfoWrappedBlockData(Class paramClass, String name, String description) {
        super(paramClass, name, description);
        this.fillMap();
        this.methodGlobalIdNoCache = WrappedBlockState.class.getDeclaredMethod("getGlobalIdNoCache", new Class[0]);
        this.methodGlobalIdNoCache.setAccessible(true);
        this.cloneBlockstate = WrappedBlockState.class.getDeclaredMethod("checkIfCloneNeeded", new Class[0]);
        this.cloneBlockstate.setAccessible(true);
    }

    private void fillMap() {
        ClientVersion version = PacketEvents.getAPI().getServerManager().getVersion().toClientVersion();
        for (Field field : StateTypes.class.getFields()) {
            StateType type;
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || field.getType() != StateType.class || (type = (StateType)field.get(null)) != StateTypes.AIR && type.getMapped().getId(version) <= 0) continue;
            WrappedBlockState state = WrappedBlockState.getDefaultState((ClientVersion)PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), (StateType)type, (boolean)false);
            LinkedHashMap<StateValue, Object> map = new LinkedHashMap<StateValue, Object>();
            ArrayList list = new ArrayList(state.getInternalData().keySet());
            list.sort((v1, v2) -> v1.getName().compareToIgnoreCase(v2.getName()));
            for (StateValue v : list) {
                map.put(v, state.getInternalData().get(v));
            }
            this.defaultBlockStates.add(new WrappedData(map, type));
        }
    }

    @Override
    public boolean hasTabCompletion() {
        return true;
    }

    @Override
    public Set<String> getEnums(String string) {
        String finalArg;
        Object v;
        Object spl;
        if (string.endsWith("]")) {
            return null;
        }
        List<String> parseSplit = this.asSplit(string.toLowerCase(Locale.ENGLISH), false);
        Set<String> set = new HashSet<String>();
        WrappedData bData = this.defaultBlockStates.stream().filter(b -> b.getBlockName().equalsIgnoreCase((String)parseSplit.get(0))).findAny().orElse(null);
        if (bData == null && (parseSplit.size() > 2 || parseSplit.size() == 2 && !parseSplit.get(1).isEmpty())) {
            return null;
        }
        if (parseSplit.size() == 1 || parseSplit.size() == 2 && parseSplit.get(1).isEmpty() && !string.contains("[")) {
            for (WrappedData b2 : this.defaultBlockStates) {
                if (!b2.getBlockName().toLowerCase(Locale.ENGLISH).startsWith(string.toLowerCase(Locale.ENGLISH))) continue;
                set.add(b2.getBlockName() + (b2.getBlockName().equalsIgnoreCase(string) ? "[" : ""));
            }
            if (set.isEmpty()) {
                return null;
            }
            return set;
        }
        if (bData == null) {
            return null;
        }
        ArrayList<String> validData = new ArrayList<String>();
        HashSet<StateValue> handled = new HashSet<StateValue>();
        for (int i = 1; i < parseSplit.size() - 1; ++i) {
            spl = parseSplit.get(i).split("=", -1);
            v = bData.getKey(spl[0]);
            if (v == null) {
                return null;
            }
            handled.add((StateValue)v);
            Object dValue = bData.getData().get(v);
            if ((dValue instanceof Boolean || Boolean.TYPE.isInstance(dValue)) && !((String)spl[1]).toLowerCase(Locale.ENGLISH).matches("true|false")) {
                return null;
            }
            try {
                dValue = v.getParser().apply(((String)spl[1]).toUpperCase(Locale.ENGLISH));
            }
            catch (Exception ex) {
                if (i + 2 == parseSplit.size() && parseSplit.get(i + 1).isEmpty() && !string.endsWith(",") && !string.endsWith("]")) {
                    parseSplit.remove(i + 1);
                    break;
                }
                return null;
            }
            validData.add(v.getName() + "=" + dValue.toString().toLowerCase(Locale.ENGLISH));
        }
        if (!(finalArg = parseSplit.get(parseSplit.size() - 1)).contains("=")) {
            if (!string.endsWith(",") && !string.endsWith("]") && finalArg.isEmpty() && !handled.isEmpty()) {
                if (handled.size() < bData.getData().size()) {
                    set.add(",");
                }
                set.add("]");
            }
            for (StateValue key : bData.getData().keySet()) {
                if (handled.contains(key) || !key.getName().startsWith(finalArg)) continue;
                set.add(key.getName() + "=");
            }
        } else {
            StateValue key;
            spl = finalArg.split("=", -1);
            if (((String[])spl).length > 2) {
                return null;
            }
            key = bData.getKey((String)spl[0]);
            if (key == null) {
                return null;
            }
            Object dVal = bData.getData().get(key);
            if (dVal instanceof Number) {
                return null;
            }
            if (dVal instanceof Boolean || Boolean.TYPE.isInstance(dVal)) {
                for (String s2 : new String[]{"true", "false"}) {
                    if (!s2.startsWith((String)spl[1])) continue;
                    set.add(s2);
                }
            } else {
                for (Enum e : (Enum[])dVal.getClass().getEnumConstants()) {
                    if (!e.name().toLowerCase(Locale.ENGLISH).startsWith(((String)spl[1]).toLowerCase(Locale.ENGLISH))) continue;
                    set.add(e.name().toLowerCase(Locale.ENGLISH));
                }
            }
            set = set.stream().map(s -> key.getName() + "=" + s).collect(Collectors.toSet());
        }
        if (set.isEmpty()) {
            return null;
        }
        String prefix = bData.getBlockName() + "[" + String.join((CharSequence)",", validData);
        if (set.size() == 1 && ((String)(v = (String)set.iterator().next())).equalsIgnoreCase(parseSplit.get(parseSplit.size() - 1))) {
            set = new HashSet();
            if (handled.size() < bData.getData().size()) {
                set.add((String)v + ",");
            }
            set.add((String)v + "]");
        }
        HashSet<String> toReturn = new HashSet<String>();
        for (String s3 : set) {
            if (!validData.isEmpty() && s3.length() > 1) {
                s3 = "," + s3;
            }
            toReturn.add(prefix + s3);
        }
        return toReturn;
    }

    public Object fromString(String string) throws DisguiseParseException {
        List<String> parseSplit = this.asSplit(string, true);
        if (!parseSplit.get(parseSplit.size() - 1).isEmpty()) {
            throw new DisguiseParseException(LibsMsg.PARSE_BLOCK_STATE_UNKNOWN_BLOCK_SYNTAX, string);
        }
        WrappedData bData = this.defaultBlockStates.stream().filter(b -> b.getBlockName().equalsIgnoreCase((String)parseSplit.get(0))).findAny().orElse(null);
        if (bData == null) {
            throw new DisguiseParseException(LibsMsg.PARSE_BLOCK_STATE_UNKNOWN_BLOCK, parseSplit.get(0), string);
        }
        WrappedBlockState blockState = WrappedBlockState.getDefaultState((ClientVersion)PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), (StateType)bData.getStateType(), (boolean)true);
        this.cloneBlockstate.invoke((Object)blockState, new Object[0]);
        for (int i = 1; i < parseSplit.size() - 1; ++i) {
            String[] spl = parseSplit.get(i).split("=", -1);
            StateValue v = bData.getKey(spl[0]);
            if (v == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_BLOCK_STATE_UNKNOWN_BLOCK_DATA_KEY, spl[0], parseSplit.get(0), string);
            }
            if (spl[1].isEmpty()) {
                throw new DisguiseParseException(LibsMsg.PARSE_BLOCK_STATE_UNKNOWN_BLOCK_DATA_VALUE, "{Empty}", spl[0], parseSplit.get(0), string);
            }
            Object dValue = bData.getData().get(v);
            if ((dValue instanceof Boolean || Boolean.TYPE.isInstance(dValue)) && !spl[1].toLowerCase(Locale.ENGLISH).matches("true|false")) {
                throw new DisguiseParseException(LibsMsg.PARSE_BLOCK_STATE_UNKNOWN_BLOCK_DATA_VALUE, spl[1], spl[0], parseSplit.get(0), string);
            }
            try {
                dValue = v.getParser().apply(spl[1].toUpperCase(Locale.ENGLISH));
            }
            catch (Exception ex) {
                throw new DisguiseParseException(LibsMsg.PARSE_BLOCK_STATE_UNKNOWN_BLOCK_DATA_VALUE, spl[1], spl[0], parseSplit.get(0), string);
            }
            blockState.getInternalData().put(v, dValue);
        }
        int globalId = (Integer)this.methodGlobalIdNoCache.invoke((Object)blockState, new Object[0]);
        if (globalId < 0) {
            throw new DisguiseParseException(LibsMsg.PARSE_BLOCK_STATE_ILLEGAL_BLOCK, string);
        }
        if (blockState.getGlobalId() != globalId) {
            return WrappedBlockState.getByGlobalId((int)globalId);
        }
        return blockState;
    }

    public String toString(Object object) {
        WrappedBlockState state = (WrappedBlockState)object;
        WrappedData defaultState = this.defaultBlockStates.stream().filter(b -> b.getStateType() == state.getType()).findAny().orElse(null);
        if (defaultState == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<StateValue, Object> entry : defaultState.getData().entrySet()) {
            if (state.getInternalData().get(entry.getKey()) == entry.getValue()) continue;
            list.add(entry.getKey().getName() + "=" + state.getInternalData().get(entry.getKey()).toString().toLowerCase(Locale.ENGLISH));
        }
        String returns = state.getType().getName();
        if (!list.isEmpty()) {
            returns = returns + "[";
            returns = returns + String.join((CharSequence)",", list);
            returns = returns + "]";
        }
        return returns;
    }

    public List<String> asSplit(String string, boolean demandEnd) {
        Matcher regex = Pattern.compile("^([a-z\\d_]+)([\\[\\]\\da-z=_,]*)$", 2).matcher(string);
        if (!regex.find()) {
            return Collections.singletonList(string);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(regex.group(1));
        String secondArg = regex.group(2);
        if (secondArg == null || secondArg.isEmpty() || secondArg.equals("[]")) {
            args.add("");
            return args;
        }
        if (!secondArg.startsWith("[")) {
            args.add(secondArg);
            return args;
        }
        String[] data = secondArg.substring(1).split(",");
        for (int i = 0; i < data.length; ++i) {
            boolean lastArg = data.length - 1 == i;
            Matcher match = Pattern.compile("^([a-z\\d_]+)=([a-z\\d_]+)" + (lastArg ? "\\]" + (demandEnd ? "" : "?") : "") + "$", 2).matcher(data[i]);
            if (!match.find()) {
                args.add(String.join((CharSequence)",", Arrays.copyOfRange(data, i, data.length)));
                return args;
            }
            args.add(data[i].replace("]", ""));
        }
        args.add("");
        return args;
    }

    private static class WrappedData {
        private final Map<StateValue, Object> data;
        private final StateType stateType;

        public StateValue getKey(String key) {
            for (StateValue v : this.data.keySet()) {
                if (!v.getName().equalsIgnoreCase(key)) continue;
                return v;
            }
            return null;
        }

        public String getBlockName() {
            return this.stateType.getName();
        }

        @Generated
        public WrappedData(Map<StateValue, Object> data, StateType stateType) {
            this.data = data;
            this.stateType = stateType;
        }

        @Generated
        public Map<StateValue, Object> getData() {
            return this.data;
        }

        @Generated
        public StateType getStateType() {
            return this.stateType;
        }
    }
}

