/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.simple.PacketPlaySendEvent;
import com.github.retrooper.packetevents.protocol.attribute.Attributes;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.world.damagetype.DamageTypes;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityAnimation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityStatus;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherValue;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PacketListenerViewSelfDisguise
extends SimplePacketListenerAbstract {
    private final boolean[] listenedPackets = new boolean[PacketType.Play.Server.values().length];
    private final boolean[] rewriteEntityId = new boolean[PacketType.Play.Server.values().length];
    private final boolean[] neverSend = new boolean[PacketType.Play.Server.values().length];
    private final boolean[] conflictingPackets;

    public PacketListenerViewSelfDisguise(boolean[] conflictingPackets) {
        this.conflictingPackets = conflictingPackets;
        for (PacketType.Play.Server packet : new PacketType.Play.Server[]{PacketType.Play.Server.ATTACH_ENTITY, PacketType.Play.Server.SET_PASSENGERS, PacketType.Play.Server.ENTITY_RELATIVE_MOVE, PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION, PacketType.Play.Server.ENTITY_HEAD_LOOK, PacketType.Play.Server.ENTITY_POSITION_SYNC, PacketType.Play.Server.ENTITY_TELEPORT, PacketType.Play.Server.ENTITY_ROTATION, PacketType.Play.Server.ENTITY_EQUIPMENT}) {
            this.neverSend[packet.ordinal()] = true;
        }
        Arrays.fill(this.rewriteEntityId, true);
        for (PacketType.Play.Server packet : new PacketType.Play.Server[]{PacketType.Play.Server.PLAYER_INFO, PacketType.Play.Server.PLAYER_INFO_UPDATE, PacketType.Play.Server.DESTROY_ENTITIES}) {
            this.rewriteEntityId[packet.ordinal()] = false;
        }
        for (PacketType.Play.Server packet : new PacketType.Play.Server[]{NmsVersion.v1_20_R2.isSupported() ? PacketType.Play.Server.SPAWN_ENTITY : PacketType.Play.Server.SPAWN_PLAYER, PacketType.Play.Server.SET_PASSENGERS, PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION, PacketType.Play.Server.ENTITY_RELATIVE_MOVE, PacketType.Play.Server.ENTITY_HEAD_LOOK, PacketType.Play.Server.ENTITY_ROTATION, PacketType.Play.Server.ENTITY_TELEPORT, PacketType.Play.Server.ENTITY_MOVEMENT, PacketType.Play.Server.ENTITY_METADATA, PacketType.Play.Server.ENTITY_EQUIPMENT, PacketType.Play.Server.ENTITY_ANIMATION, PacketType.Play.Server.ENTITY_EFFECT, PacketType.Play.Server.ENTITY_VELOCITY, PacketType.Play.Server.UPDATE_ATTRIBUTES, PacketType.Play.Server.ENTITY_STATUS, PacketType.Play.Server.ENTITY_POSITION_SYNC, PacketType.Play.Server.DAMAGE_EVENT}) {
            if (packet == PacketType.Play.Server.DAMAGE_EVENT && (!DisguiseUtilities.isRegistered((MappedEntity)DamageTypes.CRAMMING) || NmsVersion.v1_21_R1.isVersion())) continue;
            this.listenedPackets[packet.ordinal()] = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onPacketPlaySend(PacketPlaySendEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.listenedPackets[event.getPacketType().ordinal()]) {
            return;
        }
        try {
            Player observer = (Player)event.getPlayer();
            if (observer == null) {
                return;
            }
            PacketWrapper wrapper = DisguiseUtilities.constructWrapper(event);
            int entityId = DisguiseUtilities.getEntityId(wrapper);
            if (entityId != observer.getEntityId() && entityId != DisguiseAPI.getSelfDisguiseId()) {
                return;
            }
            if (!DisguiseAPI.isSelfDisguised(observer)) {
                return;
            }
            Disguise disguise = DisguiseAPI.getDisguise(observer, (Entity)observer);
            if (disguise == null) {
                return;
            }
            if (this.conflictingPackets[event.getPacketType().ordinal()] && disguise.getInternals().shouldAvoidSendingPackets(observer)) {
                if (this.neverSend[event.getPacketType().ordinal()]) {
                    event.setCancelled(true);
                } else if (observer.getEntityId() != entityId) {
                    event.setCancelled(true);
                }
                return;
            }
            LibsPackets transformed = PacketsManager.getPacketsManager().getPacketsHandler().transformPacket(wrapper, disguise, observer, (Entity)observer);
            if (transformed.isUnhandled()) {
                transformed.addPacket(DisguiseUtilities.unsafeClone(event, wrapper));
            }
            LibsPackets<PacketWrapper> selfTransformed = new LibsPackets<PacketWrapper>(wrapper, disguise);
            selfTransformed.setSkinHandling(transformed.isSkinHandling());
            for (PacketWrapper packetWrapper : transformed.getPackets()) {
                void var9_10;
                if (packetWrapper == selfTransformed.getOriginalPacket()) {
                    PacketWrapper packetWrapper2 = DisguiseUtilities.unsafeClone(event, packetWrapper);
                }
                if (this.rewriteEntityId[((PacketType.Play.Server)var9_10.getPacketTypeData().getPacketType()).ordinal()] && DisguiseUtilities.getEntityId((PacketWrapper)var9_10).intValue() == observer.getEntityId()) {
                    DisguiseUtilities.writeSelfDisguiseId(observer.getEntityId(), (PacketWrapper)var9_10);
                }
                if (var9_10.getPacketTypeData().getPacketType() == PacketType.Play.Server.UPDATE_ATTRIBUTES && disguise.isTallSelfDisguisesScaling()) {
                    this.runAttributes(disguise, (PacketWrapper)var9_10);
                }
                selfTransformed.addPacket((PacketWrapper)var9_10);
            }
            for (Map.Entry entry : transformed.getDelayedPacketsMap().entrySet()) {
                for (PacketWrapper newPacket : (List)entry.getValue()) {
                    if (newPacket == selfTransformed.getOriginalPacket()) {
                        newPacket = DisguiseUtilities.unsafeClone(event, newPacket);
                    }
                    if (this.rewriteEntityId[((PacketType.Play.Server)newPacket.getPacketTypeData().getPacketType()).ordinal()]) {
                        DisguiseUtilities.writeSelfDisguiseId(observer.getEntityId(), newPacket);
                    }
                    selfTransformed.addDelayedPacket(newPacket, (Integer)entry.getKey());
                }
            }
            if (disguise.isPlayerDisguise()) {
                LibsDisguises.getInstance().getSkinHandler().handlePackets(observer, (PlayerDisguise)disguise, selfTransformed);
            }
            if (event.getPacketType() == PacketType.Play.Server.SPAWN_PLAYER || event.getPacketType() == PacketType.Play.Server.SPAWN_ENTITY) {
                disguise.getInternals().addSeen(observer, true);
            }
            for (PacketWrapper packetWrapper : selfTransformed.getPackets()) {
                PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)observer, packetWrapper);
            }
            selfTransformed.sendDelayed(observer);
            if (event.getPacketType() == PacketType.Play.Server.ENTITY_METADATA) {
                this.sendMetadata(observer, wrapper);
            } else if (event.getPacketType() == PacketType.Play.Server.SPAWN_PLAYER || event.getPacketType() == PacketType.Play.Server.SPAWN_ENTITY) {
                this.handleSpawn(event, observer);
            } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_ANIMATION) {
                this.handleAllNonWakeAnimation(event, wrapper);
            } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_STATUS) {
                this.handleStatus(observer, disguise, event, wrapper);
            } else if (event.getPacketType() == PacketType.Play.Server.DAMAGE_EVENT) {
                this.handleDamage(disguise, event, observer);
            } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_VELOCITY) {
                this.handleVelocity(event, observer);
            } else if (this.neverSend[event.getPacketType().ordinal()]) {
                event.setCancelled(true);
            }
        }
        catch (Throwable ex) {
            event.setCancelled(true);
            ex.printStackTrace();
        }
    }

    private void runAttributes(Disguise disguise, PacketWrapper newPacket) {
        WrapperPlayServerUpdateAttributes attributes = (WrapperPlayServerUpdateAttributes)newPacket;
        ArrayList<WrapperPlayServerUpdateAttributes.Property> toSend = new ArrayList<WrapperPlayServerUpdateAttributes.Property>(attributes.getProperties());
        for (WrapperPlayServerUpdateAttributes.Property prop : attributes.getProperties()) {
            double max;
            if (prop.getAttribute() != Attributes.GENERIC_SCALE) continue;
            double playerValue = prop.calcValue();
            if (playerValue <= (max = disguise.getInternals().getPrevSelfDisguiseTallScaleMax())) break;
            toSend.remove(prop);
            toSend.add(new WrapperPlayServerUpdateAttributes.Property(Attributes.GENERIC_SCALE, max, new ArrayList()));
        }
        attributes.setProperties(toSend);
    }

    private void sendMetadata(Player player, PacketWrapper wrapper) {
        WrapperPlayServerEntityMetadata metadata = (WrapperPlayServerEntityMetadata)wrapper;
        if (metadata.getEntityId() != player.getEntityId()) {
            return;
        }
        for (EntityData data : metadata.getEntityMetadata()) {
            if (data.getIndex() != 0) continue;
            byte b = (Byte)data.getValue();
            byte a = (byte)((b | 0x20) & 0xFFFFFFBF);
            data.setValue((Object)a);
        }
    }

    private void handleSpawn(PacketPlaySendEvent event, Player observer) {
        event.setCancelled(true);
        ArrayList<WatcherValue> watchableList = new ArrayList<WatcherValue>();
        byte b = 32;
        if (observer.isSprinting()) {
            b = (byte)(b | 8);
        }
        if (observer.isGliding()) {
            b = (byte)(b | 0x80);
        }
        WatcherValue watch = new WatcherValue(MetaIndex.ENTITY_META, b, true);
        watchableList.add(watch);
        WrapperPlayServerEntityMetadata metaPacket = ReflectionManager.getMetadataPacket(observer.getEntityId(), watchableList);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)observer, (PacketWrapper)metaPacket);
    }

    private void handleAllNonWakeAnimation(PacketPlaySendEvent event, PacketWrapper wrapper) {
        if (((WrapperPlayServerEntityAnimation)wrapper).getType() == WrapperPlayServerEntityAnimation.EntityAnimationType.WAKE_UP) {
            return;
        }
        event.setCancelled(true);
    }

    private void handleStatus(Player observer, Disguise disguise, PacketPlaySendEvent event, PacketWrapper wrapper) {
        if (!disguise.isSelfDisguiseSoundsReplaced() || disguise.getType().isPlayer() || ((WrapperPlayServerEntityStatus)wrapper).getStatus() != 2) {
            return;
        }
        event.setCancelled(true);
        if (!NmsVersion.v1_19_R2.isSupported()) {
            return;
        }
        SoundGroup group = SoundGroup.getGroup(disguise);
        ResourceLocation sound = group.getSound(SoundGroup.SoundType.HURT);
        if (sound == null) {
            return;
        }
        observer.playSound(observer.getLocation(), sound.toString(), disguise.getEffectiveSoundCategory().getBukkitSoundCategory(disguise), 1.0f, 1.0f);
    }

    private void handleDamage(Disguise disguise, PacketPlaySendEvent event, Player observer) {
        if (!disguise.isSelfDisguiseSoundsReplaced()) {
            return;
        }
        event.setCancelled(true);
        SoundGroup group = SoundGroup.getGroup(disguise);
        if (group == null) {
            return;
        }
        ResourceLocation sound = group.getSound(SoundGroup.SoundType.HURT);
        if (sound == null) {
            return;
        }
        observer.playSound(observer.getLocation(), sound.toString(), disguise.getEffectiveSoundCategory().getBukkitSoundCategory(disguise), 1.0f, 1.0f);
    }

    private void handleVelocity(PacketPlaySendEvent event, Player observer) {
        if (DisguiseUtilities.isPlayerVelocity(observer)) {
            return;
        }
        event.setCancelled(true);
        DisguiseUtilities.clearPlayerVelocity(observer);
    }
}

