/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.simple.PacketPlaySendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.sound.Sound;
import com.github.retrooper.packetevents.protocol.sound.SoundCategory;
import com.github.retrooper.packetevents.protocol.sound.Sounds;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntitySoundEffect;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSoundEffect;
import java.util.Set;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseRunnable;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class PacketListenerSounds
extends SimplePacketListenerAbstract {
    private boolean isNearby(Vector3i packetLocation, Location entityLocation, int threshold) {
        if (Math.abs(packetLocation.getX() - (int)(entityLocation.getX() * 8.0)) > threshold) {
            return false;
        }
        if (Math.abs(packetLocation.getY() - (int)(entityLocation.getY() * 8.0)) > threshold) {
            return false;
        }
        return Math.abs(packetLocation.getZ() - (int)(entityLocation.getZ() * 8.0)) <= threshold;
    }

    public void onPacketPlaySend(PacketPlaySendEvent event) {
        Sound nSound;
        SoundGroup disguiseSound;
        DisguiseRunnable runnable;
        Sound sound;
        float pitch;
        float volume;
        SoundGroup group;
        Disguise disguise;
        WrapperPlayServerEntitySoundEffect entitySoundEffect;
        WrapperPlayServerSoundEffect soundEffect;
        Player observer;
        block22: {
            if (event.isCancelled()) {
                return;
            }
            if (event.getPacketType() != PacketType.Play.Server.ENTITY_SOUND_EFFECT && event.getPacketType() != PacketType.Play.Server.SOUND_EFFECT) {
                return;
            }
            observer = (Player)event.getPlayer();
            if (observer == null) {
                return;
            }
            soundEffect = null;
            entitySoundEffect = null;
            disguise = null;
            group = null;
            if (event.getPacketType() == PacketType.Play.Server.SOUND_EFFECT) {
                soundEffect = new WrapperPlayServerSoundEffect((PacketSendEvent)event);
                volume = soundEffect.getVolume();
                pitch = soundEffect.getPitch();
                sound = soundEffect.getSound();
                if (sound == null || sound.getSoundId() == null) {
                    event.setLastUsedWrapper(null);
                    return;
                }
                ResourceLocation soundKey = sound.getSoundId();
                Vector3i loc = soundEffect.getEffectPosition();
                World world = observer.getWorld();
                for (Set<TargetedDisguise> disguises : DisguiseUtilities.getDisguises().values()) {
                    for (TargetedDisguise entityDisguise : disguises) {
                        Entity entity = entityDisguise.getEntity();
                        if (entity == null || entity.getWorld() != world || !entityDisguise.canSee(observer) || !this.isNearby(loc, entity.getLocation(), 2) || (group = SoundGroup.getGroup(entity)) == null || group.getSound(soundKey) == null) continue;
                        disguise = entityDisguise;
                        break block22;
                    }
                }
            } else {
                entitySoundEffect = new WrapperPlayServerEntitySoundEffect((PacketSendEvent)event);
                volume = entitySoundEffect.getVolume();
                pitch = entitySoundEffect.getPitch();
                sound = entitySoundEffect.getSound();
                if (sound == null) {
                    event.setLastUsedWrapper(null);
                    return;
                }
                disguise = DisguiseUtilities.getDisguise(observer, entitySoundEffect.getEntityId());
            }
        }
        if (disguise == null || !disguise.isSoundsReplaced()) {
            return;
        }
        Entity entity = disguise.getEntity();
        if (entity == observer && !disguise.isSelfDisguiseSoundsReplaced()) {
            return;
        }
        if (group == null) {
            group = SoundGroup.getGroup(entity);
        }
        if (group == null) {
            return;
        }
        SoundGroup.SoundType soundType = group.getType(sound.getSoundId());
        if (soundType == null) {
            return;
        }
        if (soundType == SoundGroup.SoundType.HURT && disguise.isPlayIdleSounds() && (runnable = disguise.getInternals().getRunnable()) != null) {
            runnable.resetAmbientSoundTime();
        }
        if ((disguiseSound = SoundGroup.getGroup(disguise)) == null) {
            event.setCancelled(true);
            return;
        }
        ResourceLocation newSound = disguiseSound.getSound(soundType);
        if (newSound == null) {
            event.setCancelled(true);
            return;
        }
        if (volume == group.getDamageAndIdleSoundVolume()) {
            volume = disguiseSound.getDamageAndIdleSoundVolume();
        }
        if (disguise instanceof MobDisguise && entity instanceof LivingEntity && ((MobDisguise)disguise).doesDisguiseAge()) {
            pitch = ((MobDisguise)disguise).isAdult() ? (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.0f : (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.4f;
        }
        if ((nSound = Sounds.getByName((String)newSound.toString())) == null) {
            event.setCancelled(true);
            Location loc = entity.getLocation();
            observer.playSound(loc, NmsVersion.v1_16.isSupported() ? newSound.toString() : newSound.getKey(), disguise.getEffectiveSoundCategory().getBukkitSoundCategory(disguise), volume, pitch);
            return;
        }
        SoundCategory soundCat = disguise.getEffectiveSoundCategory().getSoundCategory(disguise);
        if (soundEffect != null) {
            soundEffect.setSound(nSound);
            soundEffect.setVolume(volume);
            soundEffect.setPitch(pitch);
            soundEffect.setSoundCategory(soundCat);
        } else {
            entitySoundEffect.setSound(nSound);
            entitySoundEffect.setVolume(volume);
            entitySoundEffect.setPitch(pitch);
            entitySoundEffect.setSoundCategory(soundCat);
        }
        event.markForReEncode(true);
    }
}

