/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.simple.PacketPlaySendEvent;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import lombok.Generated;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import org.bukkit.entity.Player;

public class PacketListenerMain
extends SimplePacketListenerAbstract {
    private final boolean[] listenedPackets;
    private final boolean[] spawnPackets;
    private final boolean[] conflictingTypes;

    public void onPacketPlaySend(PacketPlaySendEvent event) {
        LibsPackets packets;
        if (event.isCancelled()) {
            return;
        }
        if (!this.listenedPackets[event.getPacketType().ordinal()]) {
            return;
        }
        Player observer = (Player)event.getPlayer();
        if (observer == null) {
            return;
        }
        PacketWrapper wrapper = DisguiseUtilities.constructWrapper(event);
        Integer entityId = DisguiseUtilities.getEntityId(wrapper);
        if (entityId == null) {
            throw new IllegalStateException("Entity id should not be null on " + wrapper.getClass());
        }
        Disguise disguise = DisguiseUtilities.getDisguise(observer, entityId);
        if (disguise == null || disguise.getEntity() == observer) {
            return;
        }
        try {
            packets = PacketsManager.getPacketsManager().getPacketsHandler().transformPacket(wrapper, disguise, observer, disguise.getEntity());
            if (disguise.isPlayerDisguise()) {
                LibsDisguises.getInstance().getSkinHandler().handlePackets(observer, (PlayerDisguise)disguise, packets);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            event.setCancelled(true);
            return;
        }
        if (packets.isUnhandled()) {
            return;
        }
        if (packets.shouldCancelPacketEvent()) {
            event.setCancelled(true);
        }
        if (this.spawnPackets[event.getPacketType().ordinal()]) {
            disguise.getInternals().addSeen(observer, true);
        } else if (this.conflictingTypes[event.getPacketType().ordinal()] && disguise.getInternals().shouldAvoidSendingPackets(observer)) {
            event.setCancelled(true);
            return;
        }
        for (PacketWrapper packet : packets.getPackets()) {
            if (packet == wrapper) {
                event.markForReEncode(true);
                continue;
            }
            PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)observer, packet);
        }
        packets.sendDelayed(observer);
    }

    @Generated
    public PacketListenerMain(boolean[] listenedPackets, boolean[] spawnPackets, boolean[] conflictingTypes) {
        this.listenedPackets = listenedPackets;
        this.spawnPackets = spawnPackets;
        this.conflictingTypes = conflictingTypes;
    }
}

