/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.PacketsHandler;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerClientCustomPayload;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerClientInteract;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerEntityDestroy;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerInventory;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerMain;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerScoreboardTeam;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerSounds;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerTabList;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerVehicleMovement;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerViewSelfDisguise;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PacketsManager {
    private static final PacketsManager packetsManager = new PacketsManager();
    private final PacketListenerClientInteract clientInteractEntityListener = new PacketListenerClientInteract();
    private final PacketListenerTabList tablistListener = new PacketListenerTabList();
    private final PacketListenerClientCustomPayload customPayload = new PacketListenerClientCustomPayload();
    private PacketListenerInventory inventoryListener;
    private boolean inventoryListenerEnabled;
    private PacketListenerMain mainListener;
    private PacketListenerSounds soundsListener;
    private boolean soundsListenerEnabled;
    private PacketListenerViewSelfDisguise viewDisguisesListener;
    private PacketListenerVehicleMovement vehicleMovement;
    private boolean viewDisguisesListenerEnabled;
    private PacketsHandler packetsHandler;
    private boolean initialListenersRegistered;

    public void addPacketListeners() {
        if (!this.initialListenersRegistered) {
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.clientInteractEntityListener);
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.tablistListener);
            if (DisguiseConfig.isLoginPayloadPackets()) {
                PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.customPayload);
            }
            this.initialListenersRegistered = true;
            PacketEvents.getAPI().getSettings().fullStackTrace(true);
        }
        this.setupMainPacketsListener();
    }

    public void init() {
        this.soundsListener = new PacketListenerSounds();
        this.viewDisguisesListener = new PacketListenerViewSelfDisguise(this.createConflicting(true));
        this.inventoryListener = new PacketListenerInventory();
        this.packetsHandler = new PacketsHandler();
    }

    public boolean isHearDisguisesEnabled() {
        return this.soundsListenerEnabled;
    }

    public void setInventoryListenerEnabled(boolean enabled) {
        if (this.isInventoryListenerEnabled() == enabled || this.inventoryListener == null) {
            return;
        }
        this.inventoryListenerEnabled = enabled;
        if (this.inventoryListenerEnabled) {
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.inventoryListener);
        } else {
            PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.inventoryListener);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
            if (disguise == null || !this.isViewDisguisesListenerEnabled() || !disguise.isSelfDisguiseVisible() || !disguise.isHideArmorFromSelf() && !disguise.isHideHeldItemFromSelf()) continue;
            player.updateInventory();
        }
    }

    public void setHearDisguisesListener(boolean enabled) {
        if (this.soundsListenerEnabled == enabled) {
            return;
        }
        this.soundsListenerEnabled = enabled;
        if (this.soundsListenerEnabled) {
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.soundsListener);
        } else {
            PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.soundsListener);
        }
    }

    public void setupMainPacketsListener() {
        if (!this.initialListenersRegistered) {
            return;
        }
        if (this.mainListener != null) {
            PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.mainListener);
        }
        if (this.vehicleMovement != null && !DisguiseConfig.getPlayerNameType().isFakeEntity()) {
            PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.vehicleMovement);
            HandlerList.unregisterAll((Listener)this.vehicleMovement);
            this.vehicleMovement = null;
        }
        this.getPacketsHandler().registerPacketHandlers();
        boolean[] listenedPackets = new boolean[PacketType.Play.Server.values().length];
        boolean[] spawnPackets = new boolean[PacketType.Play.Server.values().length];
        boolean[] conflictingPackets = this.createConflicting(false);
        if (!NmsVersion.v1_20_R2.isSupported()) {
            spawnPackets[PacketType.Play.Server.SPAWN_PLAYER.ordinal()] = true;
        }
        spawnPackets[PacketType.Play.Server.SPAWN_EXPERIENCE_ORB.ordinal()] = true;
        spawnPackets[PacketType.Play.Server.SPAWN_ENTITY.ordinal()] = true;
        if (!NmsVersion.v1_19_R1.isSupported()) {
            spawnPackets[PacketType.Play.Server.SPAWN_LIVING_ENTITY.ordinal()] = true;
            spawnPackets[PacketType.Play.Server.SPAWN_PAINTING.ordinal()] = true;
        }
        if (DisguiseConfig.isMovementPacketsEnabled()) {
            listenedPackets[PacketType.Play.Server.ENTITY_MOVEMENT.ordinal()] = true;
            listenedPackets[PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION.ordinal()] = true;
            listenedPackets[PacketType.Play.Server.ENTITY_HEAD_LOOK.ordinal()] = true;
            listenedPackets[PacketType.Play.Server.ENTITY_TELEPORT.ordinal()] = true;
            listenedPackets[PacketType.Play.Server.ENTITY_RELATIVE_MOVE.ordinal()] = true;
            listenedPackets[PacketType.Play.Server.ENTITY_VELOCITY.ordinal()] = true;
            listenedPackets[PacketType.Play.Server.SET_PASSENGERS.ordinal()] = true;
            listenedPackets[PacketType.Play.Server.ENTITY_POSITION_SYNC.ordinal()] = true;
            listenedPackets[PacketType.Play.Server.ENTITY_ROTATION.ordinal()] = true;
        }
        if (DisguiseConfig.isEquipmentPacketsEnabled()) {
            listenedPackets[PacketType.Play.Server.ENTITY_EQUIPMENT.ordinal()] = true;
        }
        if (DisguiseConfig.isEntityStatusPacketsEnabled()) {
            listenedPackets[PacketType.Play.Server.ENTITY_STATUS.ordinal()] = true;
        }
        for (int i = 0; i < listenedPackets.length; ++i) {
            int n = i;
            listenedPackets[n] = listenedPackets[n] | (conflictingPackets[i] || spawnPackets[i]);
        }
        if (LibsDisguises.getInstance().isDebuggingBuild()) {
            IPacketHandler[] handledPackets = this.packetsHandler.getPacketHandlers();
            for (int i = 0; i < handledPackets.length; ++i) {
                if (handledPackets[i] == null || listenedPackets[i]) continue;
                LibsDisguises.getInstance().getLogger().severe(String.format("The packet handler %s has registered %s but it is not in the main listener", handledPackets[i].getClass(), PacketType.Play.Server.values()[i]));
            }
        }
        this.mainListener = new PacketListenerMain(listenedPackets, spawnPackets, this.createConflicting(true));
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.mainListener);
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)new PacketListenerEntityDestroy());
        if (NmsVersion.v1_13.isSupported() && DisguiseConfig.getPlayerNameType().isScoreboardPacketListenerNeeded()) {
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)new PacketListenerScoreboardTeam());
        }
        if (this.vehicleMovement == null && DisguiseConfig.getPlayerNameType().isFakeEntity()) {
            this.vehicleMovement = new PacketListenerVehicleMovement();
            Bukkit.getPluginManager().registerEvents((Listener)this.vehicleMovement, (Plugin)LibsDisguises.getInstance());
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.vehicleMovement);
        }
    }

    public boolean[] createConflicting(boolean isntHighPerformance) {
        boolean[] conflictingPackets = new boolean[PacketType.Play.Server.values().length];
        conflictingPackets[PacketType.Play.Server.ENTITY_METADATA.ordinal()] = true;
        if (isntHighPerformance || DisguiseConfig.isCollectPacketsEnabled()) {
            conflictingPackets[PacketType.Play.Server.COLLECT_ITEM.ordinal()] = true;
        }
        if (isntHighPerformance || DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
            conflictingPackets[PacketType.Play.Server.UPDATE_ATTRIBUTES.ordinal()] = true;
        }
        if (isntHighPerformance || DisguiseConfig.isAnimationPacketsEnabled()) {
            conflictingPackets[PacketType.Play.Server.ENTITY_ANIMATION.ordinal()] = true;
        }
        if (isntHighPerformance || DisguiseConfig.isEntityStatusPacketsEnabled()) {
            // empty if block
        }
        return conflictingPackets;
    }

    public void setViewDisguisesListener(boolean enabled) {
        if (this.viewDisguisesListenerEnabled == enabled) {
            return;
        }
        this.viewDisguisesListenerEnabled = enabled;
        if (this.viewDisguisesListenerEnabled) {
            PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.viewDisguisesListener);
        } else {
            PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.viewDisguisesListener);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
            if (disguise == null || !disguise.isSelfDisguiseVisible()) continue;
            if (enabled) {
                DisguiseUtilities.setupFakeDisguise(disguise);
            } else {
                DisguiseUtilities.removeSelfDisguise(disguise);
            }
            if (!this.inventoryListenerEnabled || !disguise.isHidingArmorFromSelf() && !disguise.isHidingHeldItemFromSelf()) continue;
            player.updateInventory();
        }
    }

    @Generated
    public static PacketsManager getPacketsManager() {
        return packetsManager;
    }

    @Generated
    public boolean isInventoryListenerEnabled() {
        return this.inventoryListenerEnabled;
    }

    @Generated
    public boolean isViewDisguisesListenerEnabled() {
        return this.viewDisguisesListenerEnabled;
    }

    @Generated
    public PacketsHandler getPacketsHandler() {
        return this.packetsHandler;
    }
}

