/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class LibsPackets<T extends PacketWrapper<@NotNull T>> {
    private final List<PacketWrapper> packets = new ArrayList<PacketWrapper>();
    private final Map<Integer, List<PacketWrapper>> delayedPacketsMap = new HashMap<Integer, List<PacketWrapper>>();
    private final T originalPacket;
    private final Disguise disguise;
    private boolean unhandled;
    private boolean skinHandling;

    public boolean shouldCancelPacketEvent() {
        return !this.packets.contains(this.getOriginalPacket());
    }

    public void addPacket(PacketWrapper packet) {
        this.packets.add(packet);
    }

    public void addDelayedPacket(PacketWrapper packet) {
        this.addDelayedPacket(packet, 2);
    }

    public void clear() {
        this.getPackets().clear();
    }

    public void addDelayedPacket(PacketWrapper packet, int ticksDelayed) {
        if (!this.delayedPacketsMap.containsKey(ticksDelayed)) {
            this.delayedPacketsMap.put(ticksDelayed, new ArrayList());
        }
        this.delayedPacketsMap.get(ticksDelayed).add(packet);
    }

    public void sendDelayed(Player observer) {
        for (Map.Entry<Integer, List<PacketWrapper>> entry : this.getDelayedPacketsMap().entrySet()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                if (!this.getDisguise().isDisguiseInUse()) {
                    List packets = (List)entry.getValue();
                    if (packets.stream().noneMatch(p -> p.getPacketTypeData().getPacketType() == PacketType.Play.Server.PLAYER_INFO)) {
                        return;
                    }
                    packets.removeIf(p -> p.getPacketTypeData().getPacketType() != PacketType.Play.Server.PLAYER_INFO);
                }
                for (PacketWrapper packet : (List)entry.getValue()) {
                    if (packet.getPacketTypeData().getPacketType() == PacketType.Play.Server.ENTITY_EQUIPMENT) {
                        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)observer, packet);
                        continue;
                    }
                    PacketEvents.getAPI().getPlayerManager().sendPacket((Object)observer, packet);
                }
            }, (long)entry.getKey().intValue());
        }
    }

    @Generated
    public Map<Integer, List<PacketWrapper>> getDelayedPacketsMap() {
        return this.delayedPacketsMap;
    }

    @Generated
    public boolean isUnhandled() {
        return this.unhandled;
    }

    @Generated
    public boolean isSkinHandling() {
        return this.skinHandling;
    }

    @Generated
    public LibsPackets(T originalPacket, Disguise disguise) {
        this.originalPacket = originalPacket;
        this.disguise = disguise;
    }

    @Generated
    public void setUnhandled(boolean unhandled) {
        this.unhandled = unhandled;
    }

    @Generated
    public void setSkinHandling(boolean skinHandling) {
        this.skinHandling = skinHandling;
    }

    @Generated
    public List<PacketWrapper> getPackets() {
        return this.packets;
    }

    @Generated
    public T getOriginalPacket() {
        return this.originalPacket;
    }

    @Generated
    public Disguise getDisguise() {
        return this.disguise;
    }
}

