/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.movements;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.attribute.Attributes;
import com.github.retrooper.packetevents.protocol.entity.EntityPositionData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityPositionSync;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnLivingEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.SlimeWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.movements.CloningMovementTracker;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherValue;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

public class InteractiveBoundingBox
implements CloningMovementTracker {
    private final DisguiseType disguiseType;
    private final UUID uuid = UUID.randomUUID();
    private final int entityId;
    private Disguise disguise;
    private final Map<MetaIndex, Object> meta = new ConcurrentHashMap<MetaIndex, Object>();
    private double yOffset = 0.0;
    private double scale = 1.0;

    public InteractiveBoundingBox(DisguiseType disguiseType) {
        if (disguiseType.getEntityClass() == null) {
            throw new IllegalArgumentException((Object)((Object)disguiseType) + " is not supported in this Minecraft version");
        }
        if (disguiseType != DisguiseType.INTERACTION && (!LivingEntity.class.isAssignableFrom(disguiseType.getEntityClass()) || disguiseType.isPlayer())) {
            throw new IllegalArgumentException("Can only be used on living non-player entities or Interaction entity");
        }
        this.disguiseType = disguiseType;
        this.entityId = ReflectionManager.getNewEntityId();
    }

    @ApiStatus.Internal
    public void setDisguise(Disguise disguise) {
        if (this.disguise != null) {
            throw new IllegalStateException("The disguise has already been set");
        }
        this.disguise = disguise;
    }

    private boolean isValid() {
        return this.disguise != null && this.disguise.getEntity() != null;
    }

    private <Y> void set(MetaIndex<Y> index, Y value) {
        if (value == null) {
            this.meta.remove(index);
        } else {
            this.meta.put(index, value);
        }
        if (!this.isValid()) {
            return;
        }
        for (Player player : this.getEffectedPlayers()) {
            if (player == this.disguise.getEntity()) continue;
            WrapperPlayServerEntityMetadata packet = ReflectionManager.getMetadataPacket(this.entityId, Collections.singletonList(new WatcherValue(index, this.getMetadata(index), true)));
            PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)packet);
        }
    }

    private List<Player> getEffectedPlayers() {
        if (!this.disguise.isDisguiseInUse()) {
            return Collections.emptyList();
        }
        return DisguiseUtilities.getTrackingPlayers(this.disguise);
    }

    public InteractiveBoundingBox setSize(int size) {
        if (SlimeWatcher.class.isAssignableFrom(this.disguiseType.getWatcherClass())) {
            this.set(MetaIndex.SLIME_SIZE, size);
        } else if (this.disguiseType == DisguiseType.PHANTOM) {
            this.set(MetaIndex.PHANTOM_SIZE, size);
        } else {
            throw new IllegalArgumentException("Cannot call setSize on a non-slime & non-phantom type");
        }
        return this;
    }

    public InteractiveBoundingBox setSize(float width, float height) {
        if (this.disguiseType != DisguiseType.INTERACTION) {
            throw new IllegalArgumentException("This is only usable on Interaction");
        }
        this.set(MetaIndex.INTERACTION_WIDTH, Float.valueOf(width));
        this.set(MetaIndex.INTERACTION_HEIGHT, Float.valueOf(height));
        return this;
    }

    public InteractiveBoundingBox setScale(double scale) {
        if (this.disguiseType == DisguiseType.INTERACTION) {
            this.setSize((float)scale, (float)scale);
            return this;
        }
        this.scale = scale;
        if (!this.isValid() || !NmsVersion.v1_20_R4.isSupported()) {
            return this;
        }
        for (Player player : this.getEffectedPlayers()) {
            if (player == this.disguise.getEntity()) continue;
            PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)this.createAttributes());
        }
        return this;
    }

    @ApiStatus.Internal
    public void onSpawn() {
        if (!this.isValid()) {
            return;
        }
        org.bukkit.Location location = this.disguise.getEntity().getLocation();
        Location loc = new Location(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        for (Player player : this.getEffectedPlayers()) {
            this.onSpawn(player, loc);
        }
    }

    @Override
    @ApiStatus.Internal
    public void onDespawn() {
        if (!this.isValid()) {
            return;
        }
        for (Player player : this.getEffectedPlayers()) {
            this.onDespawn(player, false);
        }
    }

    private WrapperPlayServerUpdateAttributes createAttributes() {
        return new WrapperPlayServerUpdateAttributes(this.entityId, Collections.singletonList(new WrapperPlayServerUpdateAttributes.Property(Attributes.SCALE, this.scale, Collections.emptyList())));
    }

    private Object getMetadata(MetaIndex index) {
        Object value = this.meta.getOrDefault(index, index.getDefault());
        if (index == MetaIndex.ENTITY_META) {
            value = (byte)32;
        }
        return value;
    }

    private List<EntityData<?>> getMetadata() {
        ArrayList watcherValues = new ArrayList();
        for (MetaIndex index : MetaIndex.getMetaIndexes(this.disguiseType.getWatcherClass())) {
            Object changed = this.getMetadata(index);
            if (changed == index.getDefault() && NmsVersion.v1_19_R2.isSupported()) continue;
            watcherValues.add(new WatcherValue(index, this.getMetadata(index), true).getDataValue());
        }
        return watcherValues;
    }

    @Override
    public void onSpawn(Player receiver, Location location) {
        ArrayList<Object> packets = new ArrayList<Object>();
        location = new Location(location.getX(), location.getY() + this.getYOffset(), location.getZ(), location.getYaw(), location.getPitch());
        if (NmsVersion.v1_19_R1.isSupported() || !this.getDisguiseType().isMob()) {
            packets.add(new WrapperPlayServerSpawnEntity(this.getEntityId(), this.getUuid(), this.getDisguiseType().getPacketEntityType(), location, location.getYaw(), 0, Vector3d.zero()));
            packets.add(new WrapperPlayServerEntityMetadata(this.getEntityId(), this.getMetadata()));
            if (this.getDisguiseType().isMob() && NmsVersion.v1_20_R4.isSupported() && this.scale != 1.0) {
                packets.add(this.createAttributes());
            }
        } else {
            packets.add(new WrapperPlayServerSpawnLivingEntity(this.getEntityId(), this.getUuid(), this.getDisguiseType().getPacketEntityType(), location, location.getPitch(), Vector3d.zero(), this.getMetadata()));
        }
        packets.forEach(p -> PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)receiver, p));
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        if (this.getDisguiseType() != DisguiseType.INTERACTION) {
            sb.append(this.getDisguiseType().toReadable());
            sb.append(":");
        }
        sb.append(this.getSizeAsString());
        if (this.getYOffset() != 0.0) {
            sb.append(":");
            sb.append(this.getYOffset());
        }
        return sb.toString();
    }

    private String getSizeAsString() {
        if (this.disguiseType == DisguiseType.INTERACTION) {
            return String.format("%s,%s", this.getMetadata(MetaIndex.INTERACTION_WIDTH), this.getMetadata(MetaIndex.INTERACTION_HEIGHT));
        }
        if (this.meta.containsKey(MetaIndex.SLIME_SIZE)) {
            return this.meta.get(MetaIndex.SLIME_SIZE).toString();
        }
        if (this.meta.containsKey(MetaIndex.PHANTOM_SIZE)) {
            return this.meta.get(MetaIndex.PHANTOM_SIZE).toString();
        }
        return String.valueOf(this.scale);
    }

    @Override
    public void onTeleport(Player receiver, WrapperPlayServerEntityTeleport teleport) {
        EntityPositionData values = DisguiseUtilities.clone(teleport.getValues());
        values.setPosition(values.getPosition().add(0.0, this.getYOffset(), 0.0));
        teleport = new WrapperPlayServerEntityTeleport(this.getEntityId(), values, teleport.getRelativeFlags(), teleport.isOnGround());
        teleport.setEntityId(this.getEntityId());
        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)receiver, (PacketWrapper)teleport);
    }

    @Override
    public void onSync(Player receiver, WrapperPlayServerEntityPositionSync sync) {
        EntityPositionData values = DisguiseUtilities.clone(sync.getValues());
        values.setPosition(values.getPosition().add(0.0, this.getYOffset(), 0.0));
        sync = new WrapperPlayServerEntityPositionSync(this.getEntityId(), values, sync.isOnGround());
        sync.setId(this.getEntityId());
        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)receiver, (PacketWrapper)sync);
    }

    @Generated
    public DisguiseType getDisguiseType() {
        return this.disguiseType;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    @Generated
    public int getEntityId() {
        return this.entityId;
    }

    @Generated
    public double getYOffset() {
        return this.yOffset;
    }

    @Generated
    public void setYOffset(double yOffset) {
        this.yOffset = yOffset;
    }
}

