/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.movements;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnLivingEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.movements.CloningMovementTracker;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherValue;
import org.bukkit.entity.Player;

public class DisguisedVoiceChat
implements CloningMovementTracker {
    private final int entityId;
    private final UUID uuid;

    public DisguisedVoiceChat(UUID uuid) {
        this(ReflectionManager.getNewEntityId(), uuid);
    }

    public DisguiseType getDisguiseType() {
        if (NmsVersion.v1_17.isSupported()) {
            return DisguiseType.MARKER;
        }
        return DisguiseType.AREA_EFFECT_CLOUD;
    }

    @Override
    public void onSpawn(Player receiver, Location location) {
        ArrayList<Object> packets = new ArrayList<Object>();
        if (NmsVersion.v1_19_R1.isSupported() || !this.getDisguiseType().isMob()) {
            packets.add(new WrapperPlayServerSpawnEntity(this.entityId, this.getUuid(), this.getDisguiseType().getPacketEntityType(), location.clone(), location.getYaw(), 0, Vector3d.zero()));
            packets.add(new WrapperPlayServerEntityMetadata(this.entityId, this.getMetadata()));
        } else {
            packets.add(new WrapperPlayServerSpawnLivingEntity(this.entityId, this.getUuid(), this.getDisguiseType().getPacketEntityType(), location.clone(), location.getPitch(), Vector3d.zero(), this.getMetadata()));
        }
        packets.forEach(p -> PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)receiver, p));
    }

    private Object getMetadata(MetaIndex index) {
        Object value = index.getDefault();
        if (index == MetaIndex.ENTITY_META) {
            value = (byte)32;
        } else if (index == MetaIndex.AREA_EFFECT_RADIUS) {
            value = Float.valueOf(0.0f);
        }
        return value;
    }

    private List<EntityData<?>> getMetadata() {
        ArrayList watcherValues = new ArrayList();
        for (MetaIndex index : MetaIndex.getMetaIndexes(this.getDisguiseType().getWatcherClass())) {
            Object changed = this.getMetadata(index);
            if (NmsVersion.v1_19_R2.isSupported() && changed == index.getDefault()) continue;
            watcherValues.add(new WatcherValue(index, changed, true).getDataValue());
        }
        return watcherValues;
    }

    @Override
    @Generated
    public int getEntityId() {
        return this.entityId;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public DisguisedVoiceChat(int entityId, UUID uuid) {
        this.entityId = entityId;
        this.uuid = uuid;
    }
}

