/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.movements;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityHeadLook;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityPositionSync;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMove;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRelativeMoveAndRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.movements.MovementTracker;
import org.bukkit.entity.Player;

public interface CloningMovementTracker
extends MovementTracker {
    public int getEntityId();

    @Override
    default public void onTeleport(Player receiver, WrapperPlayServerEntityTeleport teleport) {
        teleport = new WrapperPlayServerEntityTeleport(this.getEntityId(), DisguiseUtilities.clone(teleport.getValues()), teleport.getRelativeFlags(), teleport.isOnGround());
        teleport.setEntityId(this.getEntityId());
        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)receiver, (PacketWrapper)teleport);
    }

    @Override
    default public void onSync(Player receiver, WrapperPlayServerEntityPositionSync sync) {
        sync = new WrapperPlayServerEntityPositionSync(this.getEntityId(), DisguiseUtilities.clone(sync.getValues()), sync.isOnGround());
        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)receiver, (PacketWrapper)sync);
    }

    @Override
    default public void onRelativeMove(Player receiver, WrapperPlayServerEntityRelativeMove relativeMove) {
        relativeMove = new WrapperPlayServerEntityRelativeMove(this.getEntityId(), relativeMove.getDeltaX(), relativeMove.getDeltaY(), relativeMove.getDeltaZ(), relativeMove.isOnGround());
        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)receiver, (PacketWrapper)relativeMove);
    }

    @Override
    default public void onRelativeMoveLook(Player receiver, WrapperPlayServerEntityRelativeMoveAndRotation relativeMoveAndRotation) {
        relativeMoveAndRotation = new WrapperPlayServerEntityRelativeMoveAndRotation(this.getEntityId(), relativeMoveAndRotation.getDeltaX(), relativeMoveAndRotation.getDeltaY(), relativeMoveAndRotation.getDeltaZ(), relativeMoveAndRotation.getYaw(), relativeMoveAndRotation.getPitch(), relativeMoveAndRotation.isOnGround());
        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)receiver, (PacketWrapper)relativeMoveAndRotation);
    }

    @Override
    default public void onRotation(Player receiver, WrapperPlayServerEntityRotation rotation) {
        rotation = new WrapperPlayServerEntityRotation(this.getEntityId(), rotation.getYaw(), rotation.getPitch(), rotation.isOnGround());
        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)receiver, (PacketWrapper)rotation);
    }

    @Override
    default public void onLook(Player receiver, WrapperPlayServerEntityHeadLook look) {
        look = new WrapperPlayServerEntityHeadLook(this.getEntityId(), look.getHeadYaw());
        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)receiver, (PacketWrapper)look);
    }

    @Override
    default public void onDespawn(Player receiver, boolean fromDestroyPacket) {
        PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)receiver, (PacketWrapper)new WrapperPlayServerDestroyEntities(this.getEntityId()));
    }

    @Override
    default public int[] getOwnedEntityIds() {
        return new int[]{this.getEntityId()};
    }
}

