/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.mineskin;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import lombok.Generated;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.SkinUtils;
import me.libraryaddict.disguise.utilities.mineskin.models.requests.MineSkinRequestFile;
import me.libraryaddict.disguise.utilities.mineskin.models.requests.MineSkinRequestPlayer;
import me.libraryaddict.disguise.utilities.mineskin.models.requests.MineSkinRequestUrl;
import me.libraryaddict.disguise.utilities.mineskin.models.requests.MineSkinSubmitQueue;
import me.libraryaddict.disguise.utilities.mineskin.models.responses.MineSkinQueueResponse;
import me.libraryaddict.disguise.utilities.mineskin.models.structures.MineSkinNotification;
import me.libraryaddict.disguise.utilities.mineskin.models.structures.SkinVariant;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;

public class MineSkinAPI {
    private static final String CRLF = "\r\n";
    private long nextRequest;
    private final ReentrantLock lock = new ReentrantLock();
    private boolean debugging = LibsDisguises.getInstance() == null;
    private String apiKey;
    private static long lastErrorPage;
    private final String userAgent;
    private boolean mentionedApiKey = false;

    public MineSkinAPI() {
        this("third-party");
    }

    public MineSkinAPI(String extraInfo) {
        extraInfo = extraInfo == null || extraInfo.trim().isEmpty() ? "" : (!extraInfo.contains("(") ? " (" + extraInfo.trim() + ")" : " " + extraInfo.trim());
        String version = LibsDisguises.getInstance() == null ? "Not-LD-Itself" : LibsDisguises.getInstance().getDescription().getVersion();
        this.userAgent = "LibsDisguises/" + version + extraInfo;
    }

    public boolean hasApiKey() {
        return StringUtils.isNotBlank((String)this.apiKey);
    }

    private void addConnectionHeaders(HttpURLConnection connection) {
        connection.setConnectTimeout(19000);
        connection.setReadTimeout(19000);
        connection.setDoOutput(true);
        connection.setRequestProperty("User-Agent", this.userAgent);
        String key = this.getApiKey();
        if (!this.hasApiKey()) {
            return;
        }
        if (!key.toLowerCase(Locale.ENGLISH).startsWith("bearer ")) {
            key = "Bearer " + key;
        }
        connection.setRequestProperty("Authorization", key);
    }

    public boolean isInUse() {
        return this.lock.isLocked();
    }

    public int nextRequestIn() {
        long timeTillNext = this.nextRequest - System.currentTimeMillis();
        if (timeTillNext < 0L) {
            return 0;
        }
        return (int)Math.ceil((double)timeTillNext / 1000.0);
    }

    public MineSkinQueueResponse generateFromUrl(SkinUtils.SkinCallback callback, String url, SkinVariant modelType) {
        return this.doPost(callback, new MineSkinRequestUrl().setUrl(url).setVariant(modelType));
    }

    private void printDebug(String message) {
        if (!this.isDebugging()) {
            return;
        }
        if (LibsDisguises.getInstance() != null) {
            LibsDisguises.getInstance().getLogger().info("[MineSkinAPI] " + message);
        } else {
            System.err.println(message);
        }
    }

    private MineSkinQueueResponse readResponse(HttpURLConnection connection, SkinUtils.SkinCallback callback) throws IOException {
        String msg;
        MineSkinQueueResponse mineSkinResponse;
        String response;
        boolean errored;
        int responseCode = connection.getResponseCode();
        this.printDebug("Received status code: " + responseCode);
        boolean bl = errored = responseCode >= 400 && responseCode < 600;
        if (errored) {
            try (InputStream errorStream = connection.getErrorStream();){
                response = new BufferedReader(new InputStreamReader(errorStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                if (LibsDisguises.getInstance() != null) {
                    LibsDisguises.getInstance().getLogger().severe("MineSkin error: " + response);
                } else {
                    System.out.println("MineSkin error: " + response);
                }
                this.printDebug("Received error: " + response);
            }
        }
        try (InputStream inputStream = connection.getInputStream();){
            response = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            this.printDebug("Received: " + response);
        }
        if (!response.startsWith("{")) {
            mineSkinResponse = new MineSkinQueueResponse();
            if (LibsDisguises.getInstance() != null) {
                LibsDisguises.getInstance().getLogger().severe("MineSkin returned malformed response with response code " + responseCode + ": " + response);
            } else {
                System.out.println("MineSkin returned malformed response with response code " + responseCode + ": " + response);
            }
        } else {
            mineSkinResponse = (MineSkinQueueResponse)new Gson().fromJson(response, MineSkinQueueResponse.class);
            mineSkinResponse.setResponseCode(responseCode);
        }
        this.nextRequest = mineSkinResponse.getRateLimit() != null ? mineSkinResponse.getRateLimit().getNext().getAbsolute() + 300L : System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(4L);
        String code = String.valueOf(responseCode);
        String string = msg = response.startsWith("{") ? "" : response;
        if (responseCode == 429) {
            callback.onError(LibsMsg.SKIN_API_FAIL_TOO_FAST, new Object[0]);
            if (!this.hasApiKey() && !this.mentionedApiKey) {
                this.mentionedApiKey = true;
                callback.onInfo(LibsMsg.SKIN_API_SUGGEST_KEY, new Object[0]);
            }
            return null;
        }
        if (responseCode == 408 || responseCode == 504 || responseCode == 599) {
            callback.onError(LibsMsg.SKIN_API_TIMEOUT, new Object[0]);
        }
        if (mineSkinResponse.getErrors() != null && mineSkinResponse.getErrors().length > 0) {
            ArrayList<String> codes = new ArrayList<String>();
            ArrayList<String> messages = new ArrayList<String>();
            for (MineSkinNotification fail : mineSkinResponse.getErrors()) {
                codes.add(fail.getCode());
                messages.add(fail.getMessage());
            }
            callback.onError(LibsMsg.SKIN_API_FAIL_CODE, String.join((CharSequence)", ", codes), String.join((CharSequence)", ", messages));
            return null;
        }
        if (errored) {
            callback.onError(LibsMsg.SKIN_API_FAIL_CODE_EXCEPTIONAL, code, response);
            return null;
        }
        if (mineSkinResponse.getJob() == null || !mineSkinResponse.getJob().isJobRunning() && mineSkinResponse.getSkin() == null) {
            if (LibsDisguises.getInstance() != null) {
                LibsDisguises.getInstance().getLogger().warning("Received an unknown response from MineSkin: " + response);
            }
            callback.onError(LibsMsg.SKIN_API_FAIL, new Object[0]);
            return null;
        }
        return mineSkinResponse;
    }

    private MineSkinQueueResponse getJobStatus(String jobId, SkinUtils.SkinCallback callback) throws IOException {
        URL url = new URL("https://api.mineskin.org/v2/queue/" + jobId);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        this.addConnectionHeaders(con);
        return this.readResponse(con, callback);
    }

    private void sleepUntilReady() {
        long sleep = this.nextRequest - System.currentTimeMillis();
        if (sleep > 0L) {
            this.printDebug("Sleeping for " + sleep + "ms before calling the API due to a recent request");
            Thread.sleep(sleep);
        }
    }

    private void writeFormData(HttpURLConnection connection, MineSkinRequestFile requestFile) throws IOException {
        String boundary = "LD_" + Long.toHexString(System.currentTimeMillis()).toLowerCase();
        String CRLF = CRLF;
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            try (PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8), true);){
                FormData.write(output, writer, boundary, "variant", (Object)requestFile.getVariant());
                FormData.write(output, writer, boundary, "name", requestFile.getName());
                FormData.write(output, writer, boundary, "visibility", (Object)requestFile.getVisibility());
                FormData.write(output, writer, boundary, "file", requestFile.getFile());
                writer.append("--").append(boundary).append("--").append(CRLF).flush();
            }
            byte[] formContent = output.toByteArray();
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            connection.addRequestProperty("Content-Length", Integer.toString(formContent.length));
            try (OutputStream stream = connection.getOutputStream();){
                stream.write(formContent);
                stream.flush();
            }
        }
    }

    private void writeJson(HttpURLConnection connection, MineSkinSubmitQueue request) throws IOException {
        byte[] bytes = new Gson().toJson((Object)request).getBytes(StandardCharsets.UTF_8);
        connection.setRequestProperty("Content-Type", "application/json");
        connection.addRequestProperty("Content-Length", Integer.toString(bytes.length));
        try (OutputStream stream = connection.getOutputStream();){
            stream.write(bytes);
            stream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MineSkinQueueResponse doPost(SkinUtils.SkinCallback callback, MineSkinSubmitQueue mineskinRequest) {
        this.lock.lock();
        this.printDebug("Making request of type " + mineskinRequest.getClass().getSimpleName());
        if (this.getApiKey() != null) {
            this.printDebug("Using a MineSkin api key!");
        }
        this.sleepUntilReady();
        HttpURLConnection connection = null;
        long nextRequestIn = TimeUnit.SECONDS.toMillis(10L);
        try {
            URL url = new URL("https://api.mineskin.org/v2/queue");
            connection = (HttpURLConnection)url.openConnection();
            this.addConnectionHeaders(connection);
            if (mineskinRequest instanceof MineSkinRequestFile) {
                this.writeFormData(connection, (MineSkinRequestFile)mineskinRequest);
            } else {
                this.writeJson(connection, mineskinRequest);
            }
            MineSkinQueueResponse mineSkinResponse = this.readResponse(connection, callback);
            while (mineSkinResponse != null && mineSkinResponse.getJob() != null && mineSkinResponse.getJob().isJobRunning()) {
                this.sleepUntilReady();
                mineSkinResponse = this.getJobStatus(mineSkinResponse.getJob().getId(), callback);
            }
            MineSkinQueueResponse mineSkinQueueResponse = mineSkinResponse;
            return mineSkinQueueResponse;
        }
        catch (SocketTimeoutException ex) {
            if (this.isDebugging()) {
                ex.printStackTrace();
            }
            callback.onError(mineskinRequest instanceof MineSkinRequestUrl ? LibsMsg.SKIN_API_TIMEOUT_ERROR : LibsMsg.SKIN_API_IMAGE_TIMEOUT, new Object[0]);
            MineSkinQueueResponse mineSkinResponse = null;
            return mineSkinResponse;
        }
        catch (Exception ex) {
            block23: {
                try {
                    if (connection == null) break block23;
                    try {
                        int code = connection.getResponseCode();
                        if (connection.getResponseCode() == 524 || connection.getResponseCode() == 408 || connection.getResponseCode() == 504 || connection.getResponseCode() == 599) {
                            if (this.getApiKey() != null && connection.getResponseCode() == 504) {
                                callback.onError(LibsMsg.SKIN_API_TIMEOUT_API_KEY_ERROR, new Object[0]);
                            } else {
                                callback.onError(LibsMsg.SKIN_API_TIMEOUT_ERROR, new Object[0]);
                            }
                            MineSkinQueueResponse mineSkinQueueResponse = null;
                            return mineSkinQueueResponse;
                        }
                    }
                    catch (IOException code) {}
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            if (LibsDisguises.getInstance() != null) {
                LibsDisguises.getInstance().getLogger().warning("Failed to access MineSkin.org");
            }
            ex.printStackTrace();
            callback.onError(LibsMsg.SKIN_API_FAIL, new Object[0]);
            return null;
        }
        finally {
            this.nextRequest = System.currentTimeMillis() + nextRequestIn + 1000L;
            this.lock.unlock();
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public MineSkinQueueResponse generateFromUUID(UUID uuid, SkinVariant modelType) throws IllegalArgumentException {
        return this.doPost(null, new MineSkinRequestPlayer().setUser(uuid.toString()).setVariant(modelType));
    }

    public MineSkinQueueResponse generateFromFile(SkinUtils.SkinCallback callback, File file, SkinVariant modelType) {
        return this.doPost(callback, new MineSkinRequestFile().setFile(file).setVariant(modelType));
    }

    @Generated
    public boolean isDebugging() {
        return this.debugging;
    }

    @Generated
    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Generated
    public boolean isMentionedApiKey() {
        return this.mentionedApiKey;
    }

    static enum FormData {
        FILE((output, writer, boundary, name, data) -> {
            File file = (File)data;
            String type = "png";
            String[] filename = file.getName().split("\\.");
            if (filename.length > 1 && filename[filename.length - 1].length() > 1) {
                type = filename[filename.length - 1].toLowerCase(Locale.ENGLISH);
            }
            writer.append("--").append(boundary).append(MineSkinAPI.CRLF);
            writer.append("Content-Disposition: form-data; name=\"").append(name).append("\"; filename=\"").append(file.getName()).append("\"").append(MineSkinAPI.CRLF);
            writer.append("Content-Type: image/").append(type).append(MineSkinAPI.CRLF);
            writer.append("Content-Transfer-Encoding: binary").append(MineSkinAPI.CRLF);
            writer.append(MineSkinAPI.CRLF).flush();
            Files.copy(file.toPath(), output);
            output.flush();
            writer.append(MineSkinAPI.CRLF);
        }),
        STRING((output, writer, boundary, name, data) -> {
            String asString = data instanceof Enum ? ((Enum)data).name().toLowerCase(Locale.ENGLISH) : data.toString();
            writer.append("--").append(boundary).append(MineSkinAPI.CRLF);
            writer.append("Content-Disposition: form-data; name=\"").append(name).append("\"").append(MineSkinAPI.CRLF);
            writer.append("Content-Type: text/plain; charset=UTF-8").append(MineSkinAPI.CRLF);
            writer.append(MineSkinAPI.CRLF);
            writer.append(asString);
            writer.append(MineSkinAPI.CRLF);
        });

        private final QuadFunction function;

        static void write(ByteArrayOutputStream output, PrintWriter writer, String boundary, String name, Object data) throws IOException {
            if (data == null) {
                return;
            }
            if (data instanceof File) {
                FormData.FILE.function.apply(output, writer, boundary, name, data);
            } else {
                FormData.STRING.function.apply(output, writer, boundary, name, data);
            }
        }

        @Generated
        private FormData(QuadFunction function) {
            this.function = function;
        }

        @Generated
        public QuadFunction getFunction() {
            return this.function;
        }
    }

    @FunctionalInterface
    static interface QuadFunction {
        public void apply(ByteArrayOutputStream var1, PrintWriter var2, String var3, String var4, Object var5) throws IOException;
    }
}

