/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.config.migrations.generics;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseFiles;
import me.libraryaddict.disguise.utilities.config.ConfigMigrator;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class AbstractBundledConfigInjectorMigration
implements ConfigMigrator.ConfigMigration {
    public abstract File getTargetFile();

    public abstract String getBundledConfigName();

    public abstract String getInjectionMarker();

    public abstract String getInjectionStartText();

    public abstract String getInjectionEndText();

    @Override
    public boolean shouldBeDelayed() {
        return !this.getTargetFile().exists();
    }

    public String getContentToInject(YamlConfiguration loadedConfig) {
        String resourceContent = DisguiseFiles.getResourceAsString(LibsDisguises.getInstance().getFile(), this.getBundledConfigName());
        if (resourceContent == null) {
            return "";
        }
        String startMarker = this.getInjectionStartText();
        String endMarker = this.getInjectionEndText();
        int startIndex = resourceContent.indexOf(startMarker);
        if (startIndex == -1) {
            throw new IllegalArgumentException("Cannot find marker '" + startMarker + "' in resource '" + resourceContent + "'");
        }
        int endIndex = resourceContent.indexOf(endMarker, startIndex);
        if (endIndex == -1) {
            throw new IllegalArgumentException("Cannot find marker '" + endMarker + "' in resource '" + resourceContent + "'");
        }
        return resourceContent.substring(startIndex, endIndex + endMarker.length());
    }

    @Override
    public void migrate(YamlConfiguration loadedConfig) {
        String contentToInject;
        int markerPos;
        File targetFile = this.getTargetFile();
        if (!targetFile.exists()) {
            return;
        }
        String targetContent = new String(Files.readAllBytes(targetFile.toPath()), StandardCharsets.UTF_8);
        String injectionMarker = this.getInjectionMarker();
        int injectIndex = 0;
        if (injectionMarker != null && !injectionMarker.isEmpty() && (markerPos = targetContent.indexOf(injectionMarker)) != -1) {
            int endOfLine = targetContent.indexOf(10, markerPos);
            if (endOfLine != -1) {
                injectIndex = endOfLine + 1;
            } else {
                targetContent = targetContent + "\n";
                injectIndex = targetContent.length();
            }
        }
        if ((contentToInject = this.getContentToInject(loadedConfig)) == null || contentToInject.isEmpty()) {
            return;
        }
        String newContent = new StringBuilder(targetContent).insert(injectIndex, contentToInject).toString();
        Files.write(targetFile.toPath(), newContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

