/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.github.retrooper.packetevents.protocol.player.UserProfile;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookup;
import org.jetbrains.annotations.Nullable;

public class SkinResolver {
    private final Disguise disguise;
    private final Consumer<UserProfile> skinUpdated;
    @Nullable
    private volatile LibsProfileLookup currentLookup;
    private boolean skinNeedsToBeResolved = false;
    @Nullable
    private String skin;
    private final Pattern skinAndProfilePattern = Pattern.compile("^(?:(.*?):)?(\\{\"(?:uuid|id)\":.*?,\"name\":.*?})$");
    private final Pattern profilePattern = Pattern.compile("^(\\{\"(?:uuid|id)\":.*?,\"name\":.*?})$");

    public void copyResolver(SkinResolver resolver) {
        if (this.isSkinFullyResolved()) {
            this.skin = resolver.getSkin();
        } else {
            this.setSkin(resolver.getSkin());
        }
    }

    protected void onProfileUpdate(@Nullable UserProfile profile) {
        this.skinUpdated.accept(profile);
    }

    protected boolean isSkinFullyResolved() {
        return !this.skinNeedsToBeResolved && this.getCurrentLookup() == null;
    }

    private synchronized void setResolver(LibsProfileLookup resolver) {
        this.currentLookup = resolver;
        this.skinNeedsToBeResolved = false;
    }

    private synchronized LibsProfileLookup createResolver() {
        this.currentLookup = new LibsProfileLookup(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLookup(UserProfile userProfile) {
                SkinResolver skinResolver = SkinResolver.this;
                synchronized (skinResolver) {
                    if (SkinResolver.this.currentLookup != this) {
                        return;
                    }
                    SkinResolver.this.setResolver(null);
                }
                SkinResolver.this.setSkinInternal(userProfile);
            }
        };
        return this.currentLookup;
    }

    protected String getSkinToLookup() {
        return this.getSkin();
    }

    public void lookupSkinIfNeeded() {
        if (!this.skinNeedsToBeResolved) {
            return;
        }
        this.lookupSkinByName();
    }

    public void lookupSkinByName() {
        this.skinNeedsToBeResolved = false;
        String skin = this.getSkinToLookup();
        if (skin == null) {
            return;
        }
        UserProfile userProfile = DisguiseUtilities.getProfileFromMojang(skin, this.createResolver(), DisguiseConfig.isContactMojangServers());
        if (userProfile == null) {
            return;
        }
        this.setSkinInternal(userProfile);
    }

    public void setSkin(@Nullable String newSkin) {
        String[] split;
        UserProfile profile = this.getProfileFromJson(newSkin);
        if (profile != null) {
            this.setSkin(profile);
            return;
        }
        if (newSkin != null && (split = DisguiseUtilities.splitNewLine(newSkin)).length > 0) {
            newSkin = split[0];
        }
        String oldSkin = this.skin;
        this.skin = newSkin;
        if (newSkin == null) {
            this.setSkinInternal(null);
            return;
        }
        if (newSkin.equals(oldSkin)) {
            return;
        }
        if (!this.getDisguise().isDisguiseInUse()) {
            this.skinNeedsToBeResolved = true;
            return;
        }
        this.lookupSkinByName();
    }

    public UserProfile getProfileFromJson(String string) {
        if (string == null || string.length() <= 70) {
            return null;
        }
        Matcher match = this.profilePattern.matcher(string);
        if (!match.find()) {
            return null;
        }
        try {
            return (UserProfile)DisguiseUtilities.getGson().fromJson(match.group(1), UserProfile.class);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Tried to parse " + string + " to a GameProfile, but it has been formatted incorrectly!");
        }
    }

    private void setSkinInternal(UserProfile profile) {
        this.setResolver(null);
        this.onProfileUpdate(profile);
    }

    public void setSkinAndProfile(String skin, UserProfile profile) {
        this.skin = skin;
        this.setSkinInternal(profile);
    }

    public void setSkin(UserProfile userProfile) {
        this.skin = null;
        this.setSkinInternal(userProfile);
    }

    @Generated
    public SkinResolver(Disguise disguise, Consumer<UserProfile> skinUpdated) {
        this.disguise = disguise;
        this.skinUpdated = skinUpdated;
    }

    @Generated
    public Disguise getDisguise() {
        return this.disguise;
    }

    @Nullable
    @Generated
    public LibsProfileLookup getCurrentLookup() {
        return this.currentLookup;
    }

    @Nullable
    @Generated
    public String getSkin() {
        return this.skin;
    }
}

