/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.github.retrooper.packetevents.protocol.player.UserProfile;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.utilities.SkinResolver;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.jetbrains.annotations.Nullable;

public class PlayerResolver
extends SkinResolver {
    private final PlayerDisguise disguise;
    private UserProfile userProfile;

    public PlayerResolver(PlayerDisguise disguise, Consumer<UserProfile> skinUpdated) {
        super(disguise, skinUpdated);
        this.disguise = disguise;
    }

    @Override
    protected void onProfileUpdate(@Nullable UserProfile profile) {
        this.sanitizeSkin(profile);
        super.onProfileUpdate(profile);
    }

    @Override
    public void copyResolver(SkinResolver resolver) {
        super.copyResolver(resolver);
        if (!resolver.isSkinFullyResolved()) {
            return;
        }
        this.sanitizeSkin(((PlayerResolver)resolver).getUserProfile());
    }

    private void sanitizeSkin(UserProfile userProfile) {
        this.userProfile = ReflectionManager.getUserProfileWithThisSkin(this.getDisguise().getUUID(), this.getDisguise().getProfileName(), userProfile);
    }

    @Override
    public synchronized boolean isSkinFullyResolved() {
        return this.getCurrentLookup() == null && this.userProfile != null;
    }

    public void ensureUniqueProfile() {
        if (!this.hasIncorrectProfileUUIDOrName()) {
            return;
        }
        this.sanitizeSkin(this.userProfile);
    }

    @Override
    protected String getSkinToLookup() {
        String skinToLookup = super.getSkinToLookup();
        if (skinToLookup == null) {
            skinToLookup = this.getDisguise().getName();
        }
        return skinToLookup;
    }

    public UserProfile getUserProfile() {
        if (this.userProfile == null) {
            this.lookupSkinByName();
            this.sanitizeSkin(this.userProfile);
        }
        return this.userProfile;
    }

    public boolean hasIncorrectProfileUUIDOrName() {
        if (this.userProfile == null) {
            return false;
        }
        return !Objects.equals(this.getUserProfile().getName(), this.getDisguise().getProfileName());
    }

    @Override
    @Generated
    public PlayerDisguise getDisguise() {
        return this.disguise;
    }
}

