/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import org.bukkit.configuration.file.YamlConfiguration;

public class DisguiseFiles {
    private static final File internalFolder;
    private static final File preferencesFile;
    private static final File profileCache;
    private static final File sanitySkinCacheFile;
    private static final File savedDisguisesFolder;

    public static void init() {
        if (DisguiseFiles.getInternalFolder() == null) {
            return;
        }
        if (!DisguiseFiles.getInternalFolder().exists()) {
            DisguiseFiles.getInternalFolder().mkdirs();
        }
    }

    public static String getResourceAsString(File file, String fileName) {
        try {
            return DisguiseFiles.getResourceAsStringEx(file, fileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getJarFileCount(File file) throws IOException {
        try (JarFile jar = new JarFile(file);){
            int count = 0;
            Enumeration<JarEntry> entry = jar.entries();
            while (entry.hasMoreElements()) {
                if (entry.nextElement().isDirectory()) continue;
                ++count;
            }
            int n = count;
            return n;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getResourceAsStringEx(File file, String fileName) {
        try (JarFile jar = new JarFile(file);){
            String string;
            block13: {
                JarEntry entry = jar.getJarEntry(fileName);
                InputStream stream = jar.getInputStream(entry);
                try {
                    string = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    if (stream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return string;
        }
    }

    public static List<File> getFilesByPlugin(String pluginName) {
        return DisguiseFiles.getFilesByPlugin(LibsDisguises.getInstance().getDataFolder().getAbsoluteFile().getParentFile(), pluginName);
    }

    public static List<File> getFilesByPlugin(File containingFolder, String pluginName) {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : containingFolder.listFiles()) {
            YamlConfiguration config;
            block3: {
                if (!file.isFile() || !file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
                config = null;
                try {
                    config = DisguiseFiles.getPluginYAMLEx(file);
                }
                catch (Throwable ex) {
                    if (!DisguiseConfig.isVerboseLogging()) break block3;
                    ex.printStackTrace();
                }
            }
            if (config == null || !pluginName.equalsIgnoreCase(config.getString("name"))) continue;
            files.add(file);
        }
        return files;
    }

    public static YamlConfiguration getPluginYAML(File file) {
        try {
            return DisguiseFiles.getPluginYAMLEx(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static YamlConfiguration getPluginYAMLEx(File file) throws Exception {
        String s = DisguiseFiles.getResourceAsString(file, "plugin.yml");
        if (s == null) {
            return null;
        }
        YamlConfiguration config = new YamlConfiguration();
        config.loadFromString(DisguiseFiles.getResourceAsString(file, "plugin.yml"));
        return config;
    }

    @Generated
    public static File getInternalFolder() {
        return internalFolder;
    }

    @Generated
    public static File getPreferencesFile() {
        return preferencesFile;
    }

    @Generated
    public static File getProfileCache() {
        return profileCache;
    }

    @Generated
    public static File getSanitySkinCacheFile() {
        return sanitySkinCacheFile;
    }

    @Generated
    public static File getSavedDisguisesFolder() {
        return savedDisguisesFolder;
    }

    static {
        if (LibsDisguises.getInstance() == null) {
            profileCache = null;
            sanitySkinCacheFile = null;
            savedDisguisesFolder = null;
            internalFolder = null;
            preferencesFile = null;
        } else {
            profileCache = new File(LibsDisguises.getInstance().getDataFolder(), "SavedSkins");
            sanitySkinCacheFile = new File(LibsDisguises.getInstance().getDataFolder(), "SavedSkins/sanity.json");
            savedDisguisesFolder = new File(LibsDisguises.getInstance().getDataFolder(), "SavedDisguises");
            internalFolder = new File(LibsDisguises.getInstance().getDataFolder(), "internal");
            preferencesFile = new File(DisguiseFiles.getInternalFolder(), "preferences.json");
        }
        DisguiseFiles.init();
    }
}

