/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import java.util.HashMap;
import java.util.Map;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.FishWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.DyeColor;
import org.bukkit.entity.TropicalFish;

public class TropicalFishWatcher
extends FishWatcher {
    public TropicalFishWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setPattern(ReflectionManager.randomEnum(TropicalFish.Pattern.class));
            this.setBodyColor(ReflectionManager.randomEnum(DyeColor.class));
            this.setPatternColor(ReflectionManager.randomEnum(DyeColor.class));
        }
    }

    public DyeColor getPatternColor() {
        return DyeColor.getByWoolData((byte)((byte)(this.getVariant() >> 24 & 0xFF)));
    }

    @RandomDefaultValue
    public void setPatternColor(DyeColor dyeColor) {
        this.setVariant(dyeColor != null ? this.getData(dyeColor, this.getBodyColor(), this.getPattern()) : -1);
    }

    private int getData(DyeColor patternColor, DyeColor bodyColor, TropicalFish.Pattern type) {
        return patternColor.getWoolData() << 24 | bodyColor.getWoolData() << 16 | CraftPattern.values()[type.ordinal()].getDataValue();
    }

    public DyeColor getBodyColor() {
        return DyeColor.getByWoolData((byte)((byte)(this.getVariant() >> 16 & 0xFF)));
    }

    @RandomDefaultValue
    public void setBodyColor(DyeColor dyeColor) {
        this.setVariant(dyeColor != null ? this.getData(this.getPatternColor(), dyeColor, this.getPattern()) : -1);
    }

    public TropicalFish.Pattern getPattern() {
        return CraftPattern.fromData(this.getVariant() & 0xFFFF);
    }

    @RandomDefaultValue
    public void setPattern(TropicalFish.Pattern pattern) {
        this.setVariant(pattern != null ? this.getData(this.getPatternColor(), this.getBodyColor(), pattern) : -1);
    }

    @Deprecated
    public int getVariant() {
        return this.getData(MetaIndex.TROPICAL_FISH_VARIANT);
    }

    @Deprecated
    public void setVariant(int variant) {
        this.sendData(MetaIndex.TROPICAL_FISH_VARIANT, variant >= 0 ? Integer.valueOf(variant) : null);
    }

    private static enum CraftPattern {
        KOB("KOB", 0, 0, false),
        SUNSTREAK("SUNSTREAK", 1, 1, false),
        SNOOPER("SNOOPER", 2, 2, false),
        DASHER("DASHER", 3, 3, false),
        BRINELY("BRINELY", 4, 4, false),
        SPOTTY("SPOTTY", 5, 5, false),
        FLOPPER("FLOPPER", 6, 0, true),
        STRIPEY("STRIPEY", 7, 1, true),
        GLITTER("GLITTER", 8, 2, true),
        BLOCKFISH("BLOCKFISH", 9, 3, true),
        BETTY("BETTY", 10, 4, true),
        CLAYFISH("CLAYFISH", 11, 5, true);

        private final int variant;
        private final boolean large;
        private static final Map<Integer, TropicalFish.Pattern> BY_DATA;

        static TropicalFish.Pattern fromData(int data) {
            return BY_DATA.get(data);
        }

        private CraftPattern(String s, int n2, int variant, boolean large) {
            this.variant = variant;
            this.large = large;
        }

        public int getDataValue() {
            return this.variant << 8 | (this.large ? 1 : 0);
        }

        static {
            BY_DATA = new HashMap<Integer, TropicalFish.Pattern>();
            for (CraftPattern type : CraftPattern.values()) {
                BY_DATA.put(type.getDataValue(), TropicalFish.Pattern.values()[type.ordinal()]);
            }
        }
    }
}

