/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.util.Vector3i;
import java.util.Optional;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.InsentientWatcher;
import org.bukkit.DyeColor;
import org.bukkit.block.BlockFace;

public class ShulkerWatcher
extends InsentientWatcher {
    public ShulkerWatcher(Disguise disguise) {
        super(disguise);
    }

    public BlockFace getFacingDirection() {
        return BlockFace.valueOf((String)this.getData(MetaIndex.SHULKER_FACING).name());
    }

    public void setFacingDirection(BlockFace face) {
        this.sendData(MetaIndex.SHULKER_FACING, face != null ? com.github.retrooper.packetevents.protocol.world.BlockFace.valueOf((String)face.name()) : null);
    }

    public Vector3i getAttachmentPosition() {
        return this.getData(MetaIndex.SHULKER_ATTACHED).orElse(null);
    }

    public void setAttachmentPosition(Vector3i attachmentPosition) {
        this.sendData(MetaIndex.SHULKER_ATTACHED, attachmentPosition != null ? Optional.of(attachmentPosition) : null);
    }

    public void setAttachmentPosition(Optional<Vector3i> attachmentPosition) {
        this.sendData(MetaIndex.SHULKER_ATTACHED, attachmentPosition);
    }

    public int getShieldHeight() {
        return this.getData(MetaIndex.SHULKER_PEEKING).byteValue();
    }

    public void setShieldHeight(int newHeight) {
        if (newHeight < 0) {
            newHeight = 0;
        }
        if (newHeight > 127) {
            newHeight = 127;
        }
        this.sendData(MetaIndex.SHULKER_PEEKING, (byte)newHeight);
    }

    public DyeColor getColor() {
        if (!this.hasValue(MetaIndex.SHULKER_COLOR) || this.getData(MetaIndex.SHULKER_COLOR) == 16) {
            return DyeColor.PURPLE;
        }
        return AnimalColor.getColorByWool(this.getData(MetaIndex.SHULKER_COLOR).byteValue()).getDyeColor();
    }

    @Deprecated
    public void setColor(AnimalColor color) {
        this.setColor(color.getDyeColor());
    }

    public void setColor(DyeColor newColor) {
        if (newColor == this.getColor()) {
            return;
        }
        this.sendData(MetaIndex.SHULKER_COLOR, newColor != null ? Byte.valueOf(newColor.getWoolData()) : null);
    }
}

