/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTInt;
import com.github.retrooper.packetevents.protocol.nbt.NBTNumber;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import java.util.Optional;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AvatarWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.entity.Parrot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerWatcher
extends AvatarWatcher {
    private boolean alwaysShowInTab = DisguiseConfig.isShowDisguisedPlayersInTab();

    public PlayerWatcher(Disguise disguise) {
        super(disguise);
    }

    @Override
    protected MetaIndex<Byte> getSkinMeta() {
        if (!NmsVersion.v1_21_R6.isSupported()) {
            return MetaIndex.PLAYER_SKIN;
        }
        return super.getSkinMeta();
    }

    @Override
    protected MetaIndex<?> getHandMeta() {
        if (!NmsVersion.v1_21_R6.isSupported()) {
            return MetaIndex.PLAYER_HAND;
        }
        return super.getHandMeta();
    }

    @NotNull
    public UserProfile getSkin() {
        return ((PlayerDisguise)this.getDisguise()).getUserProfile();
    }

    @Override
    @Nullable
    public String getSkinName() {
        return ((PlayerDisguise)this.getDisguise()).getSkin();
    }

    @Override
    public void setSkin(@Nullable String playerName) {
        ((PlayerDisguise)this.getDisguise()).setSkin(playerName);
    }

    @Override
    @RandomDefaultValue
    public void setSkin(@Nullable UserProfile profile) {
        ((PlayerDisguise)this.getDisguise()).setSkin(profile);
    }

    public boolean isDisplayedInTab() {
        return this.alwaysShowInTab;
    }

    public void setDisplayedInTab(boolean showPlayerInTab) {
        if (this.getDisguise().isDisguiseInUse()) {
            throw new IllegalStateException("Cannot set this while disguise is in use!");
        }
        this.alwaysShowInTab = showPlayerInTab;
    }

    public boolean isNameVisible() {
        return ((PlayerDisguise)this.getDisguise()).isNameVisible();
    }

    public void setNameVisible(boolean nameVisible) {
        ((PlayerDisguise)this.getDisguise()).setNameVisible(nameVisible);
    }

    public String getName() {
        return ((PlayerDisguise)this.getDisguise()).getName();
    }

    @RandomDefaultValue
    public void setName(String name) {
        ((PlayerDisguise)this.getDisguise()).setName(name);
    }

    public String getTablistName() {
        return ((PlayerDisguise)this.getDisguise()).getTablistName();
    }

    @RandomDefaultValue
    public void setTablistName(String tablistName) {
        ((PlayerDisguise)this.getDisguise()).setTablistName(tablistName);
    }

    @Override
    public PlayerWatcher clone(Disguise disguise) {
        PlayerWatcher watcher = (PlayerWatcher)super.clone(disguise);
        watcher.alwaysShowInTab = this.alwaysShowInTab;
        return watcher;
    }

    @Nullable
    public Parrot.Variant getRightShoulderParrot() {
        if (!NmsVersion.v1_21_R6.isSupported()) {
            return this.getParrot(MetaIndex.PLAYER_RIGHT_SHOULDER_ENTITY_OLD);
        }
        return this.getData(MetaIndex.PLAYER_RIGHT_SHOULDER_ENTITY).map(integer -> Parrot.Variant.values()[integer]).orElse(null);
    }

    public void setRightShoulderParrot(@Nullable Parrot.Variant variant) {
        if (!NmsVersion.v1_21_R6.isSupported()) {
            if (variant == null) {
                this.sendData(MetaIndex.PLAYER_RIGHT_SHOULDER_ENTITY_OLD, null);
            } else {
                this.setParrot(MetaIndex.PLAYER_RIGHT_SHOULDER_ENTITY_OLD, variant);
            }
            return;
        }
        this.sendData(MetaIndex.PLAYER_RIGHT_SHOULDER_ENTITY, variant != null ? Optional.of(variant.ordinal()) : null);
    }

    @Nullable
    public Parrot.Variant getLeftShoulderParrot() {
        if (!NmsVersion.v1_21_R6.isSupported()) {
            return this.getParrot(MetaIndex.PLAYER_LEFT_SHOULDER_ENTITY_OLD);
        }
        return this.getData(MetaIndex.PLAYER_LEFT_SHOULDER_ENTITY).map(integer -> Parrot.Variant.values()[integer]).orElse(null);
    }

    public void setLeftShoulderParrot(@Nullable Parrot.Variant variant) {
        if (!NmsVersion.v1_21_R6.isSupported()) {
            if (variant == null) {
                this.sendData(MetaIndex.PLAYER_LEFT_SHOULDER_ENTITY_OLD, null);
            } else {
                this.setParrot(MetaIndex.PLAYER_LEFT_SHOULDER_ENTITY_OLD, variant);
            }
            return;
        }
        this.sendData(MetaIndex.PLAYER_LEFT_SHOULDER_ENTITY, variant != null ? Optional.of(variant.ordinal()) : null);
    }

    public boolean isRightShoulderHasParrot() {
        if (!NmsVersion.v1_21_R6.isSupported()) {
            return this.getData(MetaIndex.PLAYER_RIGHT_SHOULDER_ENTITY_OLD).getStringTagOrNull("id") != null;
        }
        return this.getData(MetaIndex.PLAYER_RIGHT_SHOULDER_ENTITY).isPresent();
    }

    public void setRightShoulderHasParrot(boolean hasParrot) {
        if (this.isRightShoulderHasParrot() == hasParrot) {
            return;
        }
        if (hasParrot) {
            this.setRightShoulderParrot(Parrot.Variant.RED);
        } else {
            this.setRightShoulderParrot(null);
        }
    }

    public boolean isLeftShoulderHasParrot() {
        if (!NmsVersion.v1_21_R6.isSupported()) {
            return this.getData(MetaIndex.PLAYER_LEFT_SHOULDER_ENTITY_OLD).getStringTagOrNull("id") != null;
        }
        return this.getData(MetaIndex.PLAYER_LEFT_SHOULDER_ENTITY).isPresent();
    }

    public void setLeftShoulderHasParrot(boolean hasParrot) {
        if (this.isLeftShoulderHasParrot() == hasParrot) {
            return;
        }
        if (hasParrot) {
            this.setLeftShoulderParrot(Parrot.Variant.RED);
        } else {
            this.setLeftShoulderParrot(null);
        }
    }

    private Parrot.Variant getParrot(MetaIndex<NBTCompound> meta) {
        NBTCompound nbt = this.getData(meta);
        NBTNumber number = nbt.getNumberTagOrNull("Variant");
        if (number == null) {
            return Parrot.Variant.RED;
        }
        return Parrot.Variant.values()[number.getAsInt()];
    }

    private void setParrot(MetaIndex<NBTCompound> meta, @Nullable Parrot.Variant variant) {
        NBTCompound nbt = new NBTCompound();
        if (variant != null) {
            nbt.setTag("id", (NBT)new NBTString("minecraft:parrot"));
            nbt.setTag("Variant", (NBT)new NBTInt(variant.ordinal()));
        }
        this.sendData(meta, nbt);
    }
}

