/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.protocol.component.builtin.item.ItemProfile;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import java.util.ArrayList;
import java.util.Optional;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AvatarWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.SkinResolver;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MannequinWatcher
extends AvatarWatcher {
    private final SkinResolver skinResolver;

    public MannequinWatcher(Disguise disguise) {
        super(disguise);
        this.skinResolver = new SkinResolver(disguise, this::setSkin);
    }

    @Override
    public MannequinWatcher clone(Disguise disguise) {
        MannequinWatcher watcher = (MannequinWatcher)super.clone(disguise);
        watcher.skinResolver.copyResolver(this.skinResolver);
        return watcher;
    }

    @Override
    protected void onPreDisguiseStart() {
        super.onPreDisguiseStart();
        this.skinResolver.lookupSkinIfNeeded();
    }

    @Override
    @Nullable
    public String getSkinName() {
        return this.skinResolver.getSkin();
    }

    @Override
    public void setSkin(String playerName) {
        if (playerName == null) {
            this.skinResolver.setSkin(playerName);
            return;
        }
        if (playerName.startsWith("{") && playerName.startsWith("}")) {
            try {
                this.setSkin((ItemProfile)DisguiseUtilities.getGson().fromJson(playerName, ItemProfile.class));
                return;
            }
            catch (Exception exception) {}
        } else if (playerName.contains("/") && playerName.matches("([a-z0-9._-]+:)?[a-z0-9._/-]+")) {
            try {
                this.setSkin(new ItemProfile(null, null, new ArrayList(), new ItemProfile.SkinPatch(new ResourceLocation(playerName), null, null, null)));
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.skinResolver.setSkin(playerName);
    }

    @Override
    public void setSkin(@Nullable UserProfile profile) {
        this.setSkin(profile != null ? DisguiseUtilities.getItemProfile(profile) : null);
    }

    @NotNull
    public ItemProfile getSkin() {
        return this.getData(MetaIndex.MANNEQUIN_PROFILE);
    }

    @RandomDefaultValue
    public void setSkin(@Nullable ItemProfile profile) {
        this.sendData(MetaIndex.MANNEQUIN_PROFILE, profile);
    }

    @Nullable
    public Component getDescription() {
        return this.getData(MetaIndex.MANNEQUIN_DESCRIPTION).orElse(null);
    }

    public void setDescription(@Nullable Component description) {
        this.setData(MetaIndex.MANNEQUIN_DESCRIPTION, description != null ? Optional.of(description) : null);
    }

    public void setDescription(@Nullable Optional<Component> description) {
        this.setData(MetaIndex.MANNEQUIN_DESCRIPTION, description);
    }
}

