/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.ChestedHorseWatcher;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Llama;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class LlamaWatcher
extends ChestedHorseWatcher {
    public LlamaWatcher(Disguise disguise) {
        super(disguise);
    }

    public Llama.Color getColor() {
        return this.getData(MetaIndex.LLAMA_COLOR);
    }

    public void setColor(Llama.Color color) {
        this.sendData(MetaIndex.LLAMA_COLOR, color);
    }

    public DyeColor getCarpet() {
        if (NmsVersion.v1_20_R4.isSupported()) {
            ItemStack item = this.getItemStack(EquipmentSlot.BODY);
            if (item == null) {
                return null;
            }
            AnimalColor color = AnimalColor.getColorByWool(item.getType());
            if (color == null) {
                return null;
            }
            return color.getDyeColor();
        }
        int color = this.getData(MetaIndex.LLAMA_CARPET);
        if (color == -1) {
            return null;
        }
        return AnimalColor.getColorByWool(color).getDyeColor();
    }

    public void setCarpet(DyeColor dyeColor) {
        AnimalColor color;
        if (!NmsVersion.v1_20_R4.isSupported()) {
            this.sendData(MetaIndex.LLAMA_CARPET, dyeColor != null ? Integer.valueOf(dyeColor.getWoolData()) : null);
            return;
        }
        ItemStack item = null;
        if (dyeColor != null && (color = AnimalColor.getColor(dyeColor)) != null) {
            item = new ItemStack(color.getCarpetMaterial());
        }
        this.setItemStack(EquipmentSlot.BODY, item);
    }

    @Deprecated
    public void setCarpet(AnimalColor color) {
        this.setCarpet(color != null ? color.getDyeColor() : null);
    }

    public void setCarpetShown(boolean carpetShown) {
        if (NmsVersion.v1_20_R4.isSupported()) {
            if (this.getItemStack(EquipmentSlot.BODY) != null == carpetShown) {
                return;
            }
            if (!carpetShown) {
                this.setItemStack(EquipmentSlot.BODY, new ItemStack(Material.AIR));
            } else {
                this.setItemStack(EquipmentSlot.BODY, new ItemStack(AnimalColor.RED.getCarpetMaterial()));
            }
        } else if (this.hasValue(MetaIndex.LLAMA_CARPET) && this.getData(MetaIndex.LLAMA_CARPET) != -1 == carpetShown) {
            return;
        }
        this.sendData(MetaIndex.LLAMA_CARPET, -1);
    }

    public int getStrength() {
        return this.getData(MetaIndex.LLAMA_STRENGTH);
    }

    public void setStrength(int strength) {
        this.sendData(MetaIndex.LLAMA_STRENGTH, strength);
    }
}

