/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.protocol.player.HumanoidArm;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import org.bukkit.inventory.MainHand;
import org.jetbrains.annotations.Nullable;

public abstract class AvatarWatcher
extends LivingWatcher {
    public AvatarWatcher(Disguise disguise) {
        super(disguise);
        this.setData(this.getSkinMeta(), this.getSkinMeta().getDefault());
        this.setMainHand(MainHand.RIGHT);
    }

    public MainHand getMainHand() {
        if (this.getHandMeta().getDefault() instanceof HumanoidArm) {
            return MainHand.valueOf((String)((HumanoidArm)this.getData(this.getHandMeta())).name());
        }
        return MainHand.values()[(Byte)this.getData(this.getHandMeta())];
    }

    public void setMainHand(MainHand mainHand) {
        if (this.getHandMeta().getDefault() instanceof HumanoidArm) {
            this.sendData(this.getHandMeta(), mainHand != null ? HumanoidArm.valueOf((String)mainHand.name()) : null);
        } else {
            this.sendData(this.getHandMeta(), mainHand != null ? Byte.valueOf((byte)mainHand.ordinal()) : null);
        }
    }

    protected MetaIndex<Byte> getSkinMeta() {
        return MetaIndex.AVATAR_SKIN;
    }

    protected MetaIndex<?> getHandMeta() {
        return MetaIndex.AVATAR_HAND;
    }

    private boolean isSkinFlag(int i) {
        return (this.getData(this.getSkinMeta()) & 1 << i) != 0;
    }

    private void setSkinData(int i, boolean flag) {
        byte b0 = this.getData(this.getSkinMeta());
        if (flag) {
            this.sendData(this.getSkinMeta(), (byte)(b0 | 1 << i));
        } else {
            this.sendData(this.getSkinMeta(), (byte)(b0 & ~(1 << i)));
        }
    }

    public boolean isCapeEnabled() {
        return this.isSkinFlag(1);
    }

    public void setCapeEnabled(boolean enabled) {
        this.setSkinData(0, enabled);
    }

    public boolean isJacketEnabled() {
        return this.isSkinFlag(1);
    }

    public void setJacketEnabled(boolean enabled) {
        this.setSkinData(1, enabled);
    }

    public boolean isLeftSleeveEnabled() {
        return this.isSkinFlag(2);
    }

    public void setLeftSleeveEnabled(boolean enabled) {
        this.setSkinData(2, enabled);
    }

    public boolean isRightSleeveEnabled() {
        return this.isSkinFlag(3);
    }

    public void setRightSleeveEnabled(boolean enabled) {
        this.setSkinData(3, enabled);
    }

    public boolean isLeftPantsEnabled() {
        return this.isSkinFlag(4);
    }

    public void setLeftPantsEnabled(boolean enabled) {
        this.setSkinData(4, enabled);
    }

    public boolean isRightPantsEnabled() {
        return this.isSkinFlag(5);
    }

    public void setRightPantsEnabled(boolean enabled) {
        this.setSkinData(5, enabled);
    }

    public boolean isHatEnabled() {
        return this.isSkinFlag(6);
    }

    public void setHatEnabled(boolean enabled) {
        this.setSkinData(6, enabled);
    }

    @Nullable
    public abstract String getSkinName();

    public abstract void setSkin(@Nullable String var1);

    @RandomDefaultValue
    public abstract void setSkin(UserProfile var1);
}

