/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleType;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodDescription;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsRemovedIn;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.Color;
import org.bukkit.Particle;

public class AreaEffectCloudWatcher
extends FlagWatcher {
    public AreaEffectCloudWatcher(Disguise disguise) {
        super(disguise);
        if (!NmsVersion.v1_20_R4.isSupported() && DisguiseConfig.isRandomDisguises()) {
            this.setColor(Color.fromRGB((int)RandomUtils.nextInt((int)256), (int)RandomUtils.nextInt((int)256), (int)RandomUtils.nextInt((int)256)));
        }
    }

    public float getRadius() {
        return this.getData(MetaIndex.AREA_EFFECT_RADIUS).floatValue();
    }

    @MethodDescription(value="How big is this Area Effect Cloud?")
    public void setRadius(float radius) {
        if (radius > 30.0f) {
            radius = 30.0f;
        } else if ((double)radius < 0.1) {
            radius = 0.1f;
        }
        this.sendData(MetaIndex.AREA_EFFECT_RADIUS, Float.valueOf(radius));
    }

    @NmsRemovedIn(value=NmsVersion.v1_20_R4)
    public Color getColor() {
        return this.getData(MetaIndex.AREA_EFFECT_CLOUD_COLOR);
    }

    @RandomDefaultValue
    @MethodDescription(value="What's the color of this Area Effect Cloud?")
    @NmsRemovedIn(value=NmsVersion.v1_20_R4)
    public void setColor(Color color) {
        this.sendData(MetaIndex.AREA_EFFECT_CLOUD_COLOR, color);
    }

    public boolean isIgnoreRadius() {
        return this.getData(MetaIndex.AREA_EFFECT_IGNORE_RADIUS);
    }

    @MethodDescription
    public void setIgnoreRadius(boolean ignore) {
        this.sendData(MetaIndex.AREA_EFFECT_IGNORE_RADIUS, ignore);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public com.github.retrooper.packetevents.protocol.particle.Particle<?> getParticle() {
        if (NmsVersion.v1_13.isSupported()) {
            return this.getData(MetaIndex.AREA_EFFECT_PARTICLE);
        }
        int particleId = this.getData(MetaIndex.AREA_EFFECT_PARTICLE_OLD);
        return new com.github.retrooper.packetevents.protocol.particle.Particle(ParticleTypes.getById((ClientVersion)PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), (int)particleId));
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    @MethodDescription(value="What particle is this Area Effect Cloud using?")
    public void setParticle(com.github.retrooper.packetevents.protocol.particle.Particle particle) {
        if (NmsVersion.v1_13.isSupported()) {
            this.sendData(MetaIndex.AREA_EFFECT_PARTICLE, particle);
        } else {
            this.setParticleType(particle != null ? (Particle)SpigotConversionUtil.toBukkitParticle((ParticleType)particle.getType()) : null);
        }
    }

    @Deprecated
    public Particle getParticleType() {
        if (NmsVersion.v1_13.isSupported()) {
            return (Particle)SpigotConversionUtil.toBukkitParticle((ParticleType)this.getData(MetaIndex.AREA_EFFECT_PARTICLE).getType());
        }
        return ReflectionManager.fromEnum(Particle.class, this.getData(MetaIndex.AREA_EFFECT_PARTICLE_OLD));
    }

    @Deprecated
    @MethodDescription(value="What particle type is this Area Effect Cloud using?")
    public void setParticleType(Particle particle) {
        if (NmsVersion.v1_13.isSupported()) {
            this.setParticle(particle != null ? new com.github.retrooper.packetevents.protocol.particle.Particle(SpigotConversionUtil.fromBukkitParticle((Enum)particle)) : null);
        } else {
            this.sendData(MetaIndex.AREA_EFFECT_PARTICLE_OLD, particle != null ? Integer.valueOf(ReflectionManager.enumOrdinal(particle)) : null);
        }
    }
}

