/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import com.mojang.authlib.GameProfile;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.PlayerResolver;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class PlayerDisguise
extends TargetedDisguise {
    private final PlayerResolver skinResolver = new PlayerResolver(this, skinResolved -> {
        if (!this.isDisguiseInUse()) {
            return;
        }
        this.refreshDisguise();
    });
    private String playerName = "Herobrine";
    private String tablistName;
    private boolean nameVisible = true;
    private boolean explicitNameVisible = false;
    private transient DisguiseUtilities.DScoreTeam scoreboardName;
    private boolean deadmau5Ears;

    private PlayerDisguise() {
        super(DisguiseType.PLAYER);
    }

    public PlayerDisguise(Player player) {
        this(ReflectionManager.getUserProfile(player));
    }

    public PlayerDisguise(Player player, Player skinToUse) {
        this(ReflectionManager.getUserProfile(player), ReflectionManager.getUserProfile(skinToUse));
    }

    public PlayerDisguise(String name) {
        this(name, name);
    }

    public PlayerDisguise(String name, String skinToUse) {
        this();
        UserProfile profile;
        if (name.equals(skinToUse) && (profile = this.skinResolver.getProfileFromJson(skinToUse)) != null) {
            this.setName(profile.getName());
            this.setSkin(profile);
            this.createDisguise();
            return;
        }
        this.setName(name);
        this.setSkin(skinToUse);
        this.createDisguise();
    }

    public PlayerDisguise(UserProfile userProfile) {
        this();
        this.setName(userProfile.getName());
        this.skinResolver.setSkin(userProfile);
        this.createDisguise();
    }

    public PlayerDisguise(UserProfile userProfile, UserProfile skinToUse) {
        this();
        this.setName(userProfile.getName());
        this.setSkin(skinToUse);
        this.createDisguise();
    }

    @Override
    public double getHeight() {
        if (this.getWatcher() == null) {
            return 1.8;
        }
        if (this.getEntity() == null || this.getWatcher().getModifiedEntityAnimations()[1]) {
            return this.getWatcher().isSneaking() ? 1.5 : 1.8;
        }
        return this.getEntity() instanceof Player && ((Player)this.getEntity()).isSneaking() ? 1.5 : 1.8;
    }

    @Deprecated
    public DisguiseUtilities.DScoreTeam getScoreboardName() {
        if (!DisguiseConfig.isScoreboardNames()) {
            throw new IllegalStateException("Cannot use this method when it's been disabled in config!");
        }
        if (this.scoreboardName == null) {
            this.scoreboardName = this.isUpsideDown() || this.isDeadmau5Ears() ? new DisguiseUtilities.DScoreTeam(this, new String[]{"", this.getProfileName(), ""}) : DisguiseUtilities.createExtendedName(this);
        }
        return this.scoreboardName;
    }

    private void setScoreboardName(String[] split) {
        if (this.isUpsideDown() || this.isDeadmau5Ears()) {
            return;
        }
        this.getScoreboardName().setSplit(split);
    }

    private boolean isStaticName(String name) {
        return name != null && (name.equalsIgnoreCase("Dinnerbone") || name.equalsIgnoreCase("Grumm"));
    }

    public boolean hasScoreboardName() {
        if (!this.getInternals().getNameDisplayType().isFakeEntity() && this.isStaticName(this.getName())) {
            return false;
        }
        return DisguiseConfig.isScoreboardNames();
    }

    @ApiStatus.Internal
    public String getProfileName() {
        if (this.isUpsideDown()) {
            return "Dinnerbone";
        }
        if (this.isDeadmau5Ears()) {
            return "deadmau5";
        }
        if (this.hasScoreboardName()) {
            return this.getScoreboardName().getPlayer();
        }
        if (this.getName().isEmpty()) {
            return "\u00a7r";
        }
        return this.getName();
    }

    public PlayerDisguise setNameVisible(boolean nameVisible) {
        return this.setNameVisible(nameVisible, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PlayerDisguise setNameVisible(boolean nameVisible, boolean setInternally) {
        if (this.isNameVisible() == nameVisible || setInternally && this.explicitNameVisible) {
            return this;
        }
        if (!setInternally) {
            this.explicitNameVisible = true;
        }
        if (this.isDisguiseInUse()) {
            if (this.getInternals().getNameDisplayType().isFakeEntity()) {
                this.nameVisible = nameVisible;
                this.sendArmorStands(this.isNameVisible() ? this.getMultiName() : new String[]{});
                return this;
            } else {
                if (!DisguiseConfig.isScoreboardNames()) {
                    if (!this.removeDisguise()) throw new IllegalStateException("Unable to restart disguise");
                    this.nameVisible = nameVisible;
                    DisguiseUtilities.resetPluginTimer();
                    if (this.startDisguise()) return this;
                    throw new IllegalStateException("Unable to restart disguise");
                }
                this.nameVisible = nameVisible;
                DisguiseUtilities.updateExtendedName(this);
            }
            return this;
        } else {
            this.nameVisible = nameVisible;
        }
        return this;
    }

    @Override
    public PlayerDisguise addPlayer(Player player) {
        return (PlayerDisguise)super.addPlayer(player);
    }

    @Override
    public PlayerDisguise addPlayer(String playername) {
        return (PlayerDisguise)super.addPlayer(playername);
    }

    @Override
    public PlayerDisguise setUpsideDown(boolean upsideDown) {
        if (this.isUpsideDown() == upsideDown) {
            return this;
        }
        this.getWatcher().setInternalUpsideDown(upsideDown);
        if (this.isDisguiseInUse()) {
            this.resendDisguise(this.getInternals().getNameDisplayType().isFakeEntity() ? this.getName() : "Dinnerbone", true);
        } else {
            this.scoreboardName = null;
        }
        return this;
    }

    public PlayerDisguise setDeadmau5Ears(boolean deadmau5Ears) {
        if (deadmau5Ears == this.isDeadmau5Ears()) {
            return this;
        }
        this.deadmau5Ears = deadmau5Ears;
        if (this.isDisguiseInUse()) {
            this.resendDisguise(this.getInternals().getNameDisplayType().isFakeEntity() ? this.getName() : "deadmau5", true);
        } else {
            this.scoreboardName = null;
        }
        return this;
    }

    @Override
    public PlayerDisguise clone() {
        PlayerDisguise disguise = new PlayerDisguise();
        if (this.getWatcher() != null) {
            disguise.setWatcher(this.getWatcher().clone(disguise));
        }
        if (this.skinResolver.isSkinFullyResolved()) {
            disguise.skinResolver.copyResolver(this.skinResolver);
        } else {
            disguise.setSkin(this.getSkin());
        }
        disguise.setName(this.getName());
        disguise.nameVisible = this.isNameVisible();
        disguise.explicitNameVisible = this.explicitNameVisible;
        disguise.setUpsideDown(this.isUpsideDown());
        disguise.setDeadmau5Ears(this.isDeadmau5Ears());
        this.clone(disguise);
        return disguise;
    }

    public UserProfile getUserProfile() {
        return this.skinResolver.getUserProfile();
    }

    public void setGameProfile(GameProfile userProfile) {
        this.setUserProfile(ReflectionManager.getUserProfile(userProfile));
    }

    @Deprecated
    public void setUserProfile(UserProfile userProfile) {
        this.skinResolver.setSkin(userProfile);
    }

    public String getName() {
        return this.playerName;
    }

    public void setName(String name) {
        int cLimit;
        if (this.getName().equals("<Inherit>") && this.getEntity() != null && ((name = this.getEntity() instanceof Player ? this.getEntity().getName() : this.getEntity().getCustomName()) == null || name.isEmpty())) {
            name = this.getEntity().getType().name();
        }
        if (DisguiseConfig.isCopyPlayerTeamInfo() && this.getInternals().getNameDisplayType().isDisplayNameCopy()) {
            name = DisguiseUtilities.getDisplayName(name);
        }
        if (DisguiseUtilities.isPlaceholderApi() && name != null && name.contains("%")) {
            name = PlaceholderAPI.setPlaceholders((Player)(this.getEntity() instanceof Player ? (Player)this.getEntity() : null), (String)name);
        }
        if ((name = DisguiseUtilities.getHexedColors(name)) == null) {
            name = "";
        }
        if (name.equals(this.playerName)) {
            return;
        }
        switch (this.getInternals().getNameDisplayType()) {
            case TEAMS: {
                cLimit = (NmsVersion.v1_13.isSupported() ? 64 : 16) * 2;
                break;
            }
            case EXTENDED: {
                cLimit = (NmsVersion.v1_13.isSupported() ? 64 : 16) * 2 + 16;
                break;
            }
            case ARMORSTANDS: {
                cLimit = 256;
                break;
            }
            case TEXT_DISPLAY: {
                cLimit = 10000;
                break;
            }
            default: {
                cLimit = 16;
            }
        }
        if (name.length() > cLimit) {
            name = name.substring(0, cLimit);
        }
        if (this.isDisguiseInUse()) {
            if (this.getInternals().getNameDisplayType().isFakeEntity()) {
                this.playerName = name;
                this.setNameVisible(!name.isEmpty(), true);
                this.setMultiName(DisguiseUtilities.splitNewLine(name));
            } else {
                boolean resendDisguise = false;
                if (DisguiseConfig.isScoreboardNames() && !this.isStaticName(name)) {
                    DisguiseUtilities.DScoreTeam team = this.getScoreboardName();
                    String[] split = DisguiseUtilities.getExtendedNameSplit(team.getPlayer(), name);
                    resendDisguise = !split[1].equals(team.getPlayer());
                    this.setScoreboardName(split);
                }
                boolean bl = resendDisguise = !DisguiseConfig.isScoreboardNames() || this.isStaticName(name) || this.isStaticName(this.getName()) || resendDisguise;
                if (resendDisguise) {
                    this.resendDisguise(name, false);
                } else {
                    if (this.getName().isEmpty() && !name.isEmpty() && !this.isNameVisible()) {
                        this.setNameVisible(true, true);
                    } else if (!this.getName().isEmpty() && name.isEmpty() && this.isNameVisible()) {
                        this.setNameVisible(false, true);
                    } else {
                        DisguiseUtilities.updateExtendedName(this);
                    }
                    this.playerName = name;
                }
            }
            if (this.isDisplayedInTab() && this.tablistName == null) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!this.canSee(player)) continue;
                    PacketWrapper<?> addTab = DisguiseUtilities.createTablistPacket(this, WrapperPlayServerPlayerInfo.Action.UPDATE_DISPLAY_NAME);
                    PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, addTab);
                }
            }
        } else {
            if (this.scoreboardName != null) {
                DisguiseUtilities.DScoreTeam team = this.getScoreboardName();
                String[] split = DisguiseUtilities.getExtendedNameSplit(team.getPlayer(), name);
                this.setScoreboardName(split);
            }
            if (this.getInternals().getNameDisplayType().isFakeEntity()) {
                this.setMultiName(DisguiseUtilities.splitNewLine(name));
            }
            this.setNameVisible(!name.isEmpty(), true);
            this.playerName = name;
            this.skinResolver.ensureUniqueProfile();
        }
        DisguiseParser.updateDisguiseName(this);
    }

    public String getTablistName() {
        if (this.tablistName == null) {
            return this.getName();
        }
        return this.tablistName;
    }

    public void setTablistName(String tablistName) {
        this.tablistName = tablistName;
        if (!this.isDisplayedInTab() || !this.isDisguiseInUse()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.canSee(player)) continue;
            PacketWrapper<?> addTab = DisguiseUtilities.createTablistPacket(this, WrapperPlayServerPlayerInfo.Action.UPDATE_DISPLAY_NAME);
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, addTab);
        }
    }

    private void resendDisguise(String name, boolean updateTeams) {
        if (this.removeDisguise()) {
            if (this.getName().isEmpty() && !name.isEmpty()) {
                this.setNameVisible(true, true);
            } else if (!this.getName().isEmpty() && name.isEmpty()) {
                this.setNameVisible(false, true);
            }
            this.playerName = name;
            if (updateTeams) {
                this.scoreboardName = null;
            }
            this.skinResolver.ensureUniqueProfile();
            DisguiseUtilities.resetPluginTimer();
            if (!this.startDisguise()) {
                throw new IllegalStateException("Unable to restart disguise");
            }
        } else {
            throw new IllegalStateException("Unable to restart disguise");
        }
    }

    @Nullable
    public String getSkin() {
        return this.skinResolver.getSkin();
    }

    public PlayerDisguise setSkin(@Nullable String newSkin) {
        this.skinResolver.setSkin(newSkin);
        return this;
    }

    public PlayerDisguise setSkin(UserProfile userProfile) {
        this.skinResolver.setSkin(userProfile);
        return this;
    }

    private void refreshDisguise() {
        if (!DisguiseUtilities.isDisguiseInUse(this)) {
            return;
        }
        if (DisguiseUtilities.isFancyHiddenTabs() || this.isDisplayedInTab()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!this.canSee(player)) continue;
                PacketWrapper<?> addTab = DisguiseUtilities.createTablistAddPackets(this);
                PacketWrapper<?> deleteTab = DisguiseUtilities.createTablistPacket(this, WrapperPlayServerPlayerInfo.Action.REMOVE_PLAYER);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, deleteTab);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, addTab);
            }
        }
        DisguiseUtilities.refreshTrackers(this);
    }

    @Override
    public PlayerWatcher getWatcher() {
        return (PlayerWatcher)super.getWatcher();
    }

    @Override
    public PlayerDisguise setWatcher(FlagWatcher newWatcher) {
        return (PlayerDisguise)super.setWatcher(newWatcher);
    }

    public boolean isDisplayedInTab() {
        return this.getWatcher().isDisplayedInTab();
    }

    public void setDisplayedInTab(boolean showPlayerInTab) {
        this.getWatcher().setDisplayedInTab(showPlayerInTab);
    }

    @Override
    public boolean isPlayerDisguise() {
        return true;
    }

    @Override
    public PlayerDisguise removePlayer(Player player) {
        return (PlayerDisguise)super.removePlayer(player);
    }

    @Override
    public PlayerDisguise removePlayer(String playername) {
        return (PlayerDisguise)super.removePlayer(playername);
    }

    @Override
    public PlayerDisguise setDisguiseTarget(TargetedDisguise.TargetType newTargetType) {
        return (PlayerDisguise)super.setDisguiseTarget(newTargetType);
    }

    @Override
    public PlayerDisguise setEntity(Entity entity) {
        super.setEntity(entity);
        if (this.isDisguiseInUse() || entity == null) {
            return this;
        }
        this.skinResolver.ensureUniqueProfile();
        return this;
    }

    @Override
    public PlayerDisguise setHearSelfDisguise(boolean hearSelfDisguise) {
        return (PlayerDisguise)super.setHearSelfDisguise(hearSelfDisguise);
    }

    @Override
    public PlayerDisguise setHideArmorFromSelf(boolean hideArmor) {
        return (PlayerDisguise)super.setHideArmorFromSelf(hideArmor);
    }

    @Override
    public PlayerDisguise setHideHeldItemFromSelf(boolean hideHeldItem) {
        return (PlayerDisguise)super.setHideHeldItemFromSelf(hideHeldItem);
    }

    @Override
    public PlayerDisguise setKeepDisguiseOnPlayerDeath(boolean keepDisguise) {
        return (PlayerDisguise)super.setKeepDisguiseOnPlayerDeath(keepDisguise);
    }

    @Override
    public PlayerDisguise setModifyBoundingBox(boolean modifyBox) {
        return (PlayerDisguise)super.setModifyBoundingBox(modifyBox);
    }

    @Override
    public PlayerDisguise setReplaceSounds(boolean areSoundsReplaced) {
        return (PlayerDisguise)super.setReplaceSounds(areSoundsReplaced);
    }

    @Override
    public boolean startDisguise() {
        return this.startDisguise(null);
    }

    @Override
    public boolean startDisguise(CommandSender sender) {
        String name;
        if (this.isDisguiseInUse()) {
            return false;
        }
        this.skinResolver.lookupSkinIfNeeded();
        if (this.isDynamicName()) {
            name = this.getEntity() instanceof Player ? DisguiseUtilities.translateAlternateColorCodes(DisguiseUtilities.getDisplayName((CommandSender)this.getEntity())) : this.getEntity().getCustomName();
            if (name == null) {
                name = "";
            }
            if (!this.getName().equals(name)) {
                this.setName(name);
            }
        } else if (this.getName().equals("<Inherit>") && this.getEntity() != null) {
            name = this.getEntity() instanceof Player ? DisguiseUtilities.translateAlternateColorCodes(DisguiseUtilities.getDisplayName((CommandSender)this.getEntity())) : this.getEntity().getCustomName();
            if (name == null || name.isEmpty()) {
                name = this.getEntity().getType().name();
            }
            this.setName(name);
        }
        boolean result = super.startDisguise(sender);
        if (result && this.hasScoreboardName()) {
            DisguiseUtilities.registerExtendedName(this);
        }
        return result;
    }

    @Override
    public PlayerDisguise setVelocitySent(boolean sendVelocity) {
        return (PlayerDisguise)super.setVelocitySent(sendVelocity);
    }

    @Override
    public PlayerDisguise setViewSelfDisguise(boolean viewSelfDisguise) {
        return (PlayerDisguise)super.setViewSelfDisguise(viewSelfDisguise);
    }

    @Override
    public PlayerDisguise silentlyAddPlayer(String playername) {
        return (PlayerDisguise)super.silentlyAddPlayer(playername);
    }

    @Override
    public PlayerDisguise silentlyRemovePlayer(String playername) {
        return (PlayerDisguise)super.silentlyRemovePlayer(playername);
    }

    @Override
    public boolean removeDisguise(CommandSender sender, boolean disguiseBeingReplaced) {
        boolean result = super.removeDisguise(sender, disguiseBeingReplaced);
        if (!result) {
            return result;
        }
        if (this.hasScoreboardName()) {
            if (disguiseBeingReplaced) {
                new BukkitRunnable(){

                    public void run() {
                        DisguiseUtilities.unregisterExtendedName(PlayerDisguise.this);
                    }
                }.runTaskLater((Plugin)LibsDisguises.getInstance(), 5L);
            } else {
                DisguiseUtilities.unregisterExtendedName(this);
            }
        }
        return result;
    }

    @Generated
    public boolean isNameVisible() {
        return this.nameVisible;
    }

    @Generated
    public boolean isDeadmau5Ears() {
        return this.deadmau5Ears;
    }
}

