/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.attribute.Attributes;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseRunnable;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.movements.InteractiveBoundingBox;
import me.libraryaddict.disguise.utilities.movements.MovementTracker;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.scaling.DisguiseScaling;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DisguiseInternals<D extends Disguise>
implements DisguiseScaling.DisguiseScalingInternals {
    private final D disguise;
    private double entityScaleWithLibsDisguises = Double.MIN_VALUE;
    private double entityScaleWithoutLibsDisguises = Double.MIN_VALUE;
    private double entityScaleLastSentViaPackets = Double.MIN_VALUE;
    private double selfDisguiseTallScaleMax = 1.0;
    private final NamespacedKey bossBar = new NamespacedKey("libsdisguises", UUID.randomUUID().toString());
    private final DisguiseScaling scaling;
    private final AtomicBoolean refreshingScaling = new AtomicBoolean(false);
    private transient DisguiseRunnable runnable;
    private final Set<UUID> seesDisguise = new HashSet<UUID>();
    private final List<MovementTracker> trackers = new ArrayList<MovementTracker>();
    private InteractiveBoundingBox interactiveBoundingBox;
    private final DisguiseConfig.PlayerNameType nameDisplayType = DisguiseConfig.getPlayerNameType();

    public DisguiseInternals(D disguise) {
        this.disguise = disguise;
        this.scaling = new DisguiseScaling(this);
    }

    public void setInteractiveBoundingBox(InteractiveBoundingBox boundingBox) {
        if (this.getInteractiveBoundingBox() != null) {
            this.trackers.remove(this.getInteractiveBoundingBox());
            if (((Disguise)this.getDisguise()).isDisguiseInUse()) {
                this.getInteractiveBoundingBox().onDespawn();
            }
        }
        this.interactiveBoundingBox = boundingBox;
        if (boundingBox == null) {
            return;
        }
        boundingBox.setDisguise((Disguise)this.getDisguise());
        this.trackers.add(boundingBox);
        if (!((Disguise)this.getDisguise()).isDisguiseInUse()) {
            return;
        }
        boundingBox.onSpawn();
    }

    public synchronized boolean shouldAvoidSendingPackets(Player player) {
        return !this.seesDisguise.contains(player.getUniqueId());
    }

    public synchronized void addSeen(Player player, boolean isSpawnElseRemove) {
        if (isSpawnElseRemove) {
            this.seesDisguise.add(player.getUniqueId());
        } else {
            this.seesDisguise.remove(player.getUniqueId());
        }
    }

    protected void onDisguiseStart() {
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
        }
        this.seesDisguise.clear();
        this.runnable = new DisguiseRunnable((Disguise)this.getDisguise());
        this.runnable.runTaskTimer((Plugin)LibsDisguises.getInstance(), 1L, 1L);
        for (MovementTracker tracker : this.trackers) {
            for (int entityId : tracker.getOwnedEntityIds()) {
                DisguiseUtilities.getRemappedEntityIds().put(entityId, ((Disguise)this.getDisguise()).getEntity().getEntityId());
            }
        }
    }

    protected void onDisguiseStop() {
        for (MovementTracker tracker : this.trackers) {
            tracker.onDespawn();
            for (int entityId : tracker.getOwnedEntityIds()) {
                DisguiseUtilities.getRemappedEntityIds().remove(entityId);
            }
        }
        this.seesDisguise.clear();
        if (this.runnable == null) {
            return;
        }
        this.runnable.cancel();
        this.runnable = null;
    }

    private void refreshScale() {
        if (this.refreshingScaling.getAndSet(true)) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (!DisguiseInternals.this.disguise.isDisguiseInUse()) {
                    return;
                }
                DisguiseInternals.this.getScaling().adjustScaling();
                DisguiseInternals.this.refreshingScaling.set(false);
            }
        }.runTask((Plugin)LibsDisguises.getInstance());
    }

    protected double getActualEntityScale() {
        return ((Disguise)this.disguise).getEntity() instanceof LivingEntity ? ((LivingEntity)((Disguise)this.disguise).getEntity()).getAttribute(DisguiseUtilities.getScaleAttribute()).getValue() : 1.0;
    }

    protected double getRawEntityScaleWithoutLibsDisguises() {
        return DisguiseUtilities.getEntityScaleWithoutLibsDisguises(((Disguise)this.disguise).getEntity());
    }

    @Override
    public double getPlayerScaleWithoutLibsDisguises() {
        double actualScale = this.getActualEntityScale();
        if (this.entityScaleWithLibsDisguises != actualScale) {
            this.entityScaleWithLibsDisguises = this.entityScaleLastSentViaPackets = actualScale;
            this.entityScaleWithoutLibsDisguises = this.getRawEntityScaleWithoutLibsDisguises();
        }
        return this.entityScaleWithoutLibsDisguises;
    }

    @Override
    public double getPrevSelfDisguiseTallScaleMax() {
        return this.getSelfDisguiseTallScaleMax();
    }

    public double getPacketEntityScale(double scaleInPacket) {
        if (this.entityScaleLastSentViaPackets == scaleInPacket) {
            return this.entityScaleWithoutLibsDisguises;
        }
        this.entityScaleLastSentViaPackets = scaleInPacket;
        if (((Disguise)this.disguise).isMiscDisguise() || !(((Disguise)this.disguise).getEntity() instanceof LivingEntity)) {
            return scaleInPacket;
        }
        this.refreshScale();
        return this.entityScaleWithoutLibsDisguises;
    }

    @Override
    public void sendTinyFigureScale(double tinyFigureScale) {
        WrapperPlayServerUpdateAttributes.Property property = new WrapperPlayServerUpdateAttributes.Property(Attributes.GENERIC_SCALE, tinyFigureScale, new ArrayList());
        WrapperPlayServerUpdateAttributes packet = new WrapperPlayServerUpdateAttributes(DisguiseAPI.getSelfDisguiseId(), Collections.singletonList(property));
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)((Disguise)this.getDisguise()).getEntity(), (PacketWrapper)packet);
    }

    @Override
    public void setPlayerScale(double personalPlayerScaleAttribute) {
        AttributeInstance attribute = ((Player)((Disguise)this.getDisguise()).getEntity()).getAttribute(DisguiseUtilities.getScaleAttribute());
        AttributeModifier modifier = attribute.getModifiers().stream().filter(a -> a.getKey().equals((Object)DisguiseUtilities.getSelfDisguiseScaleNamespace())).findAny().orElse(null);
        if (!this.isScalePlayerToDisguise() || personalPlayerScaleAttribute == 1.0 || ((Disguise)this.getDisguise()).isPlayerDisguise()) {
            if (modifier != null) {
                attribute.removeModifier(modifier);
            }
            return;
        }
        if (!this.isScalePlayerToDisguise()) {
            return;
        }
        personalPlayerScaleAttribute -= 1.0;
        if (modifier != null) {
            if (modifier.getAmount() == personalPlayerScaleAttribute && modifier.getOperation() == AttributeModifier.Operation.MULTIPLY_SCALAR_1) {
                return;
            }
            attribute.removeModifier(modifier);
        }
        AttributeModifier newModifier = DisguiseInternals.getAttributeModifier(personalPlayerScaleAttribute);
        attribute.addModifier(newModifier);
    }

    @Override
    public boolean isScalingRelevant() {
        return ((Disguise)this.getDisguise()).isDisguiseInUse() && ((Disguise)this.getDisguise()).getEntity() instanceof Player && ((TargetedDisguise)this.getDisguise()).canSee((Player)((Disguise)this.getDisguise()).getEntity());
    }

    @Override
    public boolean isTinyFigureScaleable() {
        return ((Disguise)this.getDisguise()).canScaleDisguise() && ((Disguise)this.getDisguise()).isSelfDisguiseVisible() && ((Disguise)this.getDisguise()).isTallSelfDisguisesScaling();
    }

    @Override
    public boolean isScalePlayerToDisguise() {
        return ((Disguise)this.getDisguise()).isScalePlayerToDisguise();
    }

    @Override
    public boolean isTallDisguise() {
        return DisguiseUtilities.isTallDisguise(this.getDisguise());
    }

    private static AttributeModifier getAttributeModifier(double personalPlayerScaleAttribute) {
        if (!NmsVersion.v1_21_R1.isSupported()) {
            return new AttributeModifier(DisguiseUtilities.getSelfDisguiseScaleUUID(), DisguiseUtilities.getSelfDisguiseScaleNamespace().toString(), personalPlayerScaleAttribute, AttributeModifier.Operation.MULTIPLY_SCALAR_1, EquipmentSlotGroup.ANY);
        }
        return new AttributeModifier(DisguiseUtilities.getSelfDisguiseScaleNamespace(), personalPlayerScaleAttribute, AttributeModifier.Operation.MULTIPLY_SCALAR_1, EquipmentSlotGroup.ANY);
    }

    @Override
    public double getUnscaledHeight() {
        return ((Disguise)this.getDisguise()).getHeight();
    }

    @Override
    public double getDisguiseScale() {
        return ((Disguise)this.getDisguise()).getDisguiseScale();
    }

    @Generated
    public DisguiseInternals(D disguise, DisguiseScaling scaling) {
        this.disguise = disguise;
        this.scaling = scaling;
    }

    @Generated
    private D getDisguise() {
        return this.disguise;
    }

    @Override
    @Generated
    public void setSelfDisguiseTallScaleMax(double selfDisguiseTallScaleMax) {
        this.selfDisguiseTallScaleMax = selfDisguiseTallScaleMax;
    }

    @Generated
    public double getSelfDisguiseTallScaleMax() {
        return this.selfDisguiseTallScaleMax;
    }

    @Generated
    public NamespacedKey getBossBar() {
        return this.bossBar;
    }

    @Generated
    public DisguiseScaling getScaling() {
        return this.scaling;
    }

    @Generated
    public DisguiseRunnable getRunnable() {
        return this.runnable;
    }

    @Generated
    public List<MovementTracker> getTrackers() {
        return this.trackers;
    }

    @Generated
    public InteractiveBoundingBox getInteractiveBoundingBox() {
        return this.interactiveBoundingBox;
    }

    @Generated
    public DisguiseConfig.PlayerNameType getNameDisplayType() {
        return this.nameDisplayType;
    }
}

