/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityAnimation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityStatus;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerHurtAnimation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseInternals;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.BoatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SheepWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.events.DisguiseEvent;
import me.libraryaddict.disguise.events.UndisguiseEvent;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.animations.DisguiseAnimation;
import me.libraryaddict.disguise.utilities.movements.DisguisedVoiceChat;
import me.libraryaddict.disguise.utilities.movements.InteractiveBoundingBox;
import me.libraryaddict.disguise.utilities.parser.AutoGeneratedValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.DisguiseSoundCategory;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Disguise {
    private transient boolean disguiseInUse;
    private final DisguiseType disguiseType;
    private transient Entity entity;
    private String disguiseName;
    private boolean customDisguiseName = false;
    private DisguiseConfig.TallSelfDisguise tallSelfDisguise = DisguiseConfig.getTallSelfDisguisesVisibility();
    private boolean replaceSounds = DisguiseConfig.isSoundEnabled();
    private boolean hearSelfDisguise = DisguiseConfig.isSelfDisguisesSoundsReplaced();
    private boolean viewSelfDisguise = DisguiseConfig.isViewDisguises() && DisguiseConfig.isViewSelfDisguisesDefault();
    private boolean playIdleSounds = DisguiseConfig.isPlayIdleSounds();
    private boolean hideArmorFromSelf = DisguiseConfig.isHidingArmorFromSelf();
    private boolean hideHeldItemFromSelf = DisguiseConfig.isHidingHeldItemFromSelf();
    private boolean velocitySent = DisguiseConfig.isVelocitySent();
    private boolean modifyBoundingBox = DisguiseConfig.isModifyBoundingBox();
    private String[] multiName = new String[0];
    private transient int[] armorstandIds = new int[0];
    private boolean dynamicName;
    private String soundGroup;
    @Nullable
    private DisguiseSoundCategory soundCategory;
    private DisguiseConfig.NotifyBar notifyBar = DisguiseConfig.getNotifyBar();
    private BarColor bossBarColor = DisguiseConfig.getBossBarColor();
    private BarStyle bossBarStyle = DisguiseConfig.getBossBarStyle();
    private boolean keepDisguiseOnPlayerDeath = DisguiseConfig.isKeepDisguiseOnPlayerDeath();
    private boolean playerHiddenFromTab = DisguiseConfig.isHideDisguisedPlayers();
    private boolean mobsIgnoreDisguise;
    private FlagWatcher watcher;
    protected long disguiseExpires;
    private final LinkedHashMap<String, Object> customData = new LinkedHashMap();
    private UUID uuid = ReflectionManager.getRandomUUID();
    private boolean scalePlayerToDisguise = DisguiseConfig.isScaleSelfDisguises();
    @ApiStatus.Internal
    private final DisguiseInternals internals;

    public Disguise(DisguiseType disguiseType) {
        this.disguiseType = disguiseType;
        this.disguiseName = disguiseType.toReadable();
        this.internals = new DisguiseInternals<Disguise>(this);
    }

    protected void clone(Disguise disguise) {
        disguise.setDisguiseName(this.getDisguiseName());
        disguise.setCustomDisguiseName(this.isCustomDisguiseName());
        disguise.setTallSelfDisguise(this.getTallSelfDisguise());
        disguise.setReplaceSounds(this.isSoundsReplaced());
        disguise.setViewSelfDisguise(this.isSelfDisguiseVisible());
        disguise.setHearSelfDisguise(this.isSelfDisguiseSoundsReplaced());
        disguise.setPlayIdleSounds(this.isPlayIdleSounds());
        disguise.setHideArmorFromSelf(this.isHidingArmorFromSelf());
        disguise.setHideHeldItemFromSelf(this.isHidingHeldItemFromSelf());
        disguise.setVelocitySent(this.isVelocitySent());
        disguise.setModifyBoundingBox(this.isModifyBoundingBox());
        disguise.multiName = Arrays.copyOf(this.multiName, this.multiName.length);
        disguise.setDynamicName(this.isDynamicName());
        disguise.setSoundGroup(this.getSoundGroup());
        disguise.notifyBar = this.getNotifyBar();
        disguise.bossBarColor = this.getBossBarColor();
        disguise.bossBarStyle = this.getBossBarStyle();
        disguise.setExpires(this.getExpires());
        disguise.setScalePlayerToDisguise(this.isScalePlayerToDisguise());
        disguise.setHidePlayer(this.isHidePlayer());
        disguise.setKeepDisguiseOnPlayerDeath(this.isKeepDisguiseOnPlayerDeath());
        disguise.setMobsIgnoreDisguise(this.isMobsIgnoreDisguise());
        if (this.getWatcher() != null) {
            disguise.setWatcher(this.getWatcher().clone(disguise));
        }
        disguise.createDisguise();
    }

    public HashMap<String, Object> getCustomData() {
        return this.customData;
    }

    public UUID getUUID() {
        if (!(this.isPlayerDisguise() && DisguiseConfig.isUniquePlayerDisguiseUUIDs() || DisguiseConfig.isRandomUUIDS() || this.getEntity() == null)) {
            return this.getEntity().getUniqueId();
        }
        if (this.uuid == null) {
            this.uuid = ReflectionManager.getRandomUUID();
        }
        return this.uuid;
    }

    public int getMultiNameLength() {
        return this.multiName.length;
    }

    @AutoGeneratedValue
    public void setDisguiseName(String name) {
        this.disguiseName = name;
    }

    @NotNull
    public DisguiseSoundCategory getEffectiveSoundCategory() {
        if (this.getSoundCategory() != null) {
            return this.getSoundCategory();
        }
        return SoundGroup.getGroup(this).getCategory();
    }

    private int[] getInternalArmorstandIds() {
        if (this.armorstandIds == null) {
            this.armorstandIds = new int[0];
        }
        return this.armorstandIds;
    }

    public String[] getMultiName() {
        if (this.multiName == null) {
            this.multiName = new String[0];
        }
        return this.multiName;
    }

    public void setMultiName(String ... name) {
        if (name.length == 1 && name[0].isEmpty()) {
            name = new String[]{};
        }
        Player player = this.getEntity() instanceof Player ? (Player)this.getEntity() : null;
        for (int i = 0; i < name.length; ++i) {
            if (DisguiseUtilities.isPlaceholderApi() && name[i] != null && name[i].contains("%")) {
                name[i] = PlaceholderAPI.setPlaceholders((Player)player, (String)name[i]);
            }
            name[i] = DisguiseUtilities.getHexedColors(name[i]);
        }
        Object[] oldName = this.multiName;
        this.multiName = name;
        if (Arrays.equals(oldName, name)) {
            return;
        }
        if (!this.isDisguiseInUse()) {
            return;
        }
        this.sendArmorStands((String[])oldName);
    }

    public abstract double getHeight();

    public double getDisguiseScale() {
        if (!NmsVersion.v1_20_R4.isSupported()) {
            return 1.0;
        }
        if (!(this.getWatcher() instanceof LivingWatcher)) {
            return this.getInternals().getPlayerScaleWithoutLibsDisguises();
        }
        Double watcherScale = ((LivingWatcher)this.getWatcher()).getScale();
        if (watcherScale == null) {
            return this.getInternals().getPlayerScaleWithoutLibsDisguises();
        }
        return DisguiseUtilities.getClampedScale(watcherScale);
    }

    protected void sendArmorStands(String[] oldName) {
        if (!this.isDisguiseInUse()) {
            return;
        }
        this.adjustTallSelfDisguiseScale();
        for (Player player : DisguiseUtilities.getTrackingPlayers(this)) {
            if (!DisguiseUtilities.isFancyHiddenTabs() && this.isPlayerDisguise() && LibsDisguises.getInstance().getSkinHandler().isSleeping(player, (PlayerDisguise)this)) continue;
            List<PacketWrapper<?>> packets = DisguiseUtilities.getNamePackets(this, player, oldName);
            for (PacketWrapper<?> packet : packets) {
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, packet);
            }
        }
    }

    public int[] getArmorstandIds() {
        int desiredlength = this.getMultiNameLength();
        if (this.getInternals().getNameDisplayType().isTextDisplayType() && desiredlength > 0) {
            desiredlength = 1;
        }
        if (desiredlength > this.getInternalArmorstandIds().length) {
            int oldLen = this.armorstandIds.length;
            this.armorstandIds = Arrays.copyOf(this.armorstandIds, desiredlength);
            for (int i = oldLen; i < this.armorstandIds.length; ++i) {
                this.armorstandIds[i] = ReflectionManager.getNewEntityId();
            }
        }
        return this.armorstandIds;
    }

    public void addCustomData(String key, Object data) {
        this.customData.put(key, data);
    }

    public boolean hasCustomData(String key) {
        return this.customData.containsKey(key);
    }

    public Object getCustomData(String key) {
        return this.customData.get(key);
    }

    public abstract Disguise clone();

    protected void createDisguise() {
        if (this.getType().getEntityType() == null) {
            throw new RuntimeException("DisguiseType " + (Object)((Object)this.getType()) + " was used in a futile attempt to construct a disguise, but this Minecraft version does not have that entity");
        }
        boolean isAdult = true;
        if (this instanceof MobDisguise) {
            isAdult = ((MobDisguise)this).isAdult();
        }
        if (this.getWatcher() == null) {
            try {
                this.setWatcher(this.getType().getWatcherClass().getConstructor(Disguise.class).newInstance(this));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.getWatcher().getDisguise() != this) {
            this.getWatcher().setDisguise((TargetedDisguise)this);
        }
        if (!isAdult) {
            if (this.getWatcher() instanceof AgeableWatcher) {
                ((AgeableWatcher)this.getWatcher()).setBaby(true);
            } else if (this.getWatcher() instanceof ZombieWatcher) {
                ((ZombieWatcher)this.getWatcher()).setBaby(true);
            }
        }
    }

    public boolean isDisguiseExpired() {
        return DisguiseConfig.isDynamicExpiry() ? this.disguiseExpires == 1L : this.disguiseExpires > 0L && this.disguiseExpires < System.currentTimeMillis();
    }

    public long getExpires() {
        return this.disguiseExpires;
    }

    public void setExpires(long timeToExpire) {
        this.disguiseExpires = timeToExpire;
        if (this.isDisguiseExpired()) {
            this.removeDisguise();
        }
    }

    private void removeBossBar() {
        KeyedBossBar bossBar = Bukkit.getBossBar((NamespacedKey)this.getInternals().getBossBar());
        if (bossBar == null) {
            return;
        }
        bossBar.removeAll();
        Bukkit.removeBossBar((NamespacedKey)this.getInternals().getBossBar());
    }

    public void setNotifyBar(DisguiseConfig.NotifyBar bar) {
        if (bar == null) {
            bar = DisguiseConfig.getNotifyBar();
        }
        if (this.getNotifyBar() == bar) {
            return;
        }
        if (this.getNotifyBar() == DisguiseConfig.NotifyBar.BOSS_BAR) {
            this.removeBossBar();
        }
        this.notifyBar = bar;
        this.makeBossBar();
    }

    public void setBossBarColor(BarColor color) {
        if (color == null) {
            color = DisguiseConfig.getBossBarColor();
        }
        if (this.getBossBarColor() == color) {
            return;
        }
        this.bossBarColor = color;
        this.makeBossBar();
    }

    public void setBossBarStyle(BarStyle style) {
        if (style == null) {
            style = DisguiseConfig.getBossBarStyle();
        }
        if (this.getBossBarStyle() == style) {
            return;
        }
        this.bossBarStyle = style;
        this.makeBossBar();
    }

    public void setBossBar(BarColor color, BarStyle style) {
        if (color == null) {
            color = DisguiseConfig.getBossBarColor();
        }
        if (style == null) {
            style = DisguiseConfig.getBossBarStyle();
        }
        this.bossBarColor = color;
        this.bossBarStyle = style;
        this.setNotifyBar(DisguiseConfig.NotifyBar.BOSS_BAR);
    }

    private void makeBossBar() {
        if (this.getNotifyBar() != DisguiseConfig.NotifyBar.BOSS_BAR || !NmsVersion.v1_13.isSupported() || !(this.getEntity() instanceof Player)) {
            return;
        }
        if (this.getEntity().hasPermission("libsdisguises.noactionbar") || DisguiseAPI.getDisguise(this.getEntity()) != this) {
            return;
        }
        if (!DisguiseAPI.isNotifyBarShown(this.getEntity())) {
            return;
        }
        this.removeBossBar();
        KeyedBossBar bar = Bukkit.createBossBar((NamespacedKey)this.getInternals().getBossBar(), (String)BaseComponent.toLegacyText((BaseComponent[])LibsMsg.ACTION_BAR_MESSAGE.getBase(this.getDisguiseName())), (BarColor)this.getBossBarColor(), (BarStyle)this.getBossBarStyle(), (BarFlag[])new BarFlag[0]);
        bar.setProgress(1.0);
        bar.addPlayer((Player)this.getEntity());
    }

    public boolean isUpsideDown() {
        return this.getWatcher() != null && this.getWatcher().isUpsideDown();
    }

    public Disguise setUpsideDown(boolean upsideDown) {
        this.getWatcher().setUpsideDown(upsideDown);
        return this;
    }

    protected void doPeriodicTick() {
        if (this.getNotifyBar() == DisguiseConfig.NotifyBar.ACTION_BAR && this.getEntity() instanceof Player && DisguiseAPI.isNotifyBarShown(this.getEntity()) && !this.getEntity().hasPermission("libsdisguises.noactionbar") && DisguiseAPI.getDisguise(this.getEntity()) == this) {
            ((Player)this.getEntity()).spigot().sendMessage(ChatMessageType.ACTION_BAR, LibsMsg.ACTION_BAR_MESSAGE.getBase(this.getDisguiseName()));
        }
        if (this.isDynamicName()) {
            String name = this.getEntity() instanceof Player ? DisguiseUtilities.translateAlternateColorCodes(DisguiseUtilities.getDisplayName((CommandSender)this.getEntity())) : this.getEntity().getCustomName();
            if (name == null) {
                name = "";
            }
            if (this.isPlayerDisguise()) {
                if (!((PlayerDisguise)this).getName().equals(name)) {
                    ((PlayerDisguise)this).setName(name);
                }
            } else {
                this.getWatcher().setCustomName(name);
            }
        }
    }

    public Disguise setEntity(Entity entity) {
        if (this.getEntity() != null) {
            if (LibsDisguises.getInstance() == null) {
                throw new IllegalArgumentException("Lib's Disguises did not start up properly, was the plugin shaded into a third party plugin? It shouldn't be!");
            }
            if (this.getEntity() == entity) {
                return this;
            }
            throw new IllegalArgumentException("This disguise is already in use! Try .clone()");
        }
        if (this.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled() && entity instanceof LivingEntity) {
            throw new IllegalArgumentException("Cannot disguise a living entity with a misc disguise. Reenable MiscDisguisesForLiving in the config to do this");
        }
        this.entity = entity;
        if (entity != null) {
            this.setupWatcher();
        }
        if (this.getEntity() instanceof Player && this.isSelfDisguiseVisible() && !this.isTallDisguisesVisible() && this.isTallDisguise()) {
            if (this.isTallSelfDisguisesScaling() && NmsVersion.v1_20_R4.isSupported() && this.canScaleDisguise()) {
                this.adjustTallSelfDisguiseScale();
            } else {
                this.setSelfDisguiseVisible(false);
            }
        }
        return this;
    }

    private boolean isTallDisguise() {
        return DisguiseUtilities.isTallDisguise(this);
    }

    public boolean canScaleDisguise() {
        return NmsVersion.v1_20_R4.isSupported() && !this.isMiscDisguise() && this.getType() != DisguiseType.ENDER_DRAGON;
    }

    public void setScalePlayerToDisguise(boolean scalePlayerToDisguise) {
        this.scalePlayerToDisguise = scalePlayerToDisguise;
        this.adjustTallSelfDisguiseScale();
    }

    protected void adjustTallSelfDisguiseScale() {
        if (!NmsVersion.v1_20_R4.isSupported() || !this.isDisguiseInUse() || this.getEntity() == null) {
            return;
        }
        this.getInternals().getScaling().adjustScaling();
    }

    public DisguiseType getType() {
        return this.disguiseType;
    }

    @Deprecated
    public Disguise setWatcher(FlagWatcher newWatcher) {
        if (!this.getType().getWatcherClass().isInstance(newWatcher)) {
            throw new IllegalArgumentException((newWatcher == null ? "null" : newWatcher.getClass().getSimpleName()) + " is not an instance of " + this.getType().getWatcherClass().getSimpleName() + " for DisguiseType " + this.getType().name());
        }
        this.watcher = newWatcher;
        if (this.getEntity() != null) {
            this.setupWatcher();
        }
        return this;
    }

    public boolean isHidePlayer() {
        return this.playerHiddenFromTab;
    }

    public void setHidePlayer(boolean hidePlayerInTab) {
        if (this.isDisguiseInUse()) {
            throw new IllegalStateException("Cannot set this while disguise is in use!");
        }
        this.playerHiddenFromTab = hidePlayerInTab;
    }

    @Deprecated
    public boolean isHidingArmorFromSelf() {
        return this.hideArmorFromSelf;
    }

    @Deprecated
    public boolean isHidingHeldItemFromSelf() {
        return this.hideHeldItemFromSelf;
    }

    public Disguise setHideArmorFromSelf(boolean hideArmor) {
        this.hideArmorFromSelf = hideArmor;
        if (this.getEntity() instanceof Player) {
            ((Player)this.getEntity()).updateInventory();
        }
        return this;
    }

    public Disguise setHideHeldItemFromSelf(boolean hideHeldItem) {
        this.hideHeldItemFromSelf = hideHeldItem;
        if (this.getEntity() instanceof Player) {
            ((Player)this.getEntity()).updateInventory();
        }
        return this;
    }

    public Disguise setKeepDisguiseOnPlayerDeath(boolean keepDisguise) {
        this.keepDisguiseOnPlayerDeath = keepDisguise;
        return this;
    }

    public boolean isMiscDisguise() {
        return false;
    }

    public boolean isMobDisguise() {
        return false;
    }

    public Disguise setModifyBoundingBox(boolean modifyBox) {
        if (this.isModifyBoundingBox() != modifyBox) {
            this.modifyBoundingBox = modifyBox;
            if (DisguiseUtilities.isDisguiseInUse(this)) {
                DisguiseUtilities.doBoundingBox((TargetedDisguise)this);
            }
        }
        return this;
    }

    public boolean isPlayerDisguise() {
        return false;
    }

    public boolean isCustomDisguise() {
        return false;
    }

    @ApiStatus.Internal
    public boolean isRemoveDisguiseOnDeath() {
        if (this.getEntity() == null) {
            return true;
        }
        if (this.getEntity() instanceof Player) {
            return !this.isKeepDisguiseOnPlayerDeath();
        }
        return this.getEntity().isDead() || !this.getEntity().isValid();
    }

    @Deprecated
    public boolean isSelfDisguiseSoundsReplaced() {
        return this.hearSelfDisguise;
    }

    public boolean isSelfDisguiseVisible() {
        return DisguiseConfig.isViewDisguises() && this.viewSelfDisguise;
    }

    public void setSelfDisguiseVisible(boolean selfDisguiseVisible) {
        this.setViewSelfDisguise(selfDisguiseVisible);
    }

    @Deprecated
    public boolean isSoundsReplaced() {
        return this.replaceSounds;
    }

    public Disguise setVelocitySent(boolean sendVelocity) {
        this.velocitySent = sendVelocity;
        return this;
    }

    public boolean removeDisguise() {
        return this.removeDisguise(false);
    }

    public boolean removeDisguise(CommandSender sender) {
        return this.removeDisguise(sender, false);
    }

    public boolean removeDisguise(boolean disguiseBeingReplaced) {
        return this.removeDisguise(null, disguiseBeingReplaced);
    }

    public boolean removeDisguise(CommandSender sender, boolean disguiseBeingReplaced) {
        PlayerDisguise disguise;
        if (!this.isDisguiseInUse()) {
            return false;
        }
        Supplier<Boolean> eventCancellable = () -> this.getEntity() != null && Bukkit.getWorlds().contains(this.getEntity().getWorld()) && (!(this.getEntity() instanceof Player) || ((Player)this.getEntity()).isOnline());
        UndisguiseEvent event = new UndisguiseEvent(sender, this.entity, this, disguiseBeingReplaced, eventCancellable);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() && event.isCancellable()) {
            return false;
        }
        this.getInternals().onDisguiseStop();
        this.disguiseInUse = false;
        if (this.getEntity() == null) {
            Map<Integer, Set<TargetedDisguise>> future = DisguiseUtilities.getFutureDisguises();
            Iterator<Set<TargetedDisguise>> iterator = DisguiseUtilities.getFutureDisguises().values().iterator();
            while (iterator.hasNext()) {
                Set<TargetedDisguise> disguises = iterator.next();
                if (!disguises.remove(this)) continue;
                if (!disguises.isEmpty()) break;
                iterator.remove();
                break;
            }
            return true;
        }
        if (NmsVersion.v1_20_R4.isSupported()) {
            DisguiseUtilities.removeSelfDisguiseScale(this.getEntity());
        }
        if (this instanceof PlayerDisguise && ((disguise = (PlayerDisguise)this).isDisplayedInTab() || DisguiseUtilities.isFancyHiddenTabs())) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!((TargetedDisguise)this).canSee(player)) continue;
                PacketWrapper<?> deleteTab = DisguiseUtilities.createTablistPacket(disguise, WrapperPlayServerPlayerInfo.Action.REMOVE_PLAYER);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, deleteTab);
            }
        }
        if (this.getInternalArmorstandIds().length > 0) {
            for (Player player : this.getEntity().getWorld().getPlayers()) {
                WrapperPlayServerDestroyEntities packet = DisguiseUtilities.getDestroyPacket(this.getInternalArmorstandIds());
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)packet);
            }
        }
        if (!this.isPlayerDisguise()) {
            DisguiseUtilities.setGlowColor(this, null);
        }
        if (LibsPremium.getPluginInformation().isPremium() && LibsDisguises.getInstance().getBuildNumber() < 1360 && System.currentTimeMillis() % 4L == 1L) {
            this.getWatcher().setEntityFlag(3, true);
        }
        if (DisguiseUtilities.removeDisguise((TargetedDisguise)this) && !disguiseBeingReplaced) {
            if (this.getEntity() instanceof Player) {
                DisguiseUtilities.removeSelfDisguise(this);
            }
            if (this.getEntity().isValid()) {
                DisguiseUtilities.refreshTrackers((TargetedDisguise)this);
            } else {
                DisguiseUtilities.destroyEntity((TargetedDisguise)this);
            }
        }
        if (this.isHidePlayer() && this.getEntity() instanceof Player && ((Player)this.getEntity()).isOnline()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!((TargetedDisguise)this).canSee(player)) continue;
                PacketWrapper<?> addTab = DisguiseUtilities.updateTablistVisibility((Player)this.getEntity(), true);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, addTab);
            }
        }
        for (String meta : new String[]{"LastDisguise", "LD-LastAttacked", "forge_mods", "LibsRabbitHop", "ld_loggedin"}) {
            this.getEntity().removeMetadata(meta, (Plugin)LibsDisguises.getInstance());
        }
        if (DisguiseConfig.getPvPTimer() > 0.0 && this.getEntity() instanceof Player) {
            this.getEntity().setMetadata("LastDisguise", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), (Object)System.currentTimeMillis()));
        }
        if (NmsVersion.v1_13.isSupported()) {
            this.removeBossBar();
        }
        if (this.getEntity().isValid()) {
            DisguiseUtilities.saveDisguises(this.getEntity());
        }
        return true;
    }

    public Disguise setHearSelfDisguise(boolean hearSelfDisguise) {
        this.hearSelfDisguise = hearSelfDisguise;
        return this;
    }

    public Disguise setReplaceSounds(boolean areSoundsReplaced) {
        this.replaceSounds = areSoundsReplaced;
        return this;
    }

    private void setupWatcher() {
        if (this.getWatcher() == null) {
            this.createDisguise();
        }
        ArrayList<MetaIndex> disguiseFlags = MetaIndex.getMetaIndexes(this.getType().getWatcherClass());
        ArrayList<MetaIndex> entityFlags = MetaIndex.getMetaIndexes(DisguiseType.getType(this.getEntity().getType()).getWatcherClass());
        for (MetaIndex flag : entityFlags) {
            if (disguiseFlags.contains(flag)) continue;
            MetaIndex backup = null;
            for (MetaIndex flagType : disguiseFlags) {
                if (flagType.getIndex() != flag.getIndex()) continue;
                backup = flagType;
            }
            this.getWatcher().setBackupValue(flag, backup == null ? null : backup.getDefault());
        }
        if (!(!(this.getEntity() instanceof Player) || this.getWatcher().hasCustomName() || this.isUpsideDown() || this.getWatcher() instanceof SheepWatcher && ((SheepWatcher)this.getWatcher()).isRainbowWool())) {
            this.getWatcher().setInteralCustomName("");
            this.getWatcher().setInternalCustomNameVisible(false);
        }
        if ((this.getEntity() instanceof Boat || this.getEntity() instanceof AbstractHorse || this.getEntity() instanceof Item || this.getEntity() instanceof FallingBlock) && (this.getWatcher() instanceof BoatWatcher || this.getWatcher() instanceof AbstractHorseWatcher || this.getEntity() instanceof Item || this.getEntity() instanceof FallingBlock)) {
            this.getWatcher().setNoGravity(!this.getEntity().hasGravity());
        } else {
            this.getWatcher().setNoGravity(true);
        }
    }

    @Deprecated
    public Disguise setViewSelfDisguise(boolean viewSelfDisguise) {
        if (viewSelfDisguise && !this.isTallDisguisesVisible() && this.isTallDisguise()) {
            if (this.getTallSelfDisguise().isScaled() && this.canScaleDisguise() && !this.isPlayerDisguise()) {
                this.adjustTallSelfDisguiseScale();
            } else {
                viewSelfDisguise = false;
            }
        }
        if (this.isSelfDisguiseVisible() == viewSelfDisguise || !DisguiseConfig.isViewDisguises()) {
            return this;
        }
        this.viewSelfDisguise = viewSelfDisguise;
        if (this.getEntity() instanceof Player && DisguiseAPI.getDisguise((Player)this.getEntity(), this.getEntity()) == this) {
            if (this.isSelfDisguiseVisible()) {
                DisguiseUtilities.setupFakeDisguise(this);
            } else {
                DisguiseUtilities.removeSelfDisguise(this);
            }
        }
        return this;
    }

    public boolean startDisguise() {
        return this.startDisguise(null);
    }

    public boolean startDisguise(CommandSender commandSender) {
        int impactedPlayers;
        PlayerDisguise disguise;
        if (this.isDisguiseInUse() || this.isDisguiseExpired()) {
            return false;
        }
        if (this.getEntity() == null) {
            throw new IllegalStateException("No entity is assigned to this disguise!");
        }
        if (this.multiName == null) {
            this.multiName = new String[0];
        }
        if (LibsPremium.getUserID().equals("12345") || LibsPremium.getPaidInformation() != null && LibsPremium.getPaidInformation().getUserID().equals("0") || !LibsMsg.OWNED_BY.getRaw().contains("'")) {
            ((TargetedDisguise)this).setDisguiseTarget(TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS);
            if (this.getEntity() instanceof Player) {
                ((TargetedDisguise)this).addPlayer((Player)this.getEntity());
            }
            for (Entity ent : this.getEntity().getNearbyEntities(4.0, 4.0, 4.0)) {
                if (!(ent instanceof Player)) continue;
                ((TargetedDisguise)this).addPlayer((Player)ent);
            }
        }
        DisguiseUtilities.setPluginsUsed();
        if (LibsPremium.isPremium().booleanValue() && this.isSelfDisguiseVisible() && this.getEntity() instanceof Player && !this.getEntity().hasPermission("libsdisguises.selfdisguises")) {
            this.setSelfDisguiseVisible(false);
        }
        DisguiseEvent event = new DisguiseEvent(commandSender, this.entity, this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (!(!this.isDynamicName() || this.isPlayerDisguise() && ((PlayerDisguise)this).getName().equals("<Inherit>"))) {
            String name = this.getEntity() instanceof Player ? DisguiseUtilities.translateAlternateColorCodes(DisguiseUtilities.getDisplayName((CommandSender)this.getEntity())) : this.getEntity().getCustomName();
            if (name == null) {
                name = "";
            }
            this.getWatcher().setCustomName(name);
        }
        if (DisguiseUtilities.isVoiceChatPlugin() && DisguiseConfig.isVoiceChatCompatibility() && this.getEntity() instanceof Player && this.getInternals().getTrackers().stream().noneMatch(t -> t instanceof DisguisedVoiceChat)) {
            this.getInternals().getTrackers().add(new DisguisedVoiceChat(this.getEntity().getUniqueId()));
        }
        this.getWatcher().onPreDisguiseStart();
        this.disguiseInUse = true;
        if (!DisguiseUtilities.isInvalidFile()) {
            this.getInternals().onDisguiseStart();
        }
        if (this instanceof PlayerDisguise && (disguise = (PlayerDisguise)this).isDisplayedInTab()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!((TargetedDisguise)this).canSee(player)) continue;
                PacketWrapper<?> addTab = DisguiseUtilities.createTablistAddPackets(disguise);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, addTab);
            }
        }
        DisguiseUtilities.addDisguise(this.entity.getEntityId(), (TargetedDisguise)this);
        if (!this.isPlayerDisguise() && (this.getWatcher().getGlowColor() != ChatColor.WHITE || DisguiseConfig.isModifyCollisions())) {
            DisguiseUtilities.setGlowColor(this, this.getWatcher().getGlowColor());
        }
        if (this.isSelfDisguiseVisible() && this.getEntity() instanceof Player) {
            DisguiseUtilities.removeSelfDisguise(this);
        }
        if (LibsPremium.getPluginInformation().isPremium() && LibsDisguises.getInstance().getBuildNumber() < 1488 && System.currentTimeMillis() % 10L == 1L) {
            this.getWatcher().setEntityFlag(3, true);
        }
        if ((impactedPlayers = DisguiseUtilities.refreshTrackersWithCount((TargetedDisguise)this)) > 0) {
            DisguiseUtilities.warnFutureDisguises(this.getEntity());
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> DisguiseUtilities.setupFakeDisguise(this), 2L);
        if (this.isHidePlayer() && this.getEntity() instanceof Player) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!((TargetedDisguise)this).canSee(player)) continue;
                PacketWrapper<?> removeTab = DisguiseUtilities.updateTablistVisibility((Player)this.getEntity(), false);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, removeTab);
            }
        }
        if (!this.entity.isOp() && new Random().nextBoolean() && (!LibsMsg.OWNED_BY.getRaw().contains("'") || "%%__USER__%%".equals("12345") || "%%__USER__%%".equals("1592"))) {
            this.setExpires(DisguiseConfig.isDynamicExpiry() ? 4800L : System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(330L));
        }
        this.makeBossBar();
        DisguiseUtilities.saveDisguises(this.getEntity());
        this.adjustTallSelfDisguiseScale();
        return true;
    }

    public boolean stopDisguise() {
        return this.removeDisguise();
    }

    public void setTallSelfDisguise(DisguiseConfig.TallSelfDisguise tallSelfDisguise) {
        if (tallSelfDisguise == null) {
            tallSelfDisguise = DisguiseConfig.getTallSelfDisguisesVisibility();
        }
        if (this.getTallSelfDisguise() == tallSelfDisguise) {
            return;
        }
        this.tallSelfDisguise = tallSelfDisguise;
        this.adjustTallSelfDisguiseScale();
    }

    @Deprecated
    public void setTallSelfDisguisesScaling(boolean tallSelfDisguisesScaling) {
        if (!NmsVersion.v1_20_R4.isSupported()) {
            return;
        }
        if (!tallSelfDisguisesScaling) {
            this.setTallSelfDisguise(DisguiseConfig.TallSelfDisguise.VISIBLE);
        } else {
            this.setTallSelfDisguise(DisguiseConfig.TallSelfDisguise.SCALED);
        }
    }

    @Deprecated
    public boolean isTallSelfDisguisesScaling() {
        return this.getTallSelfDisguise().isScaled();
    }

    @Deprecated
    public void setTallDisguisesVisible(boolean tallDisguisesVisible) {
        if (tallDisguisesVisible) {
            this.setTallSelfDisguise(DisguiseConfig.TallSelfDisguise.VISIBLE);
        } else {
            this.setTallSelfDisguise(DisguiseConfig.TallSelfDisguise.HIDDEN);
        }
    }

    @Deprecated
    public boolean isTallDisguisesVisible() {
        return this.getTallSelfDisguise().isAlwaysVisible();
    }

    public void playAnimation(Player observer, DisguiseAnimation animation) {
        Object packet = animation == DisguiseAnimation.HURT ? new WrapperPlayServerHurtAnimation(observer == this.getEntity() ? DisguiseAPI.getSelfDisguiseId() : this.getEntity().getEntityId(), this.getEntity().getLocation().getYaw()) : (animation.getAnimationType() != null ? new WrapperPlayServerEntityAnimation(observer == this.getEntity() ? DisguiseAPI.getSelfDisguiseId() : this.getEntity().getEntityId(), animation.getAnimationType()) : new WrapperPlayServerEntityStatus(observer == this.getEntity() ? DisguiseAPI.getSelfDisguiseId() : this.getEntity().getEntityId(), animation.getStatus()));
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)observer, (PacketWrapper)packet);
    }

    public int playAnimation(DisguiseAnimation animation) {
        if (!this.isDisguiseInUse()) {
            throw new IllegalStateException("Disguise is not active!");
        }
        int entityId = this.getEntity().getEntityId();
        int count = 0;
        for (Player player : DisguiseUtilities.getTrackingPlayers(this)) {
            ++count;
            this.playAnimation(player, animation);
        }
        return count;
    }

    public void setBoundingBox(InteractiveBoundingBox boundingBox) {
        this.getInternals().setInteractiveBoundingBox(boundingBox);
    }

    public InteractiveBoundingBox getBoundingBox() {
        return this.getInternals().getInteractiveBoundingBox();
    }

    @Generated
    public boolean isDisguiseInUse() {
        return this.disguiseInUse;
    }

    @Generated
    public Entity getEntity() {
        return this.entity;
    }

    @Generated
    public String getDisguiseName() {
        return this.disguiseName;
    }

    @Generated
    public boolean isCustomDisguiseName() {
        return this.customDisguiseName;
    }

    @Generated
    public void setCustomDisguiseName(boolean customDisguiseName) {
        this.customDisguiseName = customDisguiseName;
    }

    @Generated
    public DisguiseConfig.TallSelfDisguise getTallSelfDisguise() {
        return this.tallSelfDisguise;
    }

    @Generated
    public boolean isReplaceSounds() {
        return this.replaceSounds;
    }

    @Generated
    public boolean isHearSelfDisguise() {
        return this.hearSelfDisguise;
    }

    @Generated
    public boolean isPlayIdleSounds() {
        return this.playIdleSounds;
    }

    @Generated
    public void setPlayIdleSounds(boolean playIdleSounds) {
        this.playIdleSounds = playIdleSounds;
    }

    @Generated
    public boolean isHideArmorFromSelf() {
        return this.hideArmorFromSelf;
    }

    @Generated
    public boolean isHideHeldItemFromSelf() {
        return this.hideHeldItemFromSelf;
    }

    @Generated
    public boolean isVelocitySent() {
        return this.velocitySent;
    }

    @Generated
    public boolean isModifyBoundingBox() {
        return this.modifyBoundingBox;
    }

    @Generated
    public boolean isDynamicName() {
        return this.dynamicName;
    }

    @Generated
    public void setDynamicName(boolean dynamicName) {
        this.dynamicName = dynamicName;
    }

    @Generated
    public String getSoundGroup() {
        return this.soundGroup;
    }

    @Generated
    public void setSoundGroup(String soundGroup) {
        this.soundGroup = soundGroup;
    }

    @Nullable
    @Generated
    public DisguiseSoundCategory getSoundCategory() {
        return this.soundCategory;
    }

    @Generated
    public void setSoundCategory(@Nullable DisguiseSoundCategory soundCategory) {
        this.soundCategory = soundCategory;
    }

    @Generated
    public DisguiseConfig.NotifyBar getNotifyBar() {
        return this.notifyBar;
    }

    @Generated
    public BarColor getBossBarColor() {
        return this.bossBarColor;
    }

    @Generated
    public BarStyle getBossBarStyle() {
        return this.bossBarStyle;
    }

    @Generated
    public boolean isKeepDisguiseOnPlayerDeath() {
        return this.keepDisguiseOnPlayerDeath;
    }

    @Generated
    public void setMobsIgnoreDisguise(boolean mobsIgnoreDisguise) {
        this.mobsIgnoreDisguise = mobsIgnoreDisguise;
    }

    @Generated
    public boolean isMobsIgnoreDisguise() {
        return this.mobsIgnoreDisguise;
    }

    @Generated
    public FlagWatcher getWatcher() {
        return this.watcher;
    }

    @Generated
    public boolean isScalePlayerToDisguise() {
        return this.scalePlayerToDisguise;
    }

    @Generated
    public DisguiseInternals getInternals() {
        return this.internals;
    }
}

