/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.utils;

import com.github.retrooper.packetevents.protocol.player.UserProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.SkinUtils;
import me.libraryaddict.disguise.utilities.mineskin.models.structures.SkinVariant;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class GrabSkinCommand
implements CommandExecutor {
    public boolean onCommand(final CommandSender sender, Command command, String s, String[] strings) {
        String name;
        if (!(!(sender instanceof Player) || sender.isOp() || LibsPremium.isPremium().booleanValue() && LibsPremium.getPaidInformation() != LibsPremium.getPluginInformation())) {
            sender.sendMessage(ChatColor.RED + "This is the free version of Lib's Disguises, player commands are limited to console and Operators only! Purchase the plugin for non-admin usage!");
            return true;
        }
        if (!sender.hasPermission("libsdisguises.grabskin")) {
            LibsMsg.NO_PERM.send(sender, new Object[0]);
            return true;
        }
        if (strings.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        String[] args = DisguiseUtilities.split(StringUtils.join((Object[])strings, (String)" "));
        String tempName = args.length > 1 ? args[0] : null;
        String skin = args.length > 1 ? args[1] : args[0];
        String usable = SkinUtils.getUsableStatus();
        if (usable != null) {
            DisguiseUtilities.sendMessage(sender, usable);
            return true;
        }
        if (tempName == null && skin.matches("(.*/)?[a-zA-Z0-9_-]{3,20}(\\.png)?")) {
            int start = skin.lastIndexOf("/") + 1;
            int end = skin.length();
            if (skin.lastIndexOf(".") > start) {
                end = skin.lastIndexOf(".");
            }
            if (DisguiseUtilities.hasUserProfile(tempName = skin.substring(start, end))) {
                tempName = null;
            }
        }
        for (SkinVariant variant : SkinVariant.values()) {
            if (tempName == null || !tempName.toLowerCase(Locale.ENGLISH).endsWith(":" + variant.name().toLowerCase(Locale.ENGLISH))) continue;
            tempName = tempName.substring(0, tempName.length() - (variant.name().length() + 1));
            break;
        }
        if ((name = tempName) != null && !name.replaceAll("[_a-zA-Z \\d-@#]", "").isEmpty()) {
            LibsMsg.SKIN_API_INVALID_NAME.send(sender, new Object[0]);
            return true;
        }
        SkinUtils.SkinCallback callback = new SkinUtils.SkinCallback(){
            private final BukkitTask runnable = new BukkitRunnable(){

                public void run() {
                    LibsMsg.PLEASE_WAIT.send(sender, new Object[0]);
                }
            }.runTaskTimer((Plugin)LibsDisguises.getInstance(), 100L, 100L);

            @Override
            public void onError(LibsMsg msg, Object ... args) {
                msg.send(sender, args);
                this.runnable.cancel();
            }

            @Override
            public void onInfo(LibsMsg msg, Object ... args) {
                msg.send(sender, args);
            }

            @Override
            public void onSuccess(UserProfile profile) {
                this.runnable.cancel();
                DisguiseUtilities.doSkinUUIDWarning(sender);
                String nName = name;
                if (StringUtils.isEmpty((String)nName)) {
                    int i = 1;
                    while (DisguiseUtilities.hasUserProfile("skin" + i)) {
                        ++i;
                    }
                    nName = "skin" + i;
                }
                if (profile.getName() == null || !profile.getName().equals(nName)) {
                    profile = ReflectionManager.getUserProfileWithThisSkin(profile.getUUID(), profile.getName(), profile);
                }
                DisguiseAPI.addGameProfile(nName, profile);
                LibsMsg.GRABBED_SKIN.send(sender, nName);
                String string = DisguiseUtilities.getGson().toJson((Object)profile);
                GrabSkinCommand.this.sendMessage(sender, LibsMsg.CLICK_TO_COPY, LibsMsg.CLICK_TO_COPY, string, false);
                DisguiseUtilities.setGrabSkinCommandUsed();
            }
        };
        SkinUtils.grabSkin(sender, skin, callback);
        return true;
    }

    private void sendHelp(CommandSender sender) {
        LibsMsg.GRAB_DISG_HELP_1.send(sender, new Object[0]);
        LibsMsg.GRAB_DISG_HELP_2.send(sender, new Object[0]);
        LibsMsg.GRAB_DISG_HELP_3.send(sender, new Object[0]);
        LibsMsg.GRAB_DISG_HELP_4.send(sender, new Object[0]);
        LibsMsg.GRAB_DISG_HELP_5.send(sender, new Object[0]);
        LibsMsg.GRAB_DISG_HELP_6.send(sender, new Object[0]);
    }

    private Component createComponent(String text, int section, int max) {
        Component component = LibsMsg.CLICK_COPY.getAdv(section);
        component = NmsVersion.v1_15.isSupported() ? component.clickEvent(ClickEvent.copyToClipboard((String)text)) : component.clickEvent(ClickEvent.suggestCommand((String)text));
        LibsMsg hover = NmsVersion.v1_15.isSupported() ? LibsMsg.CLICK_TO_COPY_HOVER_CLIPBOARD : LibsMsg.CLICK_TO_COPY_HOVER;
        Component hoverText = hover.getAdv(section, max, DisguiseUtilities.getMiniMessage().escapeTags(text));
        component = component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverText));
        return component;
    }

    private void sendMessage(CommandSender sender, LibsMsg msg, LibsMsg oldVer, String string, boolean forceAbbrev) {
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)Component.text().append(msg.getAdv(new Object[0]))).append((Component)Component.text((String)" "));
        if (string.length() > 256 || forceAbbrev) {
            int i;
            int i2;
            String[] split = DisguiseUtilities.split(string);
            for (i2 = 0; i2 < split.length; ++i2) {
                split[i2] = DisguiseUtilities.quote(split[i2]);
            }
            for (i2 = 0; i2 < split.length; ++i2) {
                if (split[i2].length() <= 256) continue;
                split = Arrays.copyOf(split, split.length + 1);
                for (int a = split.length - 1; a > i2; --a) {
                    split[a] = split[a - 1];
                }
                split[i2 + 1] = split[i2].substring(256);
                split[i2] = split[i2].substring(0, 256);
            }
            ArrayList<String> sections = new ArrayList<String>();
            StringBuilder current = new StringBuilder();
            for (i = 0; i < split.length; ++i) {
                if (current.length() > 0) {
                    current.append(" ");
                }
                current.append(split[i]);
                if (split.length > i + 1 && split[i + 1].length() + current.length() + 1 <= 256) continue;
                if (i + 1 < split.length) {
                    current.append(" ");
                }
                sections.add(current.toString());
                current = new StringBuilder();
            }
            for (i = 0; i < sections.size(); ++i) {
                if (i > 0) {
                    builder.append((Component)Component.text((String)" "));
                }
                builder.append(this.createComponent((String)sections.get(i), i + 1, sections.size()));
            }
        } else {
            builder.append(this.createComponent(string, 1, 1));
        }
        DisguiseUtilities.sendMessage(sender, (Component)builder.build());
    }
}

