/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.utils;

import com.github.retrooper.packetevents.protocol.player.UserProfile;
import java.util.function.Supplier;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.utils.headresolvers.HeadResolver;
import me.libraryaddict.disguise.commands.utils.headresolvers.LegacyHeadResolver;
import me.libraryaddict.disguise.commands.utils.headresolvers.PaperHeadResolver;
import me.libraryaddict.disguise.commands.utils.headresolvers.SpigotHeadResolver;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.SkinUtils;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class GrabHeadCommand
implements CommandExecutor {
    private HeadResolver headResolver;

    public HeadResolver getHeadResolver() {
        if (this.headResolver == null) {
            for (Supplier supplier : new Supplier[]{PaperHeadResolver::new, SpigotHeadResolver::new, LegacyHeadResolver::new}) {
                HeadResolver resolver = (HeadResolver)supplier.get();
                if (!resolver.isAvailable()) continue;
                this.headResolver = resolver;
                break;
            }
            if (this.headResolver == null) {
                throw new IllegalStateException("No HeadResolver found!");
            }
        }
        return this.headResolver;
    }

    public boolean onCommand(final CommandSender sender, Command command, String s, String[] strings) {
        if (!(!(sender instanceof Player) || sender.isOp() || LibsPremium.isPremium().booleanValue() && LibsPremium.getPaidInformation() != LibsPremium.getPluginInformation())) {
            sender.sendMessage(ChatColor.RED + "This is the free version of Lib's Disguises, player commands are limited to console and Operators only! Purchase the plugin for non-admin usage!");
            return true;
        }
        if (!sender.hasPermission("libsdisguises.grabhead")) {
            LibsMsg.NO_PERM.send(sender, new Object[0]);
            return true;
        }
        if (!(sender instanceof Player)) {
            LibsMsg.NO_CONSOLE.send(sender, new Object[0]);
            return true;
        }
        if (strings.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        String[] args = DisguiseUtilities.split(StringUtils.join((Object[])strings, (String)" "));
        String skin = args[0];
        String usable = SkinUtils.getUsableStatus();
        if (usable != null) {
            DisguiseUtilities.sendMessage(sender, usable);
            return true;
        }
        SkinUtils.SkinCallback callback = new SkinUtils.SkinCallback(){
            private final BukkitTask runnable = new BukkitRunnable(){

                public void run() {
                    LibsMsg.PLEASE_WAIT.send(sender, new Object[0]);
                }
            }.runTaskTimer((Plugin)LibsDisguises.getInstance(), 100L, 100L);

            @Override
            public void onError(LibsMsg msg, Object ... args) {
                msg.send(sender, args);
                this.runnable.cancel();
            }

            @Override
            public void onInfo(LibsMsg msg, Object ... args) {
                msg.send(sender, args);
            }

            @Override
            public void onSuccess(final UserProfile profile) {
                this.runnable.cancel();
                DisguiseUtilities.doSkinUUIDWarning(sender);
                DisguiseUtilities.setGrabHeadCommandUsed();
                new BukkitRunnable(){

                    public void run() {
                        ItemStack skull = NmsVersion.v1_13.isSupported() ? new ItemStack(Material.PLAYER_HEAD) : new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
                        SkullMeta meta = (SkullMeta)skull.getItemMeta();
                        GrabHeadCommand.this.getHeadResolver().setProfile(meta, profile);
                        skull.setItemMeta((ItemMeta)meta);
                        ((Player)sender).getInventory().addItem(new ItemStack[]{skull});
                        LibsMsg.GRAB_HEAD_SUCCESS.send(sender, new Object[0]);
                    }
                }.runTask((Plugin)LibsDisguises.getInstance());
            }
        };
        SkinUtils.grabSkin(sender, skin, callback);
        return true;
    }

    private void sendHelp(CommandSender sender) {
        LibsMsg.GRAB_DISG_HELP_1.send(sender, new Object[0]);
        LibsMsg.GRAB_DISG_HELP_2.send(sender, new Object[0]);
        LibsMsg.GRAB_DISG_HELP_3.send(sender, new Object[0]);
        LibsMsg.GRAB_DISG_HELP_4.send(sender, new Object[0]);
        LibsMsg.GRAB_DISG_HELP_5.send(sender, new Object[0]);
        LibsMsg.GRAB_DISG_HELP_6.send(sender, new Object[0]);
    }
}

