/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import com.google.gson.Gson;
import java.util.Collections;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsEntityInteract;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;

public class LDDebugPlayer
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Collections.singletonList("debug");
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission(this.getPermission());
    }

    @Override
    public String getPermission() {
        return "libsdisguises.debug";
    }

    @Override
    public void onCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            LibsMsg.NO_CONSOLE.send(sender, new Object[0]);
        }
        LibsDisguises.getInstance().getListener().addInteraction(sender.getName(), new DebugInteraction(), 60);
        sender.sendMessage(ChatColor.DARK_GREEN + "Right click a disguised player to get some debug outta em");
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_DEBUG;
    }

    public static class DebugInteraction
    implements LibsEntityInteract {
        @Override
        public void onInteract(Player player, Entity entity) {
            Team team;
            Disguise disguise = DisguiseAPI.getDisguise(player, entity);
            if (disguise == null) {
                LibsMsg.TARGET_NOT_DISGUISED.send((CommandSender)player, new Object[0]);
                return;
            }
            if (!disguise.isPlayerDisguise()) {
                player.sendMessage(ChatColor.RED + "Meant to be used on player disguises!");
                return;
            }
            PlayerDisguise disg = (PlayerDisguise)disguise;
            player.sendMessage(ChatColor.RED + "Name: " + disg.getName().replace('\u00a7', '&'));
            if (!disg.hasScoreboardName()) {
                player.sendMessage(ChatColor.RED + "Disguise doesn't have scoreboard name, can't say more.");
                return;
            }
            DisguiseUtilities.DScoreTeam name = disg.getScoreboardName();
            player.sendMessage(ChatColor.RED + String.format("Prefix: '%s', Suffix: '%s', Disguise Name: '%s', Team '%s'", name.getPrefix().replace('\u00a7', '&'), name.getSuffix().replace('\u00a7', '&'), name.getPlayer().replace('\u00a7', '&'), name.getTeamName()));
            if (disg.getInternals().getNameDisplayType().isFakeEntity()) {
                player.sendMessage(ChatColor.AQUA + "Oh! You're using " + (Object)((Object)disg.getInternals().getNameDisplayType()) + "! Lets give some debug for that too..");
                player.sendMessage(ChatColor.RED + String.format("Names: %s, Length: %s, Custom Name: '%s'", new Gson().toJson((Object)disg.getMultiName()).replace('\u00a7', '&'), disg.getMultiNameLength(), disg.getWatcher().getCustomName().replace('\u00a7', '&')));
            }
            if ((team = player.getScoreboard().getTeam(name.getTeamName())) == null) {
                player.sendMessage(ChatColor.RED + "That team doesn't exist to you");
                if (Bukkit.getScoreboardManager().getMainScoreboard().getTeam(name.getTeamName()) != null) {
                    player.sendMessage(ChatColor.RED + "But it does exist on the main scoreboard..");
                }
                return;
            }
            player.sendMessage(ChatColor.RED + String.format("Prefix Matches: %s, Suffix Matches: %s, In Team: %s, Name Visibility: %s", team.getPrefix().equals(name.getPrefix()), team.getSuffix().equals(name.getSuffix()), team.hasEntry(name.getPlayer()), team.getOption(Team.Option.NAME_TAG_VISIBILITY)));
        }
    }
}

