/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.animate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.animate.BaseDisguiseAnimate;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.animations.DisguiseAnimation;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisguiseRadiusAnimationCommand
extends BaseDisguiseAnimate
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        DisguiseAnimation[] animations;
        if (sender instanceof Player && !sender.isOp() && !LibsPremium.isPremium().booleanValue()) {
            sender.sendMessage(ChatColor.RED + "This is the free version of Lib's Disguises, player commands are limited to console and Operators only! Purchase the plugin for non-admin usage!");
            return true;
        }
        if (args.length < 2) {
            LibsMsg.D_ANIM_RADIUS_HELP_1.send(sender, DisguiseConfig.getDisguiseRadiusMax());
            LibsMsg.D_ANIM_RADIUS_HELP_2.send(sender, s.toLowerCase(Locale.ENGLISH));
            LibsMsg.DISGUISE_ANIMATE_SEE_ALL_ANIMATIONS.send(sender, ParamInfoManager.getParamInfo(DisguiseAnimation.class).getName().replace(" ", ""));
            return true;
        }
        DisguiseType baseType = null;
        int starting = 0;
        if (this.isNotInteger(args[0])) {
            for (DisguiseType t : DisguiseType.values()) {
                if (t.getEntityType() == null || !t.toReadable().replaceAll(" ", "").equalsIgnoreCase(args[0].replaceAll("_", ""))) continue;
                baseType = t;
                starting = 1;
                break;
            }
            if (baseType == null) {
                LibsMsg.UNRECOGNIZED_DISGUISE_TYPE.send(sender, args[0]);
                return true;
            }
        }
        if (args.length == starting + 1) {
            if (starting == 0) {
                LibsMsg.D_ANIM_RADIUS_NEED_ANIMS.send(sender, new Object[0]);
            } else {
                LibsMsg.D_ANIM_RADIUS_NEED_ANIMS_ENTITY.send(sender, new Object[0]);
            }
            return true;
        }
        if (args.length < 2) {
            LibsMsg.D_ANIM_RADIUS_NEED_ANIMS.send(sender, new Object[0]);
            return true;
        }
        if (this.isNotInteger(args[starting])) {
            LibsMsg.NOT_NUMBER.send(sender, args[starting]);
            return true;
        }
        int radius = Integer.parseInt(args[starting]);
        if (radius > DisguiseConfig.getDisguiseRadiusMax()) {
            LibsMsg.LIMITED_RADIUS.send(sender, DisguiseConfig.getDisguiseRadiusMax());
            radius = DisguiseConfig.getDisguiseRadiusMax();
        }
        if ((animations = this.getAnimations(sender, null, Arrays.copyOfRange(args, starting + 1, args.length))) == null) {
            return true;
        }
        int modifiedDisguises = 0;
        for (Entity entity : this.getNearbyEntities(sender, radius)) {
            Disguise[] disguises;
            if (entity == sender || baseType != null && !baseType.name().equalsIgnoreCase(entity.getType().name()) || sender instanceof Player && entity instanceof Player && !((Player)sender).canSee((Player)entity)) continue;
            for (Disguise disguise : disguises = DisguiseAPI.getDisguises(entity)) {
                List<DisguiseAnimation> validAnimations = DisguiseAnimation.getAnimations(disguise.getType());
                for (DisguiseAnimation disguiseAnimation : animations) {
                    if (!validAnimations.contains((Object)disguiseAnimation)) continue;
                    disguise.playAnimation(disguiseAnimation);
                    ++modifiedDisguises;
                }
            }
        }
        if (modifiedDisguises > 0) {
            LibsMsg.D_ANIM_RADIUS_SUCCESS.send(sender, modifiedDisguises);
        } else {
            LibsMsg.D_ANIM_RADIUS_FAIL.send(sender, new Object[0]);
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        String lastArg;
        ArrayList<String> tabs = new ArrayList<String>();
        String string = lastArg = args.length > 0 ? args[args.length - 1].toLowerCase(Locale.ENGLISH) : "";
        if (lastArg.matches("^[^a-z].*$")) {
            return tabs;
        }
        if (args.length == 2 && args[0].matches("^[a-zA-Z].*$")) {
            return tabs;
        }
        if (args.length <= 1) {
            for (DisguiseType type : DisguiseType.values()) {
                String name;
                if (type.getEntityType() == null || !(name = type.toReadable().replace(" ", "_")).toLowerCase(Locale.ENGLISH).startsWith(lastArg)) continue;
                tabs.add(name);
            }
            return tabs;
        }
        List<String> list = this.getAnimations(null);
        for (String animation : list) {
            if (!animation.toLowerCase(Locale.ENGLISH).startsWith(lastArg)) continue;
            tabs.add(animation);
        }
        return tabs;
    }

    private boolean isNotInteger(String string) {
        try {
            Integer.parseInt(string);
            return false;
        }
        catch (Exception ex) {
            return true;
        }
    }

    private Collection<Entity> getNearbyEntities(CommandSender sender, int radius) {
        Location center = sender instanceof Player ? ((Player)sender).getLocation() : ((BlockCommandSender)sender).getBlock().getLocation().add(0.5, 0.0, 0.5);
        return center.getWorld().getNearbyEntities(center, (double)radius, (double)radius, (double)radius);
    }
}

