/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.animate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.commands.animate.BaseDisguiseAnimate;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.animations.DisguiseAnimation;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisguisePlayerAnimationCommand
extends BaseDisguiseAnimate
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        if (commandSender instanceof Player && !commandSender.isOp() && !LibsPremium.isPremium().booleanValue()) {
            commandSender.sendMessage(ChatColor.RED + "This is the free version of Lib's Disguises, player commands are limited to console and Operators only! Purchase the plugin for non-admin usage!");
            return true;
        }
        Player entityTarget = null;
        if (args.length > 0 && (entityTarget = Bukkit.getPlayer((String)args[0])) == null && args[0].contains("-")) {
            try {
                entityTarget = Bukkit.getEntity((UUID)UUID.fromString(args[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (args.length < 2) {
            List valid;
            LibsMsg.D_ANIMATE_PLAYER.send(commandSender, s.toLowerCase(Locale.ENGLISH));
            List<Object> list = valid = entityTarget == null ? Collections.emptyList() : this.getSupported((Entity)entityTarget);
            if (valid.isEmpty()) {
                LibsMsg.DISGUISE_ANIMATE_SEE_ALL_ANIMATIONS.send(commandSender, ParamInfoManager.getParamInfo(DisguiseAnimation.class).getName().replace(" ", ""));
            } else {
                LibsMsg.DISGUISE_ANIMATE_HELP_DISGUISED.send(commandSender, String.join((CharSequence)LibsMsg.DISGUISE_ANIMATE_HELP_DISGUISED_SEPERATOR.get(new Object[0]), valid));
            }
            return true;
        }
        if (entityTarget == null) {
            LibsMsg.CANNOT_FIND_PLAYER.send(commandSender, new Object[0]);
            return true;
        }
        Disguise[] disguises = DisguiseAPI.getDisguises((Entity)entityTarget);
        if (disguises.length == 0) {
            LibsMsg.TARGET_NOT_DISGUISED.send(commandSender, new Object[0]);
            return true;
        }
        List[] validAnimations = new List[disguises.length];
        for (int i = 0; i < disguises.length; ++i) {
            validAnimations[i] = DisguiseAnimation.getAnimations(disguises[i].getWatcher().getClass());
        }
        DisguiseAnimation[] animations = this.getAnimations(commandSender, validAnimations, Arrays.copyOfRange(args, 1, args.length));
        if (animations == null) {
            return true;
        }
        for (int i = 0; i < disguises.length; ++i) {
            for (int animation = 0; animation < validAnimations.length; ++animation) {
                if (!validAnimations[i].contains((Object)animations[i])) continue;
                disguises[i].playAnimation(animations[animation]);
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] strings) {
        String prefix;
        ArrayList<String> tabs = new ArrayList<String>();
        String string = prefix = strings.length == 0 ? "" : strings[strings.length - 1].toLowerCase(Locale.ENGLISH);
        if (strings.length <= 1) {
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                if (sender instanceof Player && !((Player)sender).canSee(player2) || !player2.getName().toLowerCase(Locale.ENGLISH).startsWith(prefix)) continue;
                tabs.add(player2.getName());
            }
            return tabs;
        }
        Player player = Bukkit.getPlayer((String)strings[0]);
        if (player == null && strings[0].contains("-")) {
            try {
                player = Bukkit.getEntity((UUID)UUID.fromString(strings[0]));
            }
            catch (Exception player2) {
                // empty catch block
            }
        }
        if (player == null) {
            return tabs;
        }
        List<String> valid = this.getSupported((Entity)player);
        if (strings.length > 0) {
            String lower = strings[strings.length - 1].toLowerCase(Locale.ENGLISH);
            valid.removeIf(arg -> !arg.toLowerCase(Locale.ENGLISH).startsWith(lower));
        }
        return valid;
    }
}

