/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.animate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.utilities.animations.DisguiseAnimation;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDisguiseAnimate {
    public List<String> getSupported(Entity target) {
        ArrayList<String> valid = new ArrayList<String>();
        for (Disguise disguise : DisguiseAPI.getDisguises(target)) {
            Class<?> cl = disguise.getWatcher().getClass();
            this.getAnimations(cl).stream().filter(anim -> !valid.contains(anim)).forEach(valid::add);
        }
        return valid;
    }

    public List<String> getAnimations(@Nullable Class<? extends FlagWatcher> cl) {
        List<DisguiseAnimation> animations = cl == null ? Arrays.asList(DisguiseAnimation.values()) : DisguiseAnimation.getAnimations(cl);
        return animations.stream().filter(anim -> !anim.isHidden()).map(anim -> TranslateType.DISGUISE_ANIMATIONS.get(anim.name())).collect(Collectors.toList());
    }

    public DisguiseAnimation[] getAnimations(CommandSender sender, @Nullable List<DisguiseAnimation>[] validAnimations, String[] commandArgs) {
        DisguiseAnimation[] animations = new DisguiseAnimation[commandArgs.length];
        for (int i = 0; i < commandArgs.length; ++i) {
            try {
                animations[i] = DisguiseAnimation.valueOf(TranslateType.DISGUISE_ANIMATIONS.reverseGet(commandArgs[i].toUpperCase(Locale.ENGLISH)));
            }
            catch (Exception ex) {
                LibsMsg.PARSE_INVALID_ANIMATION.send(sender, commandArgs[i]);
                return null;
            }
            DisguiseAnimation animation = animations[i];
            if (validAnimations == null || Arrays.stream(validAnimations).anyMatch(l -> l.contains((Object)animation))) continue;
            LibsMsg.PARSE_MISMATCHED_ANIMATION.send(sender, TranslateType.DISGUISE_ANIMATIONS.get(animation.name()));
            return null;
        }
        return animations;
    }
}

