/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.LibsDisguisesCommand;
import me.libraryaddict.disguise.commands.animate.DisguiseAnimationCommand;
import me.libraryaddict.disguise.commands.animate.DisguiseEntityAnimationCommand;
import me.libraryaddict.disguise.commands.animate.DisguisePlayerAnimationCommand;
import me.libraryaddict.disguise.commands.animate.DisguiseRadiusAnimationCommand;
import me.libraryaddict.disguise.commands.disguise.DisguiseCommand;
import me.libraryaddict.disguise.commands.disguise.DisguiseEntityCommand;
import me.libraryaddict.disguise.commands.disguise.DisguisePlayerCommand;
import me.libraryaddict.disguise.commands.disguise.DisguiseRadiusCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyEntityCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyPlayerCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyRadiusCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguiseCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguiseEntityCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguisePlayerCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguiseRadiusCommand;
import me.libraryaddict.disguise.commands.utils.CopyDisguiseCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseCloneCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseHelpCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseViewBarCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseViewSelfCommand;
import me.libraryaddict.disguise.commands.utils.GrabHeadCommand;
import me.libraryaddict.disguise.commands.utils.GrabSkinCommand;
import me.libraryaddict.disguise.commands.utils.SaveDisguiseCommand;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.animations.DisguiseAnimation;
import me.libraryaddict.disguise.utilities.config.DisguiseCommandConfig;
import me.libraryaddict.disguise.utilities.listeners.DisguiseListener;
import me.libraryaddict.disguise.utilities.listeners.DisguiseListener1_18;
import me.libraryaddict.disguise.utilities.listeners.PaperDisguiseListener;
import me.libraryaddict.disguise.utilities.listeners.PlayerSkinHandler;
import me.libraryaddict.disguise.utilities.listeners.VulcanCompatibilityListener;
import me.libraryaddict.disguise.utilities.metrics.MetricsInitalizer;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.placeholderapi.DisguisePlaceholders;
import me.libraryaddict.disguise.utilities.reflection.ClassMappings;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.SoundManager;
import me.libraryaddict.disguise.utilities.updates.PacketEventsUpdater;
import me.libraryaddict.disguise.utilities.updates.UpdateChecker;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class LibsDisguises
extends JavaPlugin {
    private static LibsDisguises instance;
    private DisguiseListener listener;
    private String buildNumber;
    private String buildDate;
    private String buildHash;
    private boolean reloaded;
    private final UpdateChecker updateChecker = new UpdateChecker();
    private PlayerSkinHandler skinHandler;
    private DisguiseCommandConfig commandConfig;
    private boolean packetEventsUpdateDownloaded;
    private final long serverStarted = System.currentTimeMillis();

    public void onLoad() {
        try {
            boolean hasInstanceAlready;
            boolean bl = hasInstanceAlready = instance != null;
            if (hasInstanceAlready || !Bukkit.getServer().getWorlds().isEmpty() || !Bukkit.getOnlinePlayers().isEmpty()) {
                this.reloaded = true;
                this.getLogger().severe("Server was reloaded! Please do not report any bugs! This plugin can't handle reloads gracefully!");
            }
            instance = this;
            DisguiseConfig.loadInternalConfig();
            DisguiseConfig.loadPreConfig();
            this.loadPacketEvents();
            DisguiseUtilities.isRunningPaper();
            try {
                Class<?> clazz = Class.forName("org.bukkit.Server$Spigot");
            }
            catch (ClassNotFoundException e) {
                this.getLogger().severe("Oh dear, you seem to be using CraftBukkit. Please upgrade to use Spigot or Paper instead! This plugin will continue to load, but it will look like a mugging victim");
            }
            if (Bukkit.getVersion().toLowerCase(Locale.ENGLISH).matches(".*(arclight|mohist|magma).*")) {
                this.getLogger().severe("Lib's Disguises will not work correctly on Forge/Hybrid servers, due to complexibility and time commitment there is no support for this. Do not report any issues to Lib's Disguises.");
            }
            this.commandConfig = new DisguiseCommandConfig();
            if (!(hasInstanceAlready || !this.isReleaseBuild() && LibsPremium.getPaidInformation() == null && LibsPremium.isPremium().booleanValue())) {
                this.commandConfig.load();
            }
        }
        catch (Throwable throwable) {
            this.deleteMappingsCache();
            try {
                if (this.isJenkins() && DisguiseConfig.isAutoUpdate()) {
                    this.getUpdateChecker().doUpdate();
                }
            }
            catch (Throwable t) {
                this.getLogger().severe("Failed to even do a forced update");
            }
            throw throwable;
        }
    }

    private void loadPacketEvents() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("packetevents");
        if (plugin != null && !PacketEventsUpdater.isPacketEventsOutdated()) {
            return;
        }
        if (DisguiseConfig.isNeverUpdatePacketEvents()) {
            this.getLogger().warning("Defined in plugins/LibsDisguises/configs/sanity.yml, you have requested that Lib's Disguises never updates or installs PacketEvents. Please do not report any issues with this plugin.");
            return;
        }
        if (!DisguiseConfig.isAutoUpdate()) {
            this.getLogger().warning("Defined in plugins/LibsDisguises/configs/libsdisguises.yml, you have requested that Lib's Disguises never auto updates, which includes PacketEvents. Please do not report any issues with this plugin.");
            return;
        }
        Matcher matcher = Pattern.compile(" \\(MC: ([^)]+?)\\)").matcher(Bukkit.getVersion());
        if (!matcher.find()) {
            this.getLogger().severe("Skipping PacketEvents check, unable to determine Minecraft version.");
            return;
        }
        String mcVersion = matcher.group(1);
        NmsVersion version = NmsVersion.getByVersion(mcVersion);
        if (version == null || !version.isVersionLoadable()) {
            this.getLogger().severe(String.format("Skipping PacketEvents validation, this version of Minecraft (%s) does not appear to be supported.", mcVersion));
            return;
        }
        String reason = this.getPacketEventsFailedReason(plugin);
        this.getLogger().warning("An issue occured when trying to load PacketEvents: " + reason + ". Lib's Disguises will attempt to update it.");
        try {
            PacketEventsUpdater updater = new PacketEventsUpdater();
            boolean attempt = updater.doUpdate();
            if (!attempt) {
                this.getLogger().severe("PacketEvents download has failed, please install PacketEvents manually from https://www.spigotmc.org/resources/packetevents-api.80279/ or https://modrinth.com/plugin/packetevents");
                return;
            }
            if (plugin != null) {
                this.getLogger().severe("Please restart the server to complete the PacketEvents update!");
                return;
            }
            this.getLogger().info("PacketEvents downloaded and stuck in plugins folder! Now trying to load it!");
            plugin = Bukkit.getPluginManager().loadPlugin(updater.getDestination());
            plugin.onLoad();
            Bukkit.getPluginManager().enablePlugin(plugin);
        }
        catch (Exception e) {
            this.getLogger().severe("Looks like PacketEvents's site may be down! Try download it manually from https://www.spigotmc.org/resources/packetevents-api.80279/ or https://modrinth.com/plugin/packetevents");
            e.printStackTrace();
        }
    }

    private void deleteMappingsCache() {
        try {
            ClassMappings.deleteMappingsCache();
        }
        catch (Throwable throwable1) {
            throwable1.printStackTrace();
            this.getLogger().severe("Failed to delete mappings cache");
        }
    }

    public void onEnable() {
        try {
            if (this.isReloaded()) {
                this.getLogger().severe("Server was reloaded! Please do not report any bugs! This plugin can't handle reloads gracefully!");
            }
            this.verboseLog("Checking for terrible Minecraft versions (Shouldn't be used)...");
            this.runWarnings();
            this.verboseLog("Quickly checking Libs Disguises jar for third party viruses...");
            this.loadYamlWarnVirus();
            this.verboseLog("Printing off information about the current server + plugin...");
            this.logInfo();
            this.verboseLog("Checking if the plugin should have cool stuff, or if the user opted for free stuff...");
            LibsPremium.check(this.getDescription().getVersion(), this.getFile());
            this.someMoreLogging();
            NmsVersion nmsVersion = ReflectionManager.getVersion();
            if (nmsVersion == null || nmsVersion == NmsVersion.UNSUPPORTED) {
                this.getLogger().severe("You're using the wrong version of Lib's Disguises for your server! This is intended for " + Arrays.stream(NmsVersion.values()).filter(v -> !v.isDeprecated()).map(NmsVersion::getCompressedVersions).collect(Collectors.joining(", ")) + "!");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            if (!nmsVersion.isVersionLoadable()) {
                this.getLogger().severe("Please update to a minimum of " + nmsVersion.getRecommendedMinorVersion() + " to continue using this plugin.");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            this.verboseLog("Checking if packetevents is outdated...");
            this.startOutdatedPacketevents();
            if (this.isReleaseBuild()) {
                if (LibsPremium.getUserID().matches("\\d+")) {
                    DisguiseConfig.setUsingReleaseBuilds(true);
                }
            } else {
                DisguiseConfig.setUsingReleaseBuilds(false);
            }
            this.verboseLog("Eunning some backend loading...");
            this.runBackendStuff();
            this.verboseLog("Loading the bulky configs...");
            DisguiseConfig.loadConfig();
            this.verboseLog("Registering the listeners...");
            this.registerListeners();
            this.verboseLog("Registering the commands...");
            this.registerCommands();
            this.verboseLog("Sorting out the PlaceholderAPI integration incase its on the server...");
            this.integratePlaceholderApi();
            this.verboseLog("Adding in metrics... Unless its disabled, then I'm very sad...");
            new MetricsInitalizer();
        }
        catch (Throwable throwable) {
            this.deleteMappingsCache();
            try {
                if (this.isJenkins() && DisguiseConfig.isAutoUpdate()) {
                    this.getUpdateChecker().doUpdate();
                }
            }
            catch (Throwable t) {
                this.getLogger().severe("Lib's Disguises couldn't update itself");
            }
            throw throwable;
        }
    }

    private void runBackendStuff() {
        if (SpigotReflectionUtil.VERSION == null) {
            this.verboseLog("Starting up packetevents reflections as it isn't ready yet...");
            SpigotReflectionUtil.init();
        }
        this.verboseLog("Starting up our own reflection classes...");
        ReflectionManager.init();
        this.verboseLog("Giving packetevents awareness of server registry");
        ReflectionManager.tryLoadRegistriesIntoPE();
        this.verboseLog("Creating but not registering the packet listeners...");
        PacketsManager.getPacketsManager().init();
        this.verboseLog("Setting up some internal utilities for disguises...");
        DisguiseUtilities.init();
        this.verboseLog("Loading the sound files...");
        new SoundManager().load();
        this.verboseLog("Integrating information about entities...");
        ReflectionManager.registerValues();
        DisguiseAnimation.load();
        this.verboseLog("Loading disguise parsing information...");
        DisguiseParser.createDefaultMethods();
        this.verboseLog("Recalculating some sounds...");
        ParamInfoManager.getParamInfoSoundGroup().recalculate();
    }

    private void registerListeners() {
        PacketsManager.getPacketsManager().addPacketListeners();
        this.listener = new DisguiseListener(this);
        this.skinHandler = new PlayerSkinHandler();
        if ("32453".length() == 5) {
            Bukkit.getPluginManager().registerEvents((Listener)this.getSkinHandler(), (Plugin)LibsDisguises.getInstance());
        }
        if (NmsVersion.v1_18_R1.isSupported()) {
            Bukkit.getPluginManager().registerEvents((Listener)new DisguiseListener1_18(), (Plugin)this);
        }
        if (DisguiseUtilities.isRunningPaper()) {
            Bukkit.getPluginManager().registerEvents((Listener)new PaperDisguiseListener(), (Plugin)this);
        }
        try {
            if (Bukkit.getPluginManager().isPluginEnabled("Vulcan")) {
                Bukkit.getPluginManager().registerEvents((Listener)new VulcanCompatibilityListener(), (Plugin)this);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @NotNull
    private String getPacketEventsFailedReason(Plugin plugin) {
        if (plugin == null) {
            return "PacketEvents not installed";
        }
        if (PacketEventsUpdater.isPacketEventsOutdated()) {
            return "PacketEvents is outdated";
        }
        if (!plugin.isEnabled()) {
            return "PacketEvents is not enabled";
        }
        return "Lib's Disguises couldn't access PacketEvents properly";
    }

    private void runWarnings() {
        if (Bukkit.getVersion().contains("(MC: 1.17)")) {
            this.getLogger().severe("Please update from MC 1.17! You should be using 1.17.1!");
        }
        if (Bukkit.getVersion().contains("(MC: 1.18)") || Bukkit.getVersion().contains("(MC: 1.18.1)")) {
            this.getLogger().severe("Please update from MC 1.18 and MC 1.18.1! You should be using 1.18.2! Support will eventually be dropped for your specific version!");
        }
        if (Bukkit.getVersion().contains("(MC: 1.19)")) {
            this.getLogger().severe("Please update from MC 1.19.0! You should be using at least 1.19.3! 1.19.1 is the lowest supported 1.19 version!");
        }
        try {
            Class<?> clazz = Class.forName("org.bukkit.Server$Spigot");
        }
        catch (ClassNotFoundException e) {
            this.getLogger().severe("Oh dear, you seem to be using CraftBukkit. Please use Spigot or Paper instead! This plugin will continue to load, but it will look like a mugging victim");
        }
    }

    private void loadYamlWarnVirus() throws IOException {
        int expected;
        YamlConfiguration pluginYml = ReflectionManager.getPluginYAML(this.getFile());
        this.buildNumber = StringUtils.stripToNull((String)pluginYml.getString("build-number"));
        this.buildDate = StringUtils.stripToNull((String)pluginYml.getString("build-date"));
        this.buildHash = StringUtils.stripToNull((String)pluginYml.getString("build-hash"));
        int fileCount = ReflectionManager.getJarFileCount(this.getFile());
        if (fileCount != (expected = pluginYml.getInt("file-count", fileCount))) {
            this.getLogger().severe("Hi, this is libraryaddict from Lib's Disguises informing you that I have detected that my plugin Lib's Disguises looks like another plugin (don't know which) has injected malware into it as soon as Lib's Disguises started running on your server, there were " + (fileCount - expected) + " unknown files injected into the jar. Please redownload from a trusted source such as SpigotMC. If this warning shows even after updating, try https://www.spigotmc.org/resources/spigot-anti-malware.64982/ but you will likely need to reinstall all your plugins, jars, etc as just one infected plugin will infect everything else when it loads.");
            this.getLogger().severe("Unfortunately I have seen this happen from time to time, this normally happens when a server owner is tricked into adding third party plugins. Please note that Lib's Disguises is only detecting itself and doesn't know what other plugins have malware, only that Lib's Disguises itself was infected immediately after you installed it in your server. The jar in your plugins folder will be bigger than what you downloaded from SpigotMC, you can easily check that for yourself. I can't help you deal with the malware, there's no shortcuts but to re-download everything and remember not to download from shady sources.");
        }
    }

    private void logInfo() {
        String recommended;
        this.getLogger().info("File Name: " + this.getFile().getName());
        String minecraft = ReflectionManager.getMinecraftVersion();
        NmsVersion version = ReflectionManager.getVersion();
        this.getLogger().info("Discovered nms version (LD: " + (Object)((Object)version) + ") (MC: " + minecraft + ")");
        this.getLogger().info(String.format("Jenkins Build: %s%s", this.isJenkins() ? "#" : "", this.getBuildNo()));
        this.getLogger().info("Build Date: " + this.getBuildDate());
        this.getLogger().info("Build Hash: " + this.getBuildHash());
        if (version != null && !(recommended = version.getRecommendedMinorVersion()).equals(minecraft)) {
            this.getLogger().warning("You are running an older minor version of Minecraft, you are currently using " + minecraft + ", consider updating to " + recommended);
            if (version.isDeprecated()) {
                this.getLogger().warning("Your version of Minecraft will not be supported in the future.");
            }
        }
    }

    private void someMoreLogging() {
        if (!LibsPremium.isPremium().booleanValue()) {
            this.getLogger().info("You are running the free version, commands limited to non-players and operators. (Console, Command Blocks, Admins)");
        }
        if (!DisguiseConfig.getTallSelfDisguisesVisibility().isAlwaysVisible()) {
            LibsDisguises.getInstance().getLogger().info("Config 'TallSelfDisguises' is set to '" + (Object)((Object)DisguiseConfig.getTallSelfDisguisesVisibility()) + "', LD will " + (DisguiseConfig.getTallSelfDisguisesVisibility().isScaled() ? "scale down (when possible)" : "hide") + " oversized disguises from self disguise. https://www.spigotmc.org/wiki/lib-s-disguises-faq/#tall-disguises-self-disguises");
        }
    }

    private void startOutdatedPacketevents() {
        if (!DisguiseConfig.isNeverUpdatePacketEvents() && PacketEventsUpdater.isPacketEventsOutdated()) {
            String requiredPacketEvents = PacketEventsUpdater.getMinimumPacketEventsVersion();
            Plugin plugin = Bukkit.getPluginManager().getPlugin("packetevents");
            String version = plugin == null ? "[PacketEvents Plugin Missing]" : plugin.getDescription().getVersion();
            BukkitRunnable runnable = this.createPacketEventsOutdatedRunnable(version, requiredPacketEvents);
            runnable.run();
            runnable.runTaskLater((Plugin)this, 20L);
        }
        PacketEventsUpdater.doShadedWarning();
    }

    private void registerCommands() {
        this.registerCommand("libsdisguises", new LibsDisguisesCommand());
        this.registerCommand("disguise", new DisguiseCommand());
        this.registerCommand("undisguise", new UndisguiseCommand());
        this.registerCommand("disguiseplayer", new DisguisePlayerCommand());
        this.registerCommand("undisguiseplayer", new UndisguisePlayerCommand());
        this.registerCommand("undisguiseentity", new UndisguiseEntityCommand());
        this.registerCommand("disguiseentity", new DisguiseEntityCommand());
        this.registerCommand("disguiseradius", new DisguiseRadiusCommand());
        this.registerCommand("undisguiseradius", new UndisguiseRadiusCommand());
        this.registerCommand("disguisehelp", new DisguiseHelpCommand());
        this.registerCommand("disguiseclone", new DisguiseCloneCommand());
        this.registerCommand("disguiseviewself", new DisguiseViewSelfCommand());
        this.registerCommand("disguiseviewbar", new DisguiseViewBarCommand());
        this.registerCommand("disguisemodify", new DisguiseModifyCommand());
        this.registerCommand("disguisemodifyentity", new DisguiseModifyEntityCommand());
        this.registerCommand("disguisemodifyplayer", new DisguiseModifyPlayerCommand());
        this.registerCommand("disguisemodifyradius", new DisguiseModifyRadiusCommand());
        this.registerCommand("disguiseanimation", (CommandExecutor)new DisguiseAnimationCommand());
        this.registerCommand("disguiseplayeranimation", (CommandExecutor)new DisguisePlayerAnimationCommand());
        this.registerCommand("disguiseentityanimation", (CommandExecutor)new DisguiseEntityAnimationCommand());
        this.registerCommand("disguiseradiusanimation", (CommandExecutor)new DisguiseRadiusAnimationCommand());
        this.registerCommand("copydisguise", new CopyDisguiseCommand());
        this.registerCommand("grabskin", new GrabSkinCommand());
        this.registerCommand("savedisguise", new SaveDisguiseCommand());
        this.registerCommand("grabhead", new GrabHeadCommand());
        this.unregisterCommands(false);
    }

    private void integratePlaceholderApi() {
        if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return;
        }
        new DisguisePlaceholders().register();
        this.getLogger().info("PlaceholderAPI support enabled");
    }

    @NotNull
    private BukkitRunnable createPacketEventsOutdatedRunnable(final String version, final String requiredPacketEvents) {
        return new BukkitRunnable(){
            private int timesRun;

            public void run() {
                if (LibsDisguises.this.isPacketEventsUpdateDownloaded()) {
                    LibsDisguises.this.getLogger().warning("An update for PacketEvents has been downloaded and will be installed when the server restarts. When possible, please restart the server. Lib's Disguises may not work correctly until you do so.");
                } else {
                    LibsDisguises.this.getLogger().warning("Update your PacketEvents! You are running " + version + " but the minimum version you should be on is " + requiredPacketEvents + "!");
                    LibsDisguises.this.getLogger().warning("Release Builds: https://modrinth.com/plugin/packetevents");
                    if (requiredPacketEvents.contains("SNAPSHOT")) {
                        LibsDisguises.this.getLogger().warning("Minimum version is a SNAPSHOT build, it's possible that the features/bugfixes has not made it into the releases yet. As such, you may need to use the dev builds instead. Using `/ld packetevents` will handle it for you.");
                        LibsDisguises.this.getLogger().warning("Snapshot Builds: https://ci.codemc.io/job/retrooper/job/packetevents/");
                    }
                    LibsDisguises.this.getLogger().warning("Or! Use /ld packetevents - To have Lib's Disguises download the latest release (Or snapshot if release is behind)");
                }
            }
        };
    }

    public void unregisterCommands(boolean force) {
        SimpleCommandMap map = ReflectionManager.getCommandMap();
        Map<String, Command> commands = ReflectionManager.getCommands((CommandMap)map);
        for (String command : this.getDescription().getCommands().keySet()) {
            PluginCommand cmd = this.getCommand("libsdisguises:" + command);
            if (cmd == null || cmd.getExecutor() != this && !force) continue;
            if (cmd.getPermission() != null && cmd.getPermission().startsWith("libsdisguises.seecmd")) {
                Bukkit.getPluginManager().removePermission(cmd.getPermission());
            }
            Iterator<Map.Entry<String, Command>> itel = commands.entrySet().iterator();
            while (itel.hasNext()) {
                Map.Entry<String, Command> entry = itel.next();
                if (entry.getValue() != cmd) continue;
                itel.remove();
            }
        }
    }

    @NotNull
    public File getFile() {
        return super.getFile();
    }

    public void onDisable() {
        DisguiseUtilities.saveDisguises();
        if (ClassMappings.isLoadedCache()) {
            ClassMappings.saveMappingsCache(this.getDataFolder());
        }
        this.reloaded = true;
    }

    public boolean isReleaseBuild() {
        return !this.getDescription().getVersion().contains("-SNAPSHOT");
    }

    public String getBuildNo() {
        return this.buildNumber;
    }

    public int getBuildNumber() {
        return this.isJenkins() ? Integer.parseInt(this.getBuildNo()) : 0;
    }

    public boolean isJenkins() {
        return this.getBuildNo() != null && this.getBuildNo().matches("\\d+");
    }

    public boolean isDebuggingBuild() {
        return !this.isJenkins();
    }

    private void registerCommand(String commandName, CommandExecutor executioner) {
        String name = this.commandConfig.getCommand(commandName);
        if (name == null) {
            return;
        }
        PluginCommand command = this.getCommand("libsdisguises:" + name);
        if (command == null) {
            return;
        }
        command.setExecutor(executioner);
        if (executioner instanceof TabCompleter) {
            command.setTabCompleter((TabCompleter)executioner);
        }
    }

    public void verboseLog(String line) {
        if (!DisguiseConfig.isVerboseLogging()) {
            return;
        }
        this.getLogger().info("DEBUG: " + line);
    }

    @Generated
    public static LibsDisguises getInstance() {
        return instance;
    }

    @Generated
    public DisguiseListener getListener() {
        return this.listener;
    }

    @Generated
    public String getBuildDate() {
        return this.buildDate;
    }

    @Generated
    public String getBuildHash() {
        return this.buildHash;
    }

    @Generated
    public boolean isReloaded() {
        return this.reloaded;
    }

    @Generated
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Generated
    public PlayerSkinHandler getSkinHandler() {
        return this.skinHandler;
    }

    @Generated
    public void setPacketEventsUpdateDownloaded(boolean packetEventsUpdateDownloaded) {
        this.packetEventsUpdateDownloaded = packetEventsUpdateDownloaded;
    }

    @Generated
    public boolean isPacketEventsUpdateDownloaded() {
        return this.packetEventsUpdateDownloaded;
    }

    @Generated
    public long getServerStarted() {
        return this.serverStarted;
    }
}

