/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.util;

import ia.sh.org.apache.commons.math3.util.FastMath;

class FastMath$Split {
    public static final FastMath$Split NAN = new FastMath$Split(Double.NaN, 0.0);
    public static final FastMath$Split POSITIVE_INFINITY = new FastMath$Split(Double.POSITIVE_INFINITY, 0.0);
    public static final FastMath$Split NEGATIVE_INFINITY = new FastMath$Split(Double.NEGATIVE_INFINITY, 0.0);
    private final double full;
    private final double high;
    private final double low;

    FastMath$Split(double d2) {
        this.full = d2;
        this.high = Double.longBitsToDouble(Double.doubleToRawLongBits(d2) & 0xFFFFFFFFF8000000L);
        this.low = d2 - this.high;
    }

    FastMath$Split(double d2, double d3) {
        this(d2 == 0.0 ? (d3 == 0.0 && Double.doubleToRawLongBits(d2) == Long.MIN_VALUE ? -0.0 : d3) : d2 + d3, d2, d3);
    }

    FastMath$Split(double d2, double d3, double d4) {
        this.full = d2;
        this.high = d3;
        this.low = d4;
    }

    public FastMath$Split multiply(FastMath$Split fastMath$Split) {
        FastMath$Split fastMath$Split2 = new FastMath$Split(this.full * fastMath$Split.full);
        double d2 = this.low * fastMath$Split.low - (fastMath$Split2.full - this.high * fastMath$Split.high - this.low * fastMath$Split.high - this.high * fastMath$Split.low);
        return new FastMath$Split(fastMath$Split2.high, fastMath$Split2.low + d2);
    }

    public FastMath$Split reciprocal() {
        double d2 = 1.0 / this.full;
        FastMath$Split fastMath$Split = new FastMath$Split(d2);
        FastMath$Split fastMath$Split2 = this.multiply(fastMath$Split);
        double d3 = fastMath$Split2.high - 1.0 + fastMath$Split2.low;
        return Double.isNaN(d3) ? fastMath$Split : new FastMath$Split(fastMath$Split.high, fastMath$Split.low - d3 / this.full);
    }

    private FastMath$Split pow(long l2) {
        FastMath$Split fastMath$Split = new FastMath$Split(1.0);
        FastMath$Split fastMath$Split2 = new FastMath$Split(this.full, this.high, this.low);
        for (long i2 = l2; i2 != 0L; i2 >>>= 1) {
            if ((i2 & 1L) != 0L) {
                fastMath$Split = fastMath$Split.multiply(fastMath$Split2);
            }
            fastMath$Split2 = fastMath$Split2.multiply(fastMath$Split2);
        }
        if (Double.isNaN(fastMath$Split.full)) {
            if (Double.isNaN(this.full)) {
                return NAN;
            }
            if (FastMath.abs(this.full) < 1.0) {
                return new FastMath$Split(FastMath.copySign(0.0, this.full), 0.0);
            }
            if (this.full < 0.0 && (l2 & 1L) == 1L) {
                return NEGATIVE_INFINITY;
            }
            return POSITIVE_INFINITY;
        }
        return fastMath$Split;
    }

    static /* synthetic */ FastMath$Split access$500(FastMath$Split fastMath$Split, long l2) {
        return fastMath$Split.pow(l2);
    }

    static /* synthetic */ double access$600(FastMath$Split fastMath$Split) {
        return fastMath$Split.full;
    }
}

