/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.util;

import ia.sh.org.apache.commons.math3.exception.MathArithmeticException;
import ia.sh.org.apache.commons.math3.exception.NotPositiveException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.util.CombinatoricsUtils;
import ia.sh.org.apache.commons.math3.util.FastMath;
import java.math.BigInteger;

public final class ArithmeticUtils {
    private ArithmeticUtils() {
    }

    public static int addAndCheck(int n2, int n3) {
        long l2 = (long)n2 + (long)n3;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, n2, n3);
        }
        return (int)l2;
    }

    public static long addAndCheck(long l2, long l3) {
        return ArithmeticUtils.addAndCheck(l2, l3, LocalizedFormats.OVERFLOW_IN_ADDITION);
    }

    @Deprecated
    public static long binomialCoefficient(int n2, int n3) {
        return CombinatoricsUtils.binomialCoefficient(n2, n3);
    }

    @Deprecated
    public static double binomialCoefficientDouble(int n2, int n3) {
        return CombinatoricsUtils.binomialCoefficientDouble(n2, n3);
    }

    @Deprecated
    public static double binomialCoefficientLog(int n2, int n3) {
        return CombinatoricsUtils.binomialCoefficientLog(n2, n3);
    }

    @Deprecated
    public static long factorial(int n2) {
        return CombinatoricsUtils.factorial(n2);
    }

    @Deprecated
    public static double factorialDouble(int n2) {
        return CombinatoricsUtils.factorialDouble(n2);
    }

    @Deprecated
    public static double factorialLog(int n2) {
        return CombinatoricsUtils.factorialLog(n2);
    }

    public static int gcd(int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        if (n4 == 0 || n5 == 0) {
            if (n4 == Integer.MIN_VALUE || n5 == Integer.MIN_VALUE) {
                throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_32_BITS, n2, n3);
            }
            return FastMath.abs(n4 + n5);
        }
        long l2 = n4;
        long l3 = n5;
        boolean bl2 = false;
        if (n4 < 0) {
            if (Integer.MIN_VALUE == n4) {
                bl2 = true;
            } else {
                n4 = -n4;
            }
            l2 = -l2;
        }
        if (n5 < 0) {
            if (Integer.MIN_VALUE == n5) {
                bl2 = true;
            } else {
                n5 = -n5;
            }
            l3 = -l3;
        }
        if (bl2) {
            if (l2 == l3) {
                throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_32_BITS, n2, n3);
            }
            long l4 = l3;
            l3 = l2;
            if ((l2 = l4 % l2) == 0L) {
                if (l3 > Integer.MAX_VALUE) {
                    throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_32_BITS, n2, n3);
                }
                return (int)l3;
            }
            l4 = l3;
            n5 = (int)l2;
            n4 = (int)(l4 % l2);
        }
        return ArithmeticUtils.gcdPositive(n4, n5);
    }

    private static int gcdPositive(int n2, int n3) {
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        int n4 = Integer.numberOfTrailingZeros(n2);
        n2 >>= n4;
        int n5 = Integer.numberOfTrailingZeros(n3);
        n3 >>= n5;
        int n6 = FastMath.min(n4, n5);
        while (n2 != n3) {
            int n7 = n2 - n3;
            n3 = Math.min(n2, n3);
            n2 = Math.abs(n7);
            n2 >>= Integer.numberOfTrailingZeros(n2);
        }
        return n2 << n6;
    }

    public static long gcd(long l2, long l3) {
        long l4;
        int n2;
        long l5 = l2;
        long l6 = l3;
        if (l5 == 0L || l6 == 0L) {
            if (l5 == Long.MIN_VALUE || l6 == Long.MIN_VALUE) {
                throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_64_BITS, l2, l3);
            }
            return FastMath.abs(l5) + FastMath.abs(l6);
        }
        if (l5 > 0L) {
            l5 = -l5;
        }
        if (l6 > 0L) {
            l6 = -l6;
        }
        for (n2 = 0; (l5 & 1L) == 0L && (l6 & 1L) == 0L && n2 < 63; ++n2) {
            l5 /= 2L;
            l6 /= 2L;
        }
        if (n2 == 63) {
            throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_64_BITS, l2, l3);
        }
        long l7 = l4 = (l5 & 1L) == 1L ? l6 : -(l5 / 2L);
        while (true) {
            if ((l4 & 1L) == 0L) {
                l4 /= 2L;
                continue;
            }
            if (l4 > 0L) {
                l5 = -l4;
            } else {
                l6 = l4;
            }
            if ((l4 = (l6 - l5) / 2L) == 0L) break;
        }
        return -l5 * (1L << n2);
    }

    public static int lcm(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return 0;
        }
        int n4 = FastMath.abs(ArithmeticUtils.mulAndCheck(n2 / ArithmeticUtils.gcd(n2, n3), n3));
        if (n4 == Integer.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.LCM_OVERFLOW_32_BITS, n2, n3);
        }
        return n4;
    }

    public static long lcm(long l2, long l3) {
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        long l4 = FastMath.abs(ArithmeticUtils.mulAndCheck(l2 / ArithmeticUtils.gcd(l2, l3), l3));
        if (l4 == Long.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.LCM_OVERFLOW_64_BITS, l2, l3);
        }
        return l4;
    }

    public static int mulAndCheck(int n2, int n3) {
        long l2 = (long)n2 * (long)n3;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new MathArithmeticException();
        }
        return (int)l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long mulAndCheck(long l2, long l3) {
        if (l2 > l3) {
            return ArithmeticUtils.mulAndCheck(l3, l2);
        }
        if (l2 < 0L) {
            if (l3 < 0L) {
                if (l2 < Long.MAX_VALUE / l3) throw new MathArithmeticException();
                return l2 * l3;
            }
            if (l3 <= 0L) return 0L;
            if (Long.MIN_VALUE / l3 > l2) throw new MathArithmeticException();
            return l2 * l3;
        }
        if (l2 <= 0L) return 0L;
        if (l2 > Long.MAX_VALUE / l3) throw new MathArithmeticException();
        return l2 * l3;
    }

    public static int subAndCheck(int n2, int n3) {
        long l2 = (long)n2 - (long)n3;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_SUBTRACTION, n2, n3);
        }
        return (int)l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long subAndCheck(long l2, long l3) {
        if (l3 != Long.MIN_VALUE) return ArithmeticUtils.addAndCheck(l2, -l3, LocalizedFormats.OVERFLOW_IN_ADDITION);
        if (l2 >= 0L) throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, l2, -l3);
        return l2 - l3;
    }

    public static int pow(int n2, int n3) {
        if (n3 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, n3);
        }
        try {
            int n4 = n3;
            int n5 = 1;
            int n6 = n2;
            while (true) {
                if ((n4 & 1) != 0) {
                    n5 = ArithmeticUtils.mulAndCheck(n5, n6);
                }
                if ((n4 >>= 1) == 0) break;
                n6 = ArithmeticUtils.mulAndCheck(n6, n6);
            }
            return n5;
        }
        catch (MathArithmeticException mathArithmeticException) {
            mathArithmeticException.getContext().addMessage(LocalizedFormats.OVERFLOW, new Object[0]);
            mathArithmeticException.getContext().addMessage(LocalizedFormats.BASE, n2);
            mathArithmeticException.getContext().addMessage(LocalizedFormats.EXPONENT, n3);
            throw mathArithmeticException;
        }
    }

    @Deprecated
    public static int pow(int n2, long l2) {
        if (l2 < 0L) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, l2);
        }
        int n3 = 1;
        int n4 = n2;
        while (l2 != 0L) {
            if ((l2 & 1L) != 0L) {
                n3 *= n4;
            }
            n4 *= n4;
            l2 >>= 1;
        }
        return n3;
    }

    public static long pow(long l2, int n2) {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, n2);
        }
        try {
            int n3 = n2;
            long l3 = 1L;
            long l4 = l2;
            while (true) {
                if ((n3 & 1) != 0) {
                    l3 = ArithmeticUtils.mulAndCheck(l3, l4);
                }
                if ((n3 >>= 1) == 0) break;
                l4 = ArithmeticUtils.mulAndCheck(l4, l4);
            }
            return l3;
        }
        catch (MathArithmeticException mathArithmeticException) {
            mathArithmeticException.getContext().addMessage(LocalizedFormats.OVERFLOW, new Object[0]);
            mathArithmeticException.getContext().addMessage(LocalizedFormats.BASE, l2);
            mathArithmeticException.getContext().addMessage(LocalizedFormats.EXPONENT, n2);
            throw mathArithmeticException;
        }
    }

    @Deprecated
    public static long pow(long l2, long l3) {
        if (l3 < 0L) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, l3);
        }
        long l4 = 1L;
        long l5 = l2;
        while (l3 != 0L) {
            if ((l3 & 1L) != 0L) {
                l4 *= l5;
            }
            l5 *= l5;
            l3 >>= 1;
        }
        return l4;
    }

    public static BigInteger pow(BigInteger bigInteger, int n2) {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, n2);
        }
        return bigInteger.pow(n2);
    }

    public static BigInteger pow(BigInteger bigInteger, long l2) {
        if (l2 < 0L) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, l2);
        }
        BigInteger bigInteger2 = BigInteger.ONE;
        BigInteger bigInteger3 = bigInteger;
        while (l2 != 0L) {
            if ((l2 & 1L) != 0L) {
                bigInteger2 = bigInteger2.multiply(bigInteger3);
            }
            bigInteger3 = bigInteger3.multiply(bigInteger3);
            l2 >>= 1;
        }
        return bigInteger2;
    }

    public static BigInteger pow(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.compareTo(BigInteger.ZERO) < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, bigInteger2);
        }
        BigInteger bigInteger3 = BigInteger.ONE;
        BigInteger bigInteger4 = bigInteger;
        while (!BigInteger.ZERO.equals(bigInteger2)) {
            if (bigInteger2.testBit(0)) {
                bigInteger3 = bigInteger3.multiply(bigInteger4);
            }
            bigInteger4 = bigInteger4.multiply(bigInteger4);
            bigInteger2 = bigInteger2.shiftRight(1);
        }
        return bigInteger3;
    }

    @Deprecated
    public static long stirlingS2(int n2, int n3) {
        return CombinatoricsUtils.stirlingS2(n2, n3);
    }

    private static long addAndCheck(long l2, long l3, Localizable localizable) {
        long l4;
        if (!((l2 ^ l3) < 0L | (l2 ^ (l4 = l2 + l3)) >= 0L)) {
            throw new MathArithmeticException(localizable, l2, l3);
        }
        return l4;
    }

    public static boolean isPowerOfTwo(long l2) {
        return l2 > 0L && (l2 & l2 - 1L) == 0L;
    }
}

