/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.special;

import ia.sh.org.apache.commons.math3.special.Gamma;
import ia.sh.org.apache.commons.math3.util.FastMath;

public class Erf {
    private static final double X_CRIT = 0.4769362762044697;

    private Erf() {
    }

    public static double erf(double d2) {
        if (FastMath.abs(d2) > 40.0) {
            return d2 > 0.0 ? 1.0 : -1.0;
        }
        double d3 = Gamma.regularizedGammaP(0.5, d2 * d2, 1.0E-15, 10000);
        return d2 < 0.0 ? -d3 : d3;
    }

    public static double erfc(double d2) {
        if (FastMath.abs(d2) > 40.0) {
            return d2 > 0.0 ? 0.0 : 2.0;
        }
        double d3 = Gamma.regularizedGammaQ(0.5, d2 * d2, 1.0E-15, 10000);
        return d2 < 0.0 ? 2.0 - d3 : d3;
    }

    public static double erf(double d2, double d3) {
        if (d2 > d3) {
            return -Erf.erf(d3, d2);
        }
        return d2 < -0.4769362762044697 ? (d3 < 0.0 ? Erf.erfc(-d3) - Erf.erfc(-d2) : Erf.erf(d3) - Erf.erf(d2)) : (d3 > 0.4769362762044697 && d2 > 0.0 ? Erf.erfc(d2) - Erf.erfc(d3) : Erf.erf(d3) - Erf.erf(d2));
    }

    public static double erfInv(double d2) {
        double d3;
        double d4 = -FastMath.log((1.0 - d2) * (1.0 + d2));
        if (d4 < 6.25) {
            d3 = -3.64441206401782E-21;
            d3 = -1.6850591381820166E-19 + d3 * (d4 -= 3.125);
            d3 = 1.28584807152564E-18 + d3 * d4;
            d3 = 1.1157877678025181E-17 + d3 * d4;
            d3 = -1.333171662854621E-16 + d3 * d4;
            d3 = 2.0972767875968562E-17 + d3 * d4;
            d3 = 6.637638134358324E-15 + d3 * d4;
            d3 = -4.054566272975207E-14 + d3 * d4;
            d3 = -8.151934197605472E-14 + d3 * d4;
            d3 = 2.6335093153082323E-12 + d3 * d4;
            d3 = -1.2975133253453532E-11 + d3 * d4;
            d3 = -5.415412054294628E-11 + d3 * d4;
            d3 = 1.0512122733215323E-9 + d3 * d4;
            d3 = -4.112633980346984E-9 + d3 * d4;
            d3 = -2.9070369957882005E-8 + d3 * d4;
            d3 = 4.2347877827932404E-7 + d3 * d4;
            d3 = -1.3654692000834679E-6 + d3 * d4;
            d3 = -1.3882523362786469E-5 + d3 * d4;
            d3 = 1.8673420803405714E-4 + d3 * d4;
            d3 = -7.40702534166267E-4 + d3 * d4;
            d3 = -0.006033670871430149 + d3 * d4;
            d3 = 0.24015818242558962 + d3 * d4;
            d3 = 1.6536545626831027 + d3 * d4;
        } else if (d4 < 16.0) {
            d4 = FastMath.sqrt(d4) - 3.25;
            d3 = 2.2137376921775787E-9;
            d3 = 9.075656193888539E-8 + d3 * d4;
            d3 = -2.7517406297064545E-7 + d3 * d4;
            d3 = 1.8239629214389228E-8 + d3 * d4;
            d3 = 1.5027403968909828E-6 + d3 * d4;
            d3 = -4.013867526981546E-6 + d3 * d4;
            d3 = 2.9234449089955446E-6 + d3 * d4;
            d3 = 1.2475304481671779E-5 + d3 * d4;
            d3 = -4.7318229009055734E-5 + d3 * d4;
            d3 = 6.828485145957318E-5 + d3 * d4;
            d3 = 2.4031110387097894E-5 + d3 * d4;
            d3 = -3.550375203628475E-4 + d3 * d4;
            d3 = 9.532893797373805E-4 + d3 * d4;
            d3 = -0.0016882755560235047 + d3 * d4;
            d3 = 0.002491442096107851 + d3 * d4;
            d3 = -0.003751208507569241 + d3 * d4;
            d3 = 0.005370914553590064 + d3 * d4;
            d3 = 1.0052589676941592 + d3 * d4;
            d3 = 3.0838856104922208 + d3 * d4;
        } else if (!Double.isInfinite(d4)) {
            d4 = FastMath.sqrt(d4) - 5.0;
            d3 = -2.7109920616438573E-11;
            d3 = -2.555641816996525E-10 + d3 * d4;
            d3 = 1.5076572693500548E-9 + d3 * d4;
            d3 = -3.789465440126737E-9 + d3 * d4;
            d3 = 7.61570120807834E-9 + d3 * d4;
            d3 = -1.496002662714924E-8 + d3 * d4;
            d3 = 2.914795345090108E-8 + d3 * d4;
            d3 = -6.771199775845234E-8 + d3 * d4;
            d3 = 2.2900482228026655E-7 + d3 * d4;
            d3 = -9.9298272942317E-7 + d3 * d4;
            d3 = 4.526062597223154E-6 + d3 * d4;
            d3 = -1.968177810553167E-5 + d3 * d4;
            d3 = 7.599527703001776E-5 + d3 * d4;
            d3 = -2.1503011930044477E-4 + d3 * d4;
            d3 = -1.3871931833623122E-4 + d3 * d4;
            d3 = 1.0103004648645344 + d3 * d4;
            d3 = 4.849906401408584 + d3 * d4;
        } else {
            d3 = Double.POSITIVE_INFINITY;
        }
        return d3 * d2;
    }

    public static double erfcInv(double d2) {
        return Erf.erfInv(1.0 - d2);
    }
}

