/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.random;

import ia.sh.org.apache.commons.math3.distribution.BetaDistribution;
import ia.sh.org.apache.commons.math3.distribution.BinomialDistribution;
import ia.sh.org.apache.commons.math3.distribution.CauchyDistribution;
import ia.sh.org.apache.commons.math3.distribution.ChiSquaredDistribution;
import ia.sh.org.apache.commons.math3.distribution.ExponentialDistribution;
import ia.sh.org.apache.commons.math3.distribution.FDistribution;
import ia.sh.org.apache.commons.math3.distribution.GammaDistribution;
import ia.sh.org.apache.commons.math3.distribution.HypergeometricDistribution;
import ia.sh.org.apache.commons.math3.distribution.PascalDistribution;
import ia.sh.org.apache.commons.math3.distribution.PoissonDistribution;
import ia.sh.org.apache.commons.math3.distribution.TDistribution;
import ia.sh.org.apache.commons.math3.distribution.UniformIntegerDistribution;
import ia.sh.org.apache.commons.math3.distribution.WeibullDistribution;
import ia.sh.org.apache.commons.math3.distribution.ZipfDistribution;
import ia.sh.org.apache.commons.math3.exception.MathInternalError;
import ia.sh.org.apache.commons.math3.exception.NotANumberException;
import ia.sh.org.apache.commons.math3.exception.NotFiniteNumberException;
import ia.sh.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import ia.sh.org.apache.commons.math3.exception.NumberIsTooLargeException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.random.RandomData;
import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.random.RandomGeneratorFactory;
import ia.sh.org.apache.commons.math3.random.Well19937c;
import ia.sh.org.apache.commons.math3.util.MathArrays;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;

public class RandomDataGenerator
implements RandomData,
Serializable {
    private static final long serialVersionUID = -626730818244969716L;
    private RandomGenerator rand = null;
    private RandomGenerator secRand = null;

    public RandomDataGenerator() {
    }

    public RandomDataGenerator(RandomGenerator randomGenerator) {
        this.rand = randomGenerator;
    }

    public String nextHexString(int n2) {
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, n2);
        }
        RandomGenerator randomGenerator = this.getRandomGenerator();
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[n2 / 2 + 1];
        randomGenerator.nextBytes(byArray);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            Integer n3 = byArray[i2];
            String string = Integer.toHexString(n3 + 128);
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString().substring(0, n2);
    }

    public int nextInt(int n2, int n3) {
        return new UniformIntegerDistribution(this.getRandomGenerator(), n2, n3).sample();
    }

    public long nextLong(long l2, long l3) {
        if (l2 >= l3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)l2, l3, false);
        }
        long l4 = l3 - l2 + 1L;
        if (l4 <= 0L) {
            long l5;
            RandomGenerator randomGenerator = this.getRandomGenerator();
            while ((l5 = randomGenerator.nextLong()) < l2 || l5 > l3) {
            }
            return l5;
        }
        if (l4 < Integer.MAX_VALUE) {
            return l2 + (long)this.getRandomGenerator().nextInt((int)l4);
        }
        return l2 + RandomDataGenerator.nextLong(this.getRandomGenerator(), l4);
    }

    private static long nextLong(RandomGenerator randomGenerator, long l2) {
        if (l2 > 0L) {
            long l3;
            long l4;
            byte[] byArray = new byte[8];
            do {
                randomGenerator.nextBytes(byArray);
                l3 = 0L;
                for (byte by2 : byArray) {
                    l3 = l3 << 8 | (long)by2 & 0xFFL;
                }
            } while ((l3 &= Long.MAX_VALUE) - (l4 = l3 % l2) + (l2 - 1L) < 0L);
            return l4;
        }
        throw new NotStrictlyPositiveException(l2);
    }

    public String nextSecureHexString(int n2) {
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, n2);
        }
        RandomGenerator randomGenerator = this.getSecRan();
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MathInternalError(noSuchAlgorithmException);
        }
        messageDigest.reset();
        int n3 = n2 / 40 + 1;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 1; i2 < n3 + 1; ++i2) {
            byte[] byArray = new byte[40];
            randomGenerator.nextBytes(byArray);
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                Integer n4 = byArray2[i3];
                String string = Integer.toHexString(n4 + 128);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString().substring(0, n2);
    }

    public int nextSecureInt(int n2, int n3) {
        return new UniformIntegerDistribution(this.getSecRan(), n2, n3).sample();
    }

    public long nextSecureLong(long l2, long l3) {
        if (l2 >= l3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)l2, l3, false);
        }
        RandomGenerator randomGenerator = this.getSecRan();
        long l4 = l3 - l2 + 1L;
        if (l4 <= 0L) {
            long l5;
            while ((l5 = randomGenerator.nextLong()) < l2 || l5 > l3) {
            }
            return l5;
        }
        if (l4 < Integer.MAX_VALUE) {
            return l2 + (long)randomGenerator.nextInt((int)l4);
        }
        return l2 + RandomDataGenerator.nextLong(randomGenerator, l4);
    }

    public long nextPoisson(double d2) {
        return new PoissonDistribution(this.getRandomGenerator(), d2, 1.0E-12, 10000000).sample();
    }

    public double nextGaussian(double d2, double d3) {
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.STANDARD_DEVIATION, d3);
        }
        return d3 * this.getRandomGenerator().nextGaussian() + d2;
    }

    public double nextExponential(double d2) {
        return new ExponentialDistribution(this.getRandomGenerator(), d2, 1.0E-9).sample();
    }

    public double nextGamma(double d2, double d3) {
        return new GammaDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9).sample();
    }

    public int nextHypergeometric(int n2, int n3, int n4) {
        return new HypergeometricDistribution(this.getRandomGenerator(), n2, n3, n4).sample();
    }

    public int nextPascal(int n2, double d2) {
        return new PascalDistribution(this.getRandomGenerator(), n2, d2).sample();
    }

    public double nextT(double d2) {
        return new TDistribution(this.getRandomGenerator(), d2, 1.0E-9).sample();
    }

    public double nextWeibull(double d2, double d3) {
        return new WeibullDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9).sample();
    }

    public int nextZipf(int n2, double d2) {
        return new ZipfDistribution(this.getRandomGenerator(), n2, d2).sample();
    }

    public double nextBeta(double d2, double d3) {
        return new BetaDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9).sample();
    }

    public int nextBinomial(int n2, double d2) {
        return new BinomialDistribution(this.getRandomGenerator(), n2, d2).sample();
    }

    public double nextCauchy(double d2, double d3) {
        return new CauchyDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9).sample();
    }

    public double nextChiSquare(double d2) {
        return new ChiSquaredDistribution(this.getRandomGenerator(), d2, 1.0E-9).sample();
    }

    public double nextF(double d2, double d3) {
        return new FDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9).sample();
    }

    public double nextUniform(double d2, double d3) {
        return this.nextUniform(d2, d3, false);
    }

    public double nextUniform(double d2, double d3, boolean bl2) {
        if (d2 >= d3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)d2, d3, false);
        }
        if (Double.isInfinite(d2)) {
            throw new NotFiniteNumberException((Localizable)LocalizedFormats.INFINITE_BOUND, d2, new Object[0]);
        }
        if (Double.isInfinite(d3)) {
            throw new NotFiniteNumberException((Localizable)LocalizedFormats.INFINITE_BOUND, d3, new Object[0]);
        }
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            throw new NotANumberException();
        }
        RandomGenerator randomGenerator = this.getRandomGenerator();
        double d4 = randomGenerator.nextDouble();
        while (!bl2 && d4 <= 0.0) {
            d4 = randomGenerator.nextDouble();
        }
        return d4 * d3 + (1.0 - d4) * d2;
    }

    public int[] nextPermutation(int n2, int n3) {
        if (n3 > n2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.PERMUTATION_EXCEEDS_N, (Number)n3, n2, true);
        }
        if (n3 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.PERMUTATION_SIZE, n3);
        }
        int[] nArray = MathArrays.natural(n2);
        MathArrays.shuffle(nArray, this.getRandomGenerator());
        return MathArrays.copyOf(nArray, n3);
    }

    public Object[] nextSample(Collection collection, int n2) {
        int n3 = collection.size();
        if (n2 > n3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SAMPLE_SIZE_EXCEEDS_COLLECTION_SIZE, (Number)n2, n3, true);
        }
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n2);
        }
        Object[] objectArray = collection.toArray();
        int[] nArray = this.nextPermutation(n3, n2);
        Object[] objectArray2 = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray2[i2] = objectArray[nArray[i2]];
        }
        return objectArray2;
    }

    public void reSeed(long l2) {
        this.getRandomGenerator().setSeed(l2);
    }

    public void reSeedSecure() {
        this.getSecRan().setSeed(System.currentTimeMillis());
    }

    public void reSeedSecure(long l2) {
        this.getSecRan().setSeed(l2);
    }

    public void reSeed() {
        this.getRandomGenerator().setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    public void setSecureAlgorithm(String string, String string2) {
        this.secRand = RandomGeneratorFactory.createRandomGenerator(SecureRandom.getInstance(string, string2));
    }

    public RandomGenerator getRandomGenerator() {
        if (this.rand == null) {
            this.initRan();
        }
        return this.rand;
    }

    private void initRan() {
        this.rand = new Well19937c(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    private RandomGenerator getSecRan() {
        if (this.secRand == null) {
            this.secRand = RandomGeneratorFactory.createRandomGenerator(new SecureRandom());
            this.secRand.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
        }
        return this.secRand;
    }
}

