/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.geometry.euclidean.threed;

import ia.sh.org.apache.commons.math3.exception.MathParseException;
import ia.sh.org.apache.commons.math3.geometry.Vector;
import ia.sh.org.apache.commons.math3.geometry.VectorFormat;
import ia.sh.org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import ia.sh.org.apache.commons.math3.util.CompositeFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class Vector3DFormat
extends VectorFormat {
    public Vector3DFormat() {
        super("{", "}", "; ", CompositeFormat.getDefaultNumberFormat());
    }

    public Vector3DFormat(NumberFormat numberFormat) {
        super("{", "}", "; ", numberFormat);
    }

    public Vector3DFormat(String string, String string2, String string3) {
        super(string, string2, string3, CompositeFormat.getDefaultNumberFormat());
    }

    public Vector3DFormat(String string, String string2, String string3, NumberFormat numberFormat) {
        super(string, string2, string3, numberFormat);
    }

    public static Vector3DFormat getInstance() {
        return Vector3DFormat.getInstance(Locale.getDefault());
    }

    public static Vector3DFormat getInstance(Locale locale) {
        return new Vector3DFormat(CompositeFormat.getDefaultNumberFormat(locale));
    }

    public StringBuffer format(Vector vector, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Vector3D vector3D = (Vector3D)vector;
        return this.format(stringBuffer, fieldPosition, vector3D.getX(), vector3D.getY(), vector3D.getZ());
    }

    public Vector3D parse(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        Vector3D vector3D = this.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new MathParseException(string, parsePosition.getErrorIndex(), Vector3D.class);
        }
        return vector3D;
    }

    public Vector3D parse(String string, ParsePosition parsePosition) {
        double[] dArray = this.parseCoordinates(3, string, parsePosition);
        if (dArray == null) {
            return null;
        }
        return new Vector3D(dArray[0], dArray[1], dArray[2]);
    }
}

