/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.distribution;

import ia.sh.org.apache.commons.math3.distribution.AbstractRealDistribution;
import ia.sh.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import ia.sh.org.apache.commons.math3.exception.OutOfRangeException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.random.Well19937c;
import ia.sh.org.apache.commons.math3.special.Gamma;
import ia.sh.org.apache.commons.math3.util.FastMath;

public class WeibullDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private final double shape;
    private final double scale;
    private final double solverAbsoluteAccuracy;
    private double numericalMean = Double.NaN;
    private boolean numericalMeanIsCalculated = false;
    private double numericalVariance = Double.NaN;
    private boolean numericalVarianceIsCalculated = false;

    public WeibullDistribution(double d2, double d3) {
        this(d2, d3, 1.0E-9);
    }

    public WeibullDistribution(double d2, double d3, double d4) {
        this(new Well19937c(), d2, d3, d4);
    }

    public WeibullDistribution(RandomGenerator randomGenerator, double d2, double d3) {
        this(randomGenerator, d2, d3, 1.0E-9);
    }

    public WeibullDistribution(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SHAPE, d2);
        }
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SCALE, d3);
        }
        this.scale = d3;
        this.shape = d2;
        this.solverAbsoluteAccuracy = d4;
    }

    public double getShape() {
        return this.shape;
    }

    public double getScale() {
        return this.scale;
    }

    public double density(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        double d3 = d2 / this.scale;
        double d4 = FastMath.pow(d3, this.shape - 1.0);
        double d5 = d4 * d3;
        return this.shape / this.scale * d4 * FastMath.exp(-d5);
    }

    public double logDensity(double d2) {
        if (d2 < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d3 = d2 / this.scale;
        double d4 = FastMath.log(d3) * (this.shape - 1.0);
        double d5 = FastMath.exp(d4) * d3;
        return FastMath.log(this.shape / this.scale) + d4 - d5;
    }

    public double cumulativeProbability(double d2) {
        double d3 = d2 <= 0.0 ? 0.0 : 1.0 - FastMath.exp(-FastMath.pow(d2 / this.scale, this.shape));
        return d3;
    }

    public double inverseCumulativeProbability(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0.0, 1.0);
        }
        double d3 = d2 == 0.0 ? 0.0 : (d2 == 1.0 ? Double.POSITIVE_INFINITY : this.scale * FastMath.pow(-FastMath.log1p(-d2), 1.0 / this.shape));
        return d3;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getNumericalMean() {
        if (!this.numericalMeanIsCalculated) {
            this.numericalMean = this.calculateNumericalMean();
            this.numericalMeanIsCalculated = true;
        }
        return this.numericalMean;
    }

    protected double calculateNumericalMean() {
        double d2 = this.getShape();
        double d3 = this.getScale();
        return d3 * FastMath.exp(Gamma.logGamma(1.0 + 1.0 / d2));
    }

    public double getNumericalVariance() {
        if (!this.numericalVarianceIsCalculated) {
            this.numericalVariance = this.calculateNumericalVariance();
            this.numericalVarianceIsCalculated = true;
        }
        return this.numericalVariance;
    }

    protected double calculateNumericalVariance() {
        double d2 = this.getShape();
        double d3 = this.getScale();
        double d4 = this.getNumericalMean();
        return d3 * d3 * FastMath.exp(Gamma.logGamma(1.0 + 2.0 / d2)) - d4 * d4;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

