/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.distribution;

import ia.sh.org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import ia.sh.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import ia.sh.org.apache.commons.math3.exception.OutOfRangeException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.random.Well19937c;
import ia.sh.org.apache.commons.math3.special.Beta;
import ia.sh.org.apache.commons.math3.util.CombinatoricsUtils;
import ia.sh.org.apache.commons.math3.util.FastMath;

public class PascalDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 6751309484392813623L;
    private final int numberOfSuccesses;
    private final double probabilityOfSuccess;
    private final double logProbabilityOfSuccess;
    private final double log1mProbabilityOfSuccess;

    public PascalDistribution(int n2, double d2) {
        this(new Well19937c(), n2, d2);
    }

    public PascalDistribution(RandomGenerator randomGenerator, int n2, double d2) {
        super(randomGenerator);
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESSES, n2);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        this.numberOfSuccesses = n2;
        this.probabilityOfSuccess = d2;
        this.logProbabilityOfSuccess = FastMath.log(d2);
        this.log1mProbabilityOfSuccess = FastMath.log1p(-d2);
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public double probability(int n2) {
        double d2 = n2 < 0 ? 0.0 : CombinatoricsUtils.binomialCoefficientDouble(n2 + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) * FastMath.pow(this.probabilityOfSuccess, this.numberOfSuccesses) * FastMath.pow(1.0 - this.probabilityOfSuccess, n2);
        return d2;
    }

    public double logProbability(int n2) {
        double d2 = n2 < 0 ? Double.NEGATIVE_INFINITY : CombinatoricsUtils.binomialCoefficientLog(n2 + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) + this.logProbabilityOfSuccess * (double)this.numberOfSuccesses + this.log1mProbabilityOfSuccess * (double)n2;
        return d2;
    }

    public double cumulativeProbability(int n2) {
        double d2 = n2 < 0 ? 0.0 : Beta.regularizedBeta(this.probabilityOfSuccess, this.numberOfSuccesses, (double)n2 + 1.0);
        return d2;
    }

    public double getNumericalMean() {
        double d2 = this.getProbabilityOfSuccess();
        double d3 = this.getNumberOfSuccesses();
        return d3 * (1.0 - d2) / d2;
    }

    public double getNumericalVariance() {
        double d2 = this.getProbabilityOfSuccess();
        double d3 = this.getNumberOfSuccesses();
        return d3 * (1.0 - d2) / (d2 * d2);
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

