/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.distribution;

import ia.sh.org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import ia.sh.org.apache.commons.math3.distribution.SaddlePointExpansion;
import ia.sh.org.apache.commons.math3.exception.NotPositiveException;
import ia.sh.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import ia.sh.org.apache.commons.math3.exception.NumberIsTooLargeException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.random.Well19937c;
import ia.sh.org.apache.commons.math3.util.FastMath;

public class HypergeometricDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = -436928820673516179L;
    private final int numberOfSuccesses;
    private final int populationSize;
    private final int sampleSize;
    private double numericalVariance = Double.NaN;
    private boolean numericalVarianceIsCalculated = false;

    public HypergeometricDistribution(int n2, int n3, int n4) {
        this(new Well19937c(), n2, n3, n4);
    }

    public HypergeometricDistribution(RandomGenerator randomGenerator, int n2, int n3, int n4) {
        super(randomGenerator);
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.POPULATION_SIZE, n2);
        }
        if (n3 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESSES, n3);
        }
        if (n4 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n4);
        }
        if (n3 > n2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESS_LARGER_THAN_POPULATION_SIZE, (Number)n3, n2, true);
        }
        if (n4 > n2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SAMPLE_SIZE_LARGER_THAN_POPULATION_SIZE, (Number)n4, n2, true);
        }
        this.numberOfSuccesses = n3;
        this.populationSize = n2;
        this.sampleSize = n4;
    }

    public double cumulativeProbability(int n2) {
        int[] nArray = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        double d2 = n2 < nArray[0] ? 0.0 : (n2 >= nArray[1] ? 1.0 : this.innerCumulativeProbability(nArray[0], n2, 1));
        return d2;
    }

    private int[] getDomain(int n2, int n3, int n4) {
        return new int[]{this.getLowerDomain(n2, n3, n4), this.getUpperDomain(n3, n4)};
    }

    private int getLowerDomain(int n2, int n3, int n4) {
        return FastMath.max(0, n3 - (n2 - n4));
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    private int getUpperDomain(int n2, int n3) {
        return FastMath.min(n3, n2);
    }

    public double probability(int n2) {
        double d2 = this.logProbability(n2);
        return d2 == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(d2);
    }

    public double logProbability(int n2) {
        double d2;
        int[] nArray = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        if (n2 < nArray[0] || n2 > nArray[1]) {
            d2 = Double.NEGATIVE_INFINITY;
        } else {
            double d3 = (double)this.sampleSize / (double)this.populationSize;
            double d4 = (double)(this.populationSize - this.sampleSize) / (double)this.populationSize;
            double d5 = SaddlePointExpansion.logBinomialProbability(n2, this.numberOfSuccesses, d3, d4);
            double d6 = SaddlePointExpansion.logBinomialProbability(this.sampleSize - n2, this.populationSize - this.numberOfSuccesses, d3, d4);
            double d7 = SaddlePointExpansion.logBinomialProbability(this.sampleSize, this.populationSize, d3, d4);
            d2 = d5 + d6 - d7;
        }
        return d2;
    }

    public double upperCumulativeProbability(int n2) {
        int[] nArray = this.getDomain(this.populationSize, this.numberOfSuccesses, this.sampleSize);
        double d2 = n2 <= nArray[0] ? 1.0 : (n2 > nArray[1] ? 0.0 : this.innerCumulativeProbability(nArray[1], n2, -1));
        return d2;
    }

    private double innerCumulativeProbability(int n2, int n3, int n4) {
        double d2 = this.probability(n2);
        while (n2 != n3) {
            d2 += this.probability(n2 += n4);
        }
        return d2;
    }

    public double getNumericalMean() {
        return (double)this.getSampleSize() * ((double)this.getNumberOfSuccesses() / (double)this.getPopulationSize());
    }

    public double getNumericalVariance() {
        if (!this.numericalVarianceIsCalculated) {
            this.numericalVariance = this.calculateNumericalVariance();
            this.numericalVarianceIsCalculated = true;
        }
        return this.numericalVariance;
    }

    protected double calculateNumericalVariance() {
        double d2 = this.getPopulationSize();
        double d3 = this.getNumberOfSuccesses();
        double d4 = this.getSampleSize();
        return d4 * d3 * (d2 - d4) * (d2 - d3) / (d2 * d2 * (d2 - 1.0));
    }

    public int getSupportLowerBound() {
        return FastMath.max(0, this.getSampleSize() + this.getNumberOfSuccesses() - this.getPopulationSize());
    }

    public int getSupportUpperBound() {
        return FastMath.min(this.getNumberOfSuccesses(), this.getSampleSize());
    }

    public boolean isSupportConnected() {
        return true;
    }
}

