/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.distribution;

import ia.sh.org.apache.commons.math3.distribution.AbstractRealDistribution;
import ia.sh.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.random.Well19937c;
import ia.sh.org.apache.commons.math3.special.Beta;
import ia.sh.org.apache.commons.math3.util.FastMath;

public class FDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -8516354193418641566L;
    private final double numeratorDegreesOfFreedom;
    private final double denominatorDegreesOfFreedom;
    private final double solverAbsoluteAccuracy;
    private double numericalVariance = Double.NaN;
    private boolean numericalVarianceIsCalculated = false;

    public FDistribution(double d2, double d3) {
        this(d2, d3, 1.0E-9);
    }

    public FDistribution(double d2, double d3, double d4) {
        this(new Well19937c(), d2, d3, d4);
    }

    public FDistribution(RandomGenerator randomGenerator, double d2, double d3) {
        this(randomGenerator, d2, d3, 1.0E-9);
    }

    public FDistribution(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DEGREES_OF_FREEDOM, d2);
        }
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DEGREES_OF_FREEDOM, d3);
        }
        this.numeratorDegreesOfFreedom = d2;
        this.denominatorDegreesOfFreedom = d3;
        this.solverAbsoluteAccuracy = d4;
    }

    public double density(double d2) {
        return FastMath.exp(this.logDensity(d2));
    }

    public double logDensity(double d2) {
        double d3 = this.numeratorDegreesOfFreedom / 2.0;
        double d4 = this.denominatorDegreesOfFreedom / 2.0;
        double d5 = FastMath.log(d2);
        double d6 = FastMath.log(this.numeratorDegreesOfFreedom);
        double d7 = FastMath.log(this.denominatorDegreesOfFreedom);
        double d8 = FastMath.log(this.numeratorDegreesOfFreedom * d2 + this.denominatorDegreesOfFreedom);
        return d3 * d6 + d3 * d5 - d5 + d4 * d7 - d3 * d8 - d4 * d8 - Beta.logBeta(d3, d4);
    }

    public double cumulativeProbability(double d2) {
        double d3;
        if (d2 <= 0.0) {
            d3 = 0.0;
        } else {
            double d4 = this.numeratorDegreesOfFreedom;
            double d5 = this.denominatorDegreesOfFreedom;
            d3 = Beta.regularizedBeta(d4 * d2 / (d5 + d4 * d2), 0.5 * d4, 0.5 * d5);
        }
        return d3;
    }

    public double getNumeratorDegreesOfFreedom() {
        return this.numeratorDegreesOfFreedom;
    }

    public double getDenominatorDegreesOfFreedom() {
        return this.denominatorDegreesOfFreedom;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getNumericalMean() {
        double d2 = this.getDenominatorDegreesOfFreedom();
        if (d2 > 2.0) {
            return d2 / (d2 - 2.0);
        }
        return Double.NaN;
    }

    public double getNumericalVariance() {
        if (!this.numericalVarianceIsCalculated) {
            this.numericalVariance = this.calculateNumericalVariance();
            this.numericalVarianceIsCalculated = true;
        }
        return this.numericalVariance;
    }

    protected double calculateNumericalVariance() {
        double d2 = this.getDenominatorDegreesOfFreedom();
        if (d2 > 4.0) {
            double d3 = this.getNumeratorDegreesOfFreedom();
            double d4 = d2 - 2.0;
            return 2.0 * (d2 * d2) * (d3 + d2 - 2.0) / (d3 * (d4 * d4) * (d2 - 4.0));
        }
        return Double.NaN;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

