/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.io.protostuff;

import ia.sh.io.protostuff.ByteString;
import ia.sh.io.protostuff.LinkedBuffer;
import ia.sh.io.protostuff.WriteSession;

public final class B64Code {
    static final byte pad = 61;
    static final byte[] nibble2code;
    static final byte[] code2nibble;

    private B64Code() {
    }

    public static byte[] encode(byte[] byArray) {
        return B64Code.encode(byArray, 0, byArray.length);
    }

    public static byte[] encode(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[(n3 + 2) / 3 * 4];
        B64Code.encode(byArray, n2, n3, byArray2, 0);
        return byArray2;
    }

    public static char[] cencode(byte[] byArray) {
        return B64Code.cencode(byArray, 0, byArray.length);
    }

    public static char[] cencode(byte[] byArray, int n2, int n3) {
        char[] cArray = new char[(n3 + 2) / 3 * 4];
        B64Code.cencode(byArray, n2, n3, cArray, 0);
        return cArray;
    }

    private static void encode(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte by2;
        byte by3;
        int n5 = n3 % 3;
        int n6 = n2 + (n3 - n5);
        while (n2 < n6) {
            by3 = byArray[n2++];
            by2 = byArray[n2++];
            byte by4 = byArray[n2++];
            byArray2[n4++] = nibble2code[by3 >>> 2 & 0x3F];
            byArray2[n4++] = nibble2code[by3 << 4 & 0x3F | by2 >>> 4 & 0xF];
            byArray2[n4++] = nibble2code[by2 << 2 & 0x3F | by4 >>> 6 & 3];
            byArray2[n4++] = nibble2code[by4 & 0x3F];
        }
        switch (n5) {
            case 0: {
                break;
            }
            case 1: {
                by3 = byArray[n2++];
                byArray2[n4++] = nibble2code[by3 >>> 2 & 0x3F];
                byArray2[n4++] = nibble2code[by3 << 4 & 0x3F];
                byArray2[n4++] = 61;
                byArray2[n4++] = 61;
                break;
            }
            case 2: {
                by3 = byArray[n2++];
                by2 = byArray[n2++];
                byArray2[n4++] = nibble2code[by3 >>> 2 & 0x3F];
                byArray2[n4++] = nibble2code[by3 << 4 & 0x3F | by2 >>> 4 & 0xF];
                byArray2[n4++] = nibble2code[by2 << 2 & 0x3F];
                byArray2[n4++] = 61;
                break;
            }
            default: {
                throw new IllegalStateException("should not happen");
            }
        }
    }

    private static void cencode(byte[] byArray, int n2, int n3, char[] cArray, int n4) {
        byte by2;
        byte by3;
        int n5 = n3 % 3;
        int n6 = n2 + (n3 - n5);
        while (n2 < n6) {
            by3 = byArray[n2++];
            by2 = byArray[n2++];
            byte by4 = byArray[n2++];
            cArray[n4++] = (char)nibble2code[by3 >>> 2 & 0x3F];
            cArray[n4++] = (char)nibble2code[by3 << 4 & 0x3F | by2 >>> 4 & 0xF];
            cArray[n4++] = (char)nibble2code[by2 << 2 & 0x3F | by4 >>> 6 & 3];
            cArray[n4++] = (char)nibble2code[by4 & 0x3F];
        }
        switch (n5) {
            case 0: {
                break;
            }
            case 1: {
                by3 = byArray[n2++];
                cArray[n4++] = (char)nibble2code[by3 >>> 2 & 0x3F];
                cArray[n4++] = (char)nibble2code[by3 << 4 & 0x3F];
                cArray[n4++] = 61;
                cArray[n4++] = 61;
                break;
            }
            case 2: {
                by3 = byArray[n2++];
                by2 = byArray[n2++];
                cArray[n4++] = (char)nibble2code[by3 >>> 2 & 0x3F];
                cArray[n4++] = (char)nibble2code[by3 << 4 & 0x3F | by2 >>> 4 & 0xF];
                cArray[n4++] = (char)nibble2code[by2 << 2 & 0x3F];
                cArray[n4++] = 61;
                break;
            }
            default: {
                throw new IllegalStateException("should not happen");
            }
        }
    }

    public static LinkedBuffer encode(byte[] byArray, int n2, int n3, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n4 = (n3 + 2) / 3 * 4;
        writeSession.size += n4;
        int n5 = linkedBuffer.buffer.length - linkedBuffer.offset;
        if (n4 > n5) {
            int n6 = n5 / 4;
            if (n6 == 0) {
                if (n4 > writeSession.nextBufferSize) {
                    byte[] byArray2 = new byte[n4];
                    B64Code.encode(byArray, n2, n3, byArray2, 0);
                    return new LinkedBuffer(writeSession.nextBufferSize, new LinkedBuffer(byArray2, 0, n4, linkedBuffer));
                }
                byte[] byArray3 = new byte[writeSession.nextBufferSize];
                B64Code.encode(byArray, n2, n3, byArray3, 0);
                return new LinkedBuffer(byArray3, 0, n4, linkedBuffer);
            }
            int n7 = n2;
            byte[] byArray4 = linkedBuffer.buffer;
            int n8 = linkedBuffer.offset;
            while (n6-- > 0) {
                byte by2 = byArray[n2++];
                byte by3 = byArray[n2++];
                byte by4 = byArray[n2++];
                byArray4[n8++] = nibble2code[by2 >>> 2 & 0x3F];
                byArray4[n8++] = nibble2code[by2 << 4 & 0x3F | by3 >>> 4 & 0xF];
                byArray4[n8++] = nibble2code[by3 << 2 & 0x3F | by4 >>> 6 & 3];
                byArray4[n8++] = nibble2code[by4 & 0x3F];
            }
            n3 -= n2 - n7;
            linkedBuffer.offset = n8;
            if ((n4 -= n8 - linkedBuffer.offset) > writeSession.nextBufferSize) {
                byte[] byArray5 = new byte[n4];
                B64Code.encode(byArray, n2, n3, byArray5, 0);
                return new LinkedBuffer(writeSession.nextBufferSize, new LinkedBuffer(byArray5, 0, n4, linkedBuffer));
            }
            byte[] byArray6 = new byte[writeSession.nextBufferSize];
            B64Code.encode(byArray, n2, n3, byArray6, 0);
            return new LinkedBuffer(byArray6, 0, n4, linkedBuffer);
        }
        B64Code.encode(byArray, n2, n3, linkedBuffer.buffer, linkedBuffer.offset);
        linkedBuffer.offset += n4;
        return linkedBuffer;
    }

    public static LinkedBuffer sencode(byte[] byArray, int n2, int n3, WriteSession writeSession, LinkedBuffer linkedBuffer) {
        int n4 = (n3 + 2) / 3 * 4;
        writeSession.size += n4;
        int n5 = linkedBuffer.buffer.length - linkedBuffer.offset;
        if (n4 > n5) {
            byte by2;
            byte by3;
            byte[] byArray2 = linkedBuffer.buffer;
            int n6 = linkedBuffer.offset;
            int n7 = n3 % 3;
            int n8 = n5 / 4;
            int n9 = n2 + (n3 - n7);
            while (n2 < n9) {
                if (n8 == 0) {
                    n6 = writeSession.flush(byArray2, linkedBuffer.start, n6 - linkedBuffer.start);
                    n8 = (byArray2.length - n6) / 4;
                }
                by3 = byArray[n2++];
                by2 = byArray[n2++];
                byte by4 = byArray[n2++];
                byArray2[n6++] = nibble2code[by3 >>> 2 & 0x3F];
                byArray2[n6++] = nibble2code[by3 << 4 & 0x3F | by2 >>> 4 & 0xF];
                byArray2[n6++] = nibble2code[by2 << 2 & 0x3F | by4 >>> 6 & 3];
                byArray2[n6++] = nibble2code[by4 & 0x3F];
                --n8;
            }
            switch (n7) {
                case 0: {
                    break;
                }
                case 1: {
                    if (n8 == 0) {
                        n6 = writeSession.flush(byArray2, linkedBuffer.start, n6 - linkedBuffer.start);
                    }
                    by3 = byArray[n2++];
                    byArray2[n6++] = nibble2code[by3 >>> 2 & 0x3F];
                    byArray2[n6++] = nibble2code[by3 << 4 & 0x3F];
                    byArray2[n6++] = 61;
                    byArray2[n6++] = 61;
                    break;
                }
                case 2: {
                    if (n8 == 0) {
                        n6 = writeSession.flush(byArray2, linkedBuffer.start, n6 - linkedBuffer.start);
                    }
                    by3 = byArray[n2++];
                    by2 = byArray[n2++];
                    byArray2[n6++] = nibble2code[by3 >>> 2 & 0x3F];
                    byArray2[n6++] = nibble2code[by3 << 4 & 0x3F | by2 >>> 4 & 0xF];
                    byArray2[n6++] = nibble2code[by2 << 2 & 0x3F];
                    byArray2[n6++] = 61;
                    break;
                }
                default: {
                    throw new IllegalStateException("should not happen");
                }
            }
            linkedBuffer.offset = n6;
            return linkedBuffer;
        }
        B64Code.encode(byArray, n2, n3, linkedBuffer.buffer, linkedBuffer.offset);
        linkedBuffer.offset += n4;
        return linkedBuffer;
    }

    public static byte[] decode(byte[] byArray) {
        return B64Code.decode(byArray, 0, byArray.length);
    }

    public static byte[] cdecode(char[] cArray) {
        return B64Code.cdecode(cArray, 0, cArray.length);
    }

    public static byte[] decode(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return ByteString.EMPTY_BYTE_ARRAY;
        }
        if (n3 % 4 != 0) {
            throw new IllegalArgumentException("Input block size is not 4");
        }
        int n4 = n3;
        int n5 = n2 + n3;
        while (byArray[--n5] == 61) {
            --n4;
        }
        int n6 = n4 * 3 / 4;
        byte[] byArray2 = new byte[n6];
        B64Code.decode(byArray, n2, n3, byArray2, 0, n6);
        return byArray2;
    }

    public static byte[] cdecode(char[] cArray, int n2, int n3) {
        if (n3 == 0) {
            return ByteString.EMPTY_BYTE_ARRAY;
        }
        if (n3 % 4 != 0) {
            throw new IllegalArgumentException("Input block size is not 4");
        }
        int n4 = n3;
        int n5 = n2 + n3;
        while (cArray[--n5] == '=') {
            --n4;
        }
        int n6 = n4 * 3 / 4;
        byte[] byArray = new byte[n6];
        B64Code.cdecode(cArray, n2, n3, byArray, 0, n6);
        return byArray;
    }

    public static int decodeTo(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        if (n4 == 0) {
            return 0;
        }
        if (n4 % 4 != 0) {
            throw new IllegalArgumentException("Input block size is not 4");
        }
        int n5 = n4;
        int n6 = n3 + n4;
        while (byArray2[--n6] == 61) {
            --n5;
        }
        int n7 = n5 * 3 / 4;
        assert (byArray.length - n2 >= n7);
        B64Code.decode(byArray2, n3, n4, byArray, n2, n7);
        return n7;
    }

    private static void decode(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        int n6 = n5 / 3 * 3;
        try {
            byte by2;
            byte by3;
            byte by4;
            while (n4 < n6) {
                by4 = code2nibble[byArray[n2++]];
                by3 = code2nibble[byArray[n2++]];
                by2 = code2nibble[byArray[n2++]];
                byte by5 = code2nibble[byArray[n2++]];
                if (by4 < 0 || by3 < 0 || by2 < 0 || by5 < 0) {
                    throw new IllegalArgumentException("Not B64 encoded");
                }
                byArray2[n4++] = (byte)(by4 << 2 | by3 >>> 4);
                byArray2[n4++] = (byte)(by3 << 4 | by2 >>> 2);
                byArray2[n4++] = (byte)(by2 << 6 | by5);
            }
            if (n5 != n4) {
                switch (n5 % 3) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        by4 = code2nibble[byArray[n2++]];
                        by3 = code2nibble[byArray[n2++]];
                        if (by4 < 0 || by3 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        byArray2[n4++] = (byte)(by4 << 2 | by3 >>> 4);
                        break;
                    }
                    case 2: {
                        by4 = code2nibble[byArray[n2++]];
                        by3 = code2nibble[byArray[n2++]];
                        by2 = code2nibble[byArray[n2++]];
                        if (by4 < 0 || by3 < 0 || by2 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        byArray2[n4++] = (byte)(by4 << 2 | by3 >>> 4);
                        byArray2[n4++] = (byte)(by3 << 4 | by2 >>> 2);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("should not happen");
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("char " + n2 + " was not B64 encoded");
        }
    }

    private static void cdecode(char[] cArray, int n2, int n3, byte[] byArray, int n4, int n5) {
        int n6 = n5 / 3 * 3;
        try {
            byte by2;
            byte by3;
            byte by4;
            while (n4 < n6) {
                by4 = code2nibble[cArray[n2++]];
                by3 = code2nibble[cArray[n2++]];
                by2 = code2nibble[cArray[n2++]];
                byte by5 = code2nibble[cArray[n2++]];
                if (by4 < 0 || by3 < 0 || by2 < 0 || by5 < 0) {
                    throw new IllegalArgumentException("Not B64 encoded");
                }
                byArray[n4++] = (byte)(by4 << 2 | by3 >>> 4);
                byArray[n4++] = (byte)(by3 << 4 | by2 >>> 2);
                byArray[n4++] = (byte)(by2 << 6 | by5);
            }
            if (n5 != n4) {
                switch (n5 % 3) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        by4 = code2nibble[cArray[n2++]];
                        by3 = code2nibble[cArray[n2++]];
                        if (by4 < 0 || by3 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        byArray[n4++] = (byte)(by4 << 2 | by3 >>> 4);
                        break;
                    }
                    case 2: {
                        by4 = code2nibble[cArray[n2++]];
                        by3 = code2nibble[cArray[n2++]];
                        by2 = code2nibble[cArray[n2++]];
                        if (by4 < 0 || by3 < 0 || by2 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        byArray[n4++] = (byte)(by4 << 2 | by3 >>> 4);
                        byArray[n4++] = (byte)(by3 << 4 | by2 >>> 2);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("should not happen");
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("char " + n2 + " was not B64 encoded");
        }
    }

    public static byte[] decode(String string) {
        return B64Code.decode(string, 0, string.length());
    }

    public static byte[] decode(String string, int n2, int n3) {
        if (n3 == 0) {
            return new byte[0];
        }
        if (n3 % 4 != 0) {
            throw new IllegalArgumentException("Input block size is not 4");
        }
        int n4 = n3;
        int n5 = n2 + n3;
        while (string.charAt(--n5) == '=') {
            --n4;
        }
        int n6 = n4 * 3 / 4;
        byte[] byArray = new byte[n6];
        B64Code.decode(string, n2, n3, byArray, 0, n6);
        return byArray;
    }

    public static int decodeTo(byte[] byArray, int n2, String string, int n3, int n4) {
        if (n4 == 0) {
            return 0;
        }
        if (n4 % 4 != 0) {
            throw new IllegalArgumentException("Input block size is not 4");
        }
        int n5 = n4;
        int n6 = n3 + n4;
        while (string.charAt(--n6) == '=') {
            --n5;
        }
        int n7 = n5 * 3 / 4;
        assert (byArray.length - n2 >= n7);
        B64Code.decode(string, n3, n4, byArray, n2, n7);
        return n7;
    }

    private static void decode(String string, int n2, int n3, byte[] byArray, int n4, int n5) {
        int n6 = n5 / 3 * 3;
        try {
            byte by2;
            byte by3;
            byte by4;
            while (n4 < n6) {
                by4 = code2nibble[string.charAt(n2++)];
                by3 = code2nibble[string.charAt(n2++)];
                by2 = code2nibble[string.charAt(n2++)];
                byte by5 = code2nibble[string.charAt(n2++)];
                if (by4 < 0 || by3 < 0 || by2 < 0 || by5 < 0) {
                    throw new IllegalArgumentException("Not B64 encoded");
                }
                byArray[n4++] = (byte)(by4 << 2 | by3 >>> 4);
                byArray[n4++] = (byte)(by3 << 4 | by2 >>> 2);
                byArray[n4++] = (byte)(by2 << 6 | by5);
            }
            if (n5 != n4) {
                switch (n5 % 3) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        by4 = code2nibble[string.charAt(n2++)];
                        by3 = code2nibble[string.charAt(n2++)];
                        if (by4 < 0 || by3 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        byArray[n4++] = (byte)(by4 << 2 | by3 >>> 4);
                        break;
                    }
                    case 2: {
                        by4 = code2nibble[string.charAt(n2++)];
                        by3 = code2nibble[string.charAt(n2++)];
                        by2 = code2nibble[string.charAt(n2++)];
                        if (by4 < 0 || by3 < 0 || by2 < 0) {
                            throw new IllegalArgumentException("Not B64 encoded");
                        }
                        byArray[n4++] = (byte)(by4 << 2 | by3 >>> 4);
                        byArray[n4++] = (byte)(by3 << 4 | by2 >>> 2);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("should not happen");
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("char " + n2 + " was not B64 encoded");
        }
    }

    static {
        int n2;
        nibble2code = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        code2nibble = new byte[256];
        for (n2 = 0; n2 < 256; ++n2) {
            B64Code.code2nibble[n2] = -1;
        }
        for (n2 = 0; n2 < 64; n2 = (int)((byte)(n2 + 1))) {
            B64Code.code2nibble[B64Code.nibble2code[n2]] = n2;
        }
        B64Code.code2nibble[61] = 0;
    }
}

