/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.itemsadder.api;

import dev.lone.itemsadder.api.CustomStack;
import ia.m.G;
import ia.m.bA;
import ia.m.eM;
import ia.m.rb;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.Nullable;

public class CustomFurniture
extends CustomStack {
    private static final Set EMPTY_SET = new HashSet();
    Entity entity;
    private bA behaviour;

    public static Set getNamespacedIdsInRegistry() {
        Collection collection = G.a().a("furniture");
        if (collection == null) {
            return EMPTY_SET;
        }
        return collection;
    }

    CustomFurniture(eM eM2, Entity entity) {
        super(eM2);
        this.entity = entity;
        this.initItemStack(entity);
    }

    CustomFurniture(eM eM2, ItemStack itemStack, Entity entity, bA bA2) {
        super(eM2, itemStack);
        this.entity = entity;
        this.behaviour = bA2;
        this.initItemStack(entity);
    }

    private void initItemStack(Entity entity) {
        ItemStack itemStack;
        if (entity instanceof ArmorStand) {
            itemStack = ((ArmorStand)entity).getHelmet();
        } else if (entity instanceof ItemFrame) {
            itemStack = ((ItemFrame)entity).getItem();
        } else {
            throw new RuntimeException("This furniture entity somehow is not an armorstand or itemframe.");
        }
        this.itemStack = itemStack;
    }

    @Nullable
    public static CustomFurniture byAlreadySpawned(Entity entity) {
        ItemStack itemStack = null;
        if (entity instanceof ArmorStand) {
            itemStack = ((ArmorStand)entity).getHelmet();
        } else if (entity instanceof ItemFrame) {
            itemStack = ((ItemFrame)entity).getItem().clone();
        }
        if (!eM.isCustomItem(itemStack)) {
            return null;
        }
        eM eM2 = G.a().a(itemStack);
        if (eM2 == null) {
            return null;
        }
        bA bA2 = (bA)eM2.a.a("furniture");
        if (bA2 == null) {
            return null;
        }
        return new CustomFurniture(eM2, entity);
    }

    @Nullable
    public static CustomFurniture byAlreadySpawned(Block block) {
        Optional optional = block.getLocation().getWorld().getNearbyEntities(block.getLocation(), 0.1, 0.1, 0.1).stream().findFirst();
        if (optional.isPresent()) {
            return CustomFurniture.byAlreadySpawned((Entity)optional.get());
        }
        return null;
    }

    @Nullable
    public static CustomFurniture spawnPreciseNonSolid(String string, Location location) {
        eM eM2 = G.a().a(string);
        if (eM2 == null) {
            return null;
        }
        if (!eM2.a.l("furniture")) {
            return null;
        }
        ItemStack itemStack = eM2.a();
        bA bA2 = (bA)eM2.a.a("furniture");
        Entity entity = bA2.a(itemStack, location);
        return new CustomFurniture(eM2, itemStack, entity, bA2);
    }

    @Nullable
    public static CustomFurniture spawn(String string, Block block) {
        eM eM2 = G.a().a(string);
        if (eM2 == null) {
            return null;
        }
        if (!eM2.a.l("furniture")) {
            return null;
        }
        ItemStack itemStack = eM2.a();
        bA bA2 = (bA)eM2.a.a("furniture");
        Entity entity = bA2.a(itemStack, block);
        return new CustomFurniture(eM2, itemStack, entity, bA2);
    }

    public void remove(boolean bl2) {
        if (this.entity != null) {
            CustomFurniture.remove(this.entity, bl2);
        }
    }

    public static void remove(Entity entity, boolean bl2) {
        G.a().a.a(entity, bl2);
    }

    public void teleport(Entity entity) {
        this.teleport(entity.getLocation());
    }

    public void teleport(Location location) {
        if (this.entity != null) {
            if (this.behaviour.Y()) {
                this.behaviour.g(this.entity);
            }
            this.entity.teleport(location);
        }
    }

    public void replaceFurniture(String string) {
        this.replaceFurniture(string, null);
    }

    public void replaceFurniture(String string, Color color) {
        eM eM2 = G.a().a(string);
        if (eM2 == null) {
            throw new NoSuchElementException("No custom item with that namespacedId: " + string);
        }
        if (!eM2.a.l("furniture")) {
            throw new NoSuchElementException("Custom item has no furniture behaviour with that namespacedId: " + string);
        }
        if (bA.a(eM2, this.internalItem, this.entity)) {
            this.replace(this.itemStack, eM2);
            this.itemStack = eM2.a();
            this.itemStack = bA.a(this.itemStack);
            if (color != null) {
                this.setColor(color);
            } else if (this.entity instanceof ArmorStand) {
                ((ArmorStand)this.entity).setHelmet(this.itemStack);
            } else if (this.entity instanceof ItemFrame) {
                ((ItemFrame)this.entity).setItem(this.itemStack, false);
            }
        }
    }

    public void setColor(Color color) {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            ((PotionMeta)itemMeta).setColor(color);
            this.itemStack.setItemMeta(itemMeta);
        } else if (itemMeta instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)itemMeta).setColor(color);
            this.itemStack.setItemMeta(itemMeta);
        }
        if (this.entity instanceof ArmorStand) {
            ((ArmorStand)this.entity).setHelmet(this.itemStack);
        } else if (this.entity instanceof ItemFrame) {
            ((ItemFrame)this.entity).setItem(this.itemStack, false);
        }
    }

    public int getOriginalLightLevel() {
        return this.behaviour.m();
    }

    public void setCurrentLightLevel(int n2) {
        rb.W(this.entity.getLocation().getBlock());
        rb.d(this.entity.getLocation().getBlock(), n2);
    }

    @Deprecated
    @Nullable
    public Entity getArmorstand() {
        return this.entity;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }
}

